/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.inspector.ui.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.inspector.ui.model.InspectedComponent;
import org.eclipse.jubula.client.inspector.ui.model.InspectorTreeNode;
import org.eclipse.jubula.client.inspector.ui.provider.labelprovider.InspectorLabelProvider;
import org.eclipse.jubula.client.ui.views.NonSortedPropertySheetPage;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class InspectorView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.jubula.client.inspector.views.inspectorView";
    private TreeViewer m_treeViewer;
    private PropertyChangeListener m_propChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            final TreeNode[] input = InspectorView.this.convertToViewerModel(InspectedComponent.getInstance().getCompId());
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    InspectorView.this.m_treeViewer.setInput((Object)input);
                    InspectorView.this.m_treeViewer.expandAll();
                }
            });
            if (input != null) {
                display.syncExec(new Runnable(){

                    public void run() {
                        TreeNode element = input[0];
                        while (element != null && element.hasChildren()) {
                            element = element.getChildren()[0];
                        }
                        if (element != null) {
                            InspectorView.this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                        }
                    }
                });
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.m_treeViewer = new TreeViewer(parent);
        this.m_treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new InspectorLabelProvider());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.m_treeViewer);
        this.m_treeViewer.setInput((Object)this.convertToViewerModel(InspectedComponent.getInstance().getCompId()));
        this.m_treeViewer.expandAll();
        InspectedComponent.getInstance().addPropertyChangeListener(this.m_propChangeListener);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.m_treeViewer.getTree());
        this.m_treeViewer.getTree().setMenu(menu);
        this.getViewSite().registerContextMenu(VIEW_ID, menuMgr, (ISelectionProvider)this.m_treeViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.m_treeViewer.getControl(), "org.eclipse.jubula.client.ua.help.inspectorViewContextId");
    }

    public void setFocus() {
        this.m_treeViewer.getTree().setFocus();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return new NonSortedPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public void dispose() {
        InspectedComponent.getInstance().removePropertyChangeListener(this.m_propChangeListener);
        super.dispose();
    }

    private InspectorTreeNode[] convertToViewerModel(IComponentIdentifier compId) {
        InspectorTreeNode rootNode;
        if (compId == null) {
            return null;
        }
        List hierarchyList = compId.getHierarchyNames();
        if (hierarchyList == null || hierarchyList.isEmpty()) {
            return null;
        }
        String[] hierarchy = hierarchyList.toArray(new String[hierarchyList.size()]);
        InspectorTreeNode node = rootNode = new InspectorTreeNode(hierarchy);
        int i = 1;
        while (i < hierarchy.length) {
            String[] childData = new String[hierarchy.length - i];
            System.arraycopy(hierarchy, i, childData, 0, childData.length);
            InspectorTreeNode child = new InspectorTreeNode(childData);
            TreeNode[] nodeChildren = node.getChildren();
            if (nodeChildren == null) {
                nodeChildren = new TreeNode[]{};
            }
            TreeNode[] newNodeChildren = new TreeNode[nodeChildren.length + 1];
            System.arraycopy(nodeChildren, 0, newNodeChildren, 0, nodeChildren.length);
            newNodeChildren[newNodeChildren.length - 1] = child;
            node.setChildren(newNodeChildren);
            child.setParent(node);
            node = child;
            ++i;
        }
        return new InspectorTreeNode[]{rootNode};
    }
}

