(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "dockerfile-ast"], factory);
    }
})(function (require, exports) {
    /* --------------------------------------------------------------------------------------------
     * Copyright (c) Remy Suen. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     * ------------------------------------------------------------------------------------------ */
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var dockerfile_ast_1 = require("dockerfile-ast");
    var DockerSymbols = /** @class */ (function () {
        function DockerSymbols() {
        }
        DockerSymbols.prototype.createSymbolInformation = function (name, textDocumentURI, range, kind, deprecated) {
            if (deprecated) {
                return {
                    name: name,
                    location: {
                        uri: textDocumentURI,
                        range: range
                    },
                    kind: kind,
                    deprecated: true
                };
            }
            return {
                name: name,
                location: {
                    uri: textDocumentURI,
                    range: range
                },
                kind: kind
            };
        };
        DockerSymbols.prototype.parseSymbolInformation = function (textDocument, content) {
            var dockerfile = dockerfile_ast_1.DockerfileParser.parse(content);
            var directive = dockerfile.getDirective();
            var symbols = [];
            if (directive !== null) {
                symbols.push(this.createSymbolInformation(directive.getName(), textDocument.uri, directive.getNameRange(), vscode_languageserver_types_1.SymbolKind.Property, false));
            }
            for (var _i = 0, _a = dockerfile.getInstructions(); _i < _a.length; _i++) {
                var instruction = _a[_i];
                var keyword = instruction.getKeyword();
                symbols.push(this.createSymbolInformation(instruction.getInstruction(), textDocument.uri, instruction.getInstructionRange(), vscode_languageserver_types_1.SymbolKind.Function, keyword === dockerfile_ast_1.Keyword.MAINTAINER));
            }
            return symbols;
        };
        return DockerSymbols;
    }());
    exports.DockerSymbols = DockerSymbols;
});
