/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import java.util.Arrays;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProgressDistributor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MONITOR, ProgressDistributor.class);
    private double[] distribution;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <CONTEXT> void run(ProgressDistributable<CONTEXT>[] distributables, CONTEXT context, OMMonitor monitor) throws RuntimeException, WrappedException {
        int i;
        double[] distributionCopy;
        ProgressDistributor progressDistributor = this;
        synchronized (progressDistributor) {
            if (this.distribution == null) {
                this.distribution = new double[distributables.length];
                Arrays.fill(this.distribution, 1.0);
            } else {
                CheckUtil.checkArg(this.distribution.length == distributables.length, "distributables.length");
            }
            distributionCopy = new double[this.distribution.length];
            System.arraycopy(this.distribution, 0, distributionCopy, 0, this.distribution.length);
        }
        double total = 0.0;
        int i2 = 0;
        while (i2 < distributionCopy.length) {
            total += distributionCopy[i2];
            ++i2;
        }
        if (TRACER.isEnabled()) {
            StringBuilder builder = new StringBuilder("Distribution: ");
            i = 0;
            while (i < distributionCopy.length) {
                builder.append(distributionCopy[i] * 100.0 / total);
                builder.append("%, ");
                ++i;
            }
            builder.append("(");
            builder.append(this);
            builder.append(")");
            TRACER.trace(builder.toString());
        }
        monitor.begin(total);
        try {
            double[] times = new double[distributables.length];
            i = 0;
            while (i < distributables.length) {
                ProgressDistributable<CONTEXT> distributable = distributables[i];
                int count = distributable.getLoopCount(context);
                double work = distributable.getLoopWork(context);
                OMMonitor distributableMonitor = monitor.fork(distributionCopy[i]);
                distributableMonitor.begin(work * (double)count);
                try {
                    long start = System.currentTimeMillis();
                    int loop = 0;
                    while (loop < count) {
                        try {
                            distributable.runLoop(loop, context, distributableMonitor);
                        }
                        catch (Exception ex) {
                            throw WrappedException.wrap(ex);
                        }
                        ++loop;
                    }
                    times[i] = (double)(System.currentTimeMillis() - start) / (double)count;
                }
                finally {
                    distributableMonitor.done();
                }
                ++i;
            }
            ProgressDistributor progressDistributor2 = this;
            synchronized (progressDistributor2) {
                this.distribute(this.distribution, times);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void distribute(double[] var1, double[] var2);

    public static <CONTEXT> ProgressDistributable<CONTEXT>[] array(ProgressDistributable<CONTEXT> ... ops) {
        return ops;
    }

    public static class Arithmetic
    extends ProgressDistributor {
        private long count;
        private double[] times;

        protected void distribute(double[] distribution, double[] times) {
            ++this.count;
            int i = 0;
            while (i < times.length) {
                int n = i;
                this.times[n] = this.times[n] + times[i];
                distribution[i] = this.times[i] / (double)this.count;
                ++i;
            }
        }
    }

    public static class Geometric
    extends ProgressDistributor {
        protected void distribute(double[] distribution, double[] times) {
            int i = 0;
            while (i < times.length) {
                distribution[i] = (distribution[i] + times[i]) / 2.0;
                ++i;
            }
        }
    }
}

