/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.objectteams.otdt.debug.TeamInstance;
import org.eclipse.objectteams.otdt.debug.ui.OTDebugImages;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.ActionMessages;
import org.eclipse.objectteams.otdt.debug.ui.views.TeamView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ChangeTeamActivationAction
extends SelectionProviderAction {
    private static final String DEACTIVATE = "deactivate";
    private static final String ACTIVATE = "activate";
    private static final String SIGNATURE = "()V";
    private static final String SIGNATURE_THREAD_ARG = "(Ljava/lang/Thread;)V";
    private static final String ALL_THREADS = "ALL_THREADS";
    protected IVariable fVariable;
    private TeamView fView;
    String selector;
    private boolean isActivate;

    public ChangeTeamActivationAction(TeamView view, boolean isActivate) {
        super((ISelectionProvider)view.getViewer(), isActivate ? ActionMessages.ChangeTeamActivationAction_activate_label : ActionMessages.ChangeTeamActivationAction_deactivate_label);
        this.selector = isActivate ? ACTIVATE : DEACTIVATE;
        this.isActivate = isActivate;
        this.setEnabled(false);
        if (isActivate) {
            this.setDescription(ActionMessages.ChangeTeamActivationAction_activate_description);
            this.setImageDescriptor(OTDebugImages.get("icons/team_act.gif"));
        } else {
            this.setDescription(ActionMessages.ChangeTeamActivationAction_deactivate_description);
            this.setImageDescriptor(OTDebugImages.get("icons/team_inact.gif"));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.change_value_action_context");
        this.fView = view;
    }

    protected void doActionPerformed(Object element) {
        if (!(element instanceof TeamInstance)) {
            return;
        }
        TeamInstance teamInstance = (TeamInstance)element;
        try {
            IValue value = teamInstance.getValue();
            if (value instanceof IJavaObject) {
                IJavaObject teamObject = (IJavaObject)value;
                String methodSignature = SIGNATURE;
                IJavaValue[] args = null;
                IJavaThread thread = this.fView.getSelectedThread();
                if (thread == null) {
                    methodSignature = SIGNATURE_THREAD_ARG;
                    IJavaFieldVariable field = teamObject.getField(ALL_THREADS, true);
                    args = new IJavaValue[]{(IJavaValue)field.getValue()};
                    IDebugTarget target = teamObject.getDebugTarget();
                    IThread[] iThreadArray = target.getThreads();
                    int n = iThreadArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IThread tThread = iThreadArray[n2];
                        if (tThread.isSuspended()) {
                            thread = (IJavaThread)tThread;
                            break;
                        }
                        ++n2;
                    }
                    if (thread == null) {
                        String cause = ActionMessages.ChangeTeamActivationAction_error_no_thread_suspended;
                        DebugUIPlugin.errorDialog((Shell)this.fView.getViewSite().getShell(), (String)ActionMessages.ChangeTeamActivationAction_error_title, (String)cause, (IStatus)new Status(4, "org.eclipse.objectteams.otdt.debug.ui", cause));
                        return;
                    }
                }
                teamObject.sendMessage(this.selector, methodSignature, args, thread, false);
                Viewer viewer = this.fView.getViewer();
                viewer.setSelection(viewer.getSelection());
            }
        }
        catch (DebugException de) {
            DebugUIPlugin.errorDialog((Shell)this.fView.getViewSite().getShell(), (String)ActionMessages.ChangeTeamActivationAction_error_title, (String)ActionMessages.ChangeTeamActivationAction_error_exception, (Throwable)de);
        }
    }

    protected void update(IStructuredSelection sel) {
        TeamInstance instance;
        Object object;
        if (sel.size() > 1) {
            this.setEnabled(false);
            return;
        }
        Iterator iter = sel.iterator();
        if (iter.hasNext() && (object = iter.next()) instanceof TeamInstance && (instance = (TeamInstance)object).isActiveFor((IThread)this.fView.getSelectedThread()) != this.isActivate) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        this.doActionPerformed(iterator.next());
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.update(sel);
    }
}

