/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;
import org.eclipse.pde.internal.ui.correction.OptionalMessageDialog;
import org.eclipse.pde.internal.ui.preferences.PDECompilersConfigurationBlock;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolutionRelevance;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureProblemSeverityForPDECompilerResolution
extends AbstractManifestMarkerResolution
implements IJavaCompletionProposal,
IMarkerResolutionRelevance {
    private static final String CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID = "configure_problem_severity_dialog_id_compiler";
    String id = "";

    public ConfigureProblemSeverityForPDECompilerResolution(IMarker mker, int type, String key) {
        super(type, mker);
        this.id = key;
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)PDEUIMessages.ConfigureProblemSeverityForPDECompiler_6, (Object)this.marker.getAttribute("message", null));
    }

    public String getLabel() {
        return PDEUIMessages.ConfigureProblemSeverityForPDECompiler_0;
    }

    @Override
    public void run(IMarker marker) {
        String pageId;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        boolean isManifestCompilerOption = this.isManifestCompilerOption();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("select_option_key", this.id);
        data.put("select_option_qualifier", "org.eclipse.pde");
        if (!isManifestCompilerOption) {
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.pde.ui.CompilersPreferencePage", null, data).open();
            return;
        }
        IJavaProject project = JavaCore.create((IProject)marker.getResource().getProject());
        boolean hasProjectOptions = this.hasProjectSpecificOptions();
        boolean showPropertyPage = false;
        if (!hasProjectOptions) {
            String[] buttons;
            String message = MessageFormat.format((String)PDEUIMessages.ConfigureProblemSeverityForPDECompiler_1, (Object[])new Object[]{JavaElementLabels.getElementLabel((IJavaElement)project, (long)JavaElementLabels.ALL_DEFAULT)});
            int result = OptionalMessageDialog.open(CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID, shell, PDEUIMessages.ConfigureProblemSeverityForPDECompiler_4, null, message, 3, buttons = new String[]{PDEUIMessages.ConfigureProblemSeverityForPDECompiler_2, PDEUIMessages.ConfigureProblemSeverityForPDECompiler_3, IDialogConstants.CANCEL_LABEL}, 0, PDEUIMessages.ConfigureProblemSeverityForPDECompiler_5);
            if (result == 1025) {
                showPropertyPage = false;
            } else {
                if (result == 2 || result == -1) {
                    return;
                }
                showPropertyPage = result == 0;
            }
        } else {
            showPropertyPage = true;
        }
        if (showPropertyPage) {
            pageId = "org.eclipse.pde.internal.ui.properties.compilersPropertyPage";
            data.put("use_project_specific_key", Boolean.TRUE);
        } else {
            pageId = "org.eclipse.pde.ui.CompilersPreferencePage";
        }
        if (showPropertyPage) {
            PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)pageId, null, data).open();
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, null, data).open();
        }
    }

    private boolean isManifestCompilerOption() {
        String str = this.marker.getAttribute("compilerKey", "");
        return str.length() <= 0 || !str.equals("compilers.s.open-tags") && !str.equals("compilers.f.unresolved-features") && !str.equals("compilers.f.unresolved-plugins");
    }

    private boolean hasProjectSpecificOptions() {
        IJavaProject project = JavaCore.create((IProject)this.marker.getResource().getProject());
        PDECompilersConfigurationBlock.Key[] keys = PDECompilersConfigurationBlock.getAllKeys();
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project.getProject());
            int i = 0;
            while (i < keys.length) {
                if (keys[i].getStoredValue((IScopeContext)projectContext, null) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            IMarker iMarker = iMarkerArray[n2];
            if (!iMarker.equals((Object)this.marker) && (str = iMarker.getAttribute("compilerKey", "")).equals(this.id)) {
                mset.add(iMarker);
            }
            ++n2;
        }
        int size = mset.size();
        return mset.toArray(new IMarker[size]);
    }

    @Override
    protected void createChange(BundleModel model) {
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return -1;
    }

    public int getRelevanceForResolution() {
        return -1;
    }
}

