/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyTrivialMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;

public final class TimelyIdentityMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyTrivialMaskedMemory<Timestamp> {
    public TimelyIdentityMaskedTupleMemory(TupleMask mask, Object owner) {
        super(mask, owner);
        if (!mask.isIdentity()) {
            throw new IllegalArgumentException(mask.toString());
        }
    }

    @Override
    public int getKeysetSize() {
        return this.memory.size();
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.memory.keySet();
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        if (this.memory.containsKey(signature)) {
            return Collections.singleton((Tuple)signature);
        }
        return null;
    }

    @Override
    public Map<Tuple, Timestamp> getWithTimestamp(ITuple signature) {
        Object value = this.memory.get(signature);
        if (value != null) {
            return Collections.singletonMap((Tuple)signature, value);
        }
        return null;
    }

    @Override
    public TimestampReplacement<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        try {
            return this.memory.remove(tuple, timestamp);
        }
        catch (IllegalStateException e) {
            throw this.raiseDuplicateDeletion(tuple);
        }
    }

    @Override
    public TimestampReplacement<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        return this.memory.put(tuple, timestamp);
    }
}

