/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort.TopologicalSorting;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputEnumeratorNode;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.index.ExistenceNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.network.IGroupable;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ProductionNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.FallThroughCapableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.viatra.query.runtime.rete.single.TrimmerNode;

public abstract class CommunicationTracker {
    protected int minGroupId;
    protected int maxGroupId;
    protected final Graph<Node> dependencyGraph = new Graph();
    protected final IncSCCAlg<Node> sccInformationProvider = new IncSCCAlg(this.dependencyGraph);
    protected final Map<Node, CommunicationGroup> groupMap;
    protected final Queue<CommunicationGroup> groupQueue = new PriorityQueue<CommunicationGroup>();

    public CommunicationTracker() {
        this.groupMap = new HashMap<Node, CommunicationGroup>();
    }

    public Graph<Node> getDependencyGraph() {
        return this.dependencyGraph;
    }

    public CommunicationGroup getGroup(Node node) {
        return this.groupMap.get(node);
    }

    private void precomputeGroups() {
        this.groupMap.clear();
        Graph reducedGraph = this.sccInformationProvider.getReducedGraph();
        List representatives = TopologicalSorting.compute((IGraphDataSource)reducedGraph);
        int i = 0;
        while (i < representatives.size()) {
            Iterator representative = (Node)representatives.get(i);
            this.createAndStoreGroup((Node)((Object)representative), i);
            ++i;
        }
        this.minGroupId = 0;
        this.maxGroupId = representatives.size() - 1;
        for (Node node : this.dependencyGraph.getAllNodes()) {
            Node representative = (Node)this.sccInformationProvider.getRepresentative((Object)node);
            CommunicationGroup group = this.groupMap.get(representative);
            if (representative == node) continue;
            this.addToGroup(node, group);
        }
        for (Node node : this.dependencyGraph.getAllNodes()) {
            this.precomputeFallThroughFlag(node);
            this.postProcessNode(node);
        }
        if (!this.groupQueue.isEmpty()) {
            HashSet<CommunicationGroup> oldActiveGroups = new HashSet<CommunicationGroup>(this.groupQueue);
            this.groupQueue.clear();
            for (CommunicationGroup oldGroup : oldActiveGroups) {
                for (Map.Entry<MessageSelector, Collection<Mailbox>> entry : oldGroup.getMailboxes().entrySet()) {
                    for (Mailbox mailbox : entry.getValue()) {
                        CommunicationGroup newGroup = this.groupMap.get(mailbox.getReceiver());
                        newGroup.notifyHasMessage(mailbox, entry.getKey());
                    }
                }
                for (RederivableNode node : oldGroup.getRederivables()) {
                    CommunicationGroup newGroup = this.groupMap.get(node);
                    newGroup.addRederivable(node);
                }
                oldGroup.isEnqueued = false;
            }
        }
    }

    private void addToGroup(Node node, CommunicationGroup group) {
        this.groupMap.put(node, group);
        if (node instanceof Receiver) {
            ((Receiver)node).getMailbox().setCurrentGroup(group);
            if (node instanceof IGroupable) {
                ((IGroupable)((Object)node)).setCurrentGroup(group);
            }
        }
    }

    private void precomputeFallThroughFlag(Node node) {
        Mailbox mailbox;
        CommunicationGroup group = this.groupMap.get(node);
        if (node instanceof Receiver && (mailbox = ((Receiver)node).getMailbox()) instanceof FallThroughCapableMailbox) {
            boolean fallThrough;
            Set directParents = this.dependencyGraph.getSourceNodes((Object)node).distinctValues();
            boolean bl = fallThrough = (!(node instanceof ProductionNode) || directParents.size() <= 0 && (directParents.size() != 1 || !this.trueTrimming((Node)directParents.iterator().next()))) && !(node instanceof ExternalInputEnumeratorNode);
            if (fallThrough) {
                block0: for (Node directParent : directParents) {
                    HashSet<Node> parentsToCheck = new HashSet<Node>();
                    parentsToCheck.add(directParent);
                    if (directParent instanceof DualInputNode) {
                        Indexer secondarySlot;
                        if (directParent instanceof ExistenceNode) {
                            fallThrough = false;
                            break;
                        }
                        DualInputNode dualInput = (DualInputNode)directParent;
                        IterableIndexer primarySlot = dualInput.getPrimarySlot();
                        if (primarySlot != null) {
                            parentsToCheck.add(primarySlot.getActiveNode());
                        }
                        if ((secondarySlot = dualInput.getSecondarySlot()) != null) {
                            parentsToCheck.add(secondarySlot.getActiveNode());
                        }
                    }
                    for (Node parent : parentsToCheck) {
                        CommunicationGroup parentGroup = this.groupMap.get(parent);
                        if ((group == parentGroup || !parentGroup.isRecursive()) && (group != parentGroup || !group.isRecursive() || !(parent instanceof TransitiveClosureNode) && !(parent instanceof IAggregatorNode) && !this.trueTrimming(parent))) continue;
                        fallThrough = false;
                        break block0;
                    }
                }
            }
            ((FallThroughCapableMailbox)mailbox).setFallThrough(fallThrough);
        }
    }

    private boolean trueTrimming(Node node) {
        if (node instanceof TrimmerNode) {
            TupleMask mask = ((TrimmerNode)node).getMask();
            return mask.indices.length != mask.sourceWidth;
        }
        return false;
    }

    public void activateUnenqueued(CommunicationGroup group) {
        this.groupQueue.add(group);
        group.isEnqueued = true;
    }

    public void deactivate(CommunicationGroup group) {
        this.groupQueue.remove(group);
        group.isEnqueued = false;
    }

    public CommunicationGroup getAndRemoveFirstGroup() {
        CommunicationGroup group = this.groupQueue.poll();
        group.isEnqueued = false;
        return group;
    }

    public boolean isEmpty() {
        return this.groupQueue.isEmpty();
    }

    protected abstract CommunicationGroup createGroup(Node var1, int var2);

    protected CommunicationGroup createAndStoreGroup(Node representative, int index) {
        CommunicationGroup group = this.createGroup(representative, index);
        this.addToGroup(representative, group);
        return group;
    }

    public void registerDependency(Node source, Node target) {
        int targetIndex;
        this.dependencyGraph.insertNode((Object)source);
        this.dependencyGraph.insertNode((Object)target);
        Node sourceRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)source);
        Node targetRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)target);
        boolean hadOutgoingEdges = this.sccInformationProvider.hasOutgoingEdges((Object)targetRepresentative);
        this.dependencyGraph.insertEdge((Object)source, (Object)target);
        CommunicationGroup sourceGroup = this.groupMap.get(sourceRepresentative);
        if (sourceGroup == null) {
            sourceGroup = this.createAndStoreGroup(sourceRepresentative, --this.minGroupId);
        }
        int sourceIndex = sourceGroup.identifier;
        CommunicationGroup targetGroup = this.groupMap.get(targetRepresentative);
        if (targetGroup == null) {
            targetGroup = this.createAndStoreGroup(targetRepresentative, ++this.maxGroupId);
        }
        if (sourceIndex <= (targetIndex = targetGroup.identifier)) {
            this.refreshFallThroughFlag(target);
            this.postProcessNode(source);
            this.postProcessNode(target);
        } else if (sourceIndex > targetIndex && !hadOutgoingEdges) {
            boolean wasEnqueued = targetGroup.isEnqueued;
            if (wasEnqueued) {
                this.groupQueue.remove(targetGroup);
            }
            targetGroup.identifier = ++this.maxGroupId;
            if (wasEnqueued) {
                this.groupQueue.add(targetGroup);
            }
            this.refreshFallThroughFlag(target);
            this.postProcessNode(source);
            this.postProcessNode(target);
        } else {
            this.precomputeGroups();
        }
    }

    public boolean isInRecursiveGroup(Node node) {
        CommunicationGroup group = this.getGroup(node);
        if (group == null) {
            return false;
        }
        return group.isRecursive();
    }

    public boolean areInSameGroup(Node left, Node right) {
        CommunicationGroup leftGroup = this.getGroup(left);
        CommunicationGroup rightGroup = this.getGroup(right);
        return leftGroup != null && leftGroup == rightGroup;
    }

    public void unregisterDependency(Node source, Node target) {
        this.dependencyGraph.deleteEdgeIfExists((Object)source, (Object)target);
        Node sourceRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)source);
        Node targetRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)target);
        if (sourceRepresentative.equals(targetRepresentative)) {
            this.refreshFallThroughFlag(target);
        } else {
            this.precomputeGroups();
        }
    }

    private void refreshFallThroughFlag(Node target) {
        this.precomputeFallThroughFlag(target);
        if (target instanceof DualInputNode) {
            for (Node indirectTarget : this.dependencyGraph.getTargetNodes((Object)target).distinctValues()) {
                this.precomputeFallThroughFlag(indirectTarget);
            }
        }
    }

    protected abstract void postProcessNode(Node var1);

    public abstract Mailbox proxifyMailbox(Node var1, Mailbox var2);

    public abstract IndexerListener proxifyIndexerListener(Node var1, IndexerListener var2);
}

