/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication;

import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;

public class ACUserContainer {
    private final ACUser acUser;
    private long lastActive;

    public ACUserContainer(ACUser acUser) {
        this.acUser = acUser;
        this.active();
    }

    public ACUser getUser() throws AccessControlException {
        this.checkLastActive();
        this.active();
        return this.getRawUser();
    }

    public ACUser getRawUser() {
        return this.acUser;
    }

    private void checkLastActive() throws AccessControlException {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.session.timeout", "1800000");
        if (System.currentTimeMillis() - this.lastActive > (long)Integer.parseInt(property)) {
            throw new SessionTimedOutException(Messages.ACUserContainer_Session_Timed_Out);
        }
    }

    public void active() {
        this.lastActive = System.currentTimeMillis();
    }
}

