/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.problems;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.gui.MarkerHandler;
import org.eclipse.jubula.client.teststyle.problems.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProblemCont {
    instance;

    private Map<Object, Set<Problem>> m_problems = Collections.synchronizedMap(new HashMap());

    public void add(Object obj, BaseCheck check) {
        Problem problem = new Problem(check, obj);
        if (!this.m_problems.containsKey(obj)) {
            this.m_problems.put(obj, new CopyOnWriteArraySet());
        }
        if (this.m_problems.get(obj).add(problem)) {
            MarkerHandler.getInstance().add(problem);
        }
    }

    public void remove(Object obj, BaseCheck check) {
        Problem problem = new Problem(check, obj);
        if (this.m_problems.get(obj).remove(problem)) {
            MarkerHandler.getInstance().remove(problem);
        }
        if (this.m_problems.get(obj).size() == 0) {
            this.m_problems.remove(obj);
        }
    }

    public boolean contains(Object obj) {
        return this.m_problems.containsKey(obj);
    }

    public void clear() {
        HashSet<Object> keys = new HashSet<Object>(this.m_problems.keySet());
        for (Object e : keys) {
            this.remove(e);
        }
    }

    public void remove(Object po) {
        Object obj = po;
        if (obj instanceof ITestDataCubePO) {
            obj = ((ITestDataCubePO)obj).getId();
        }
        if (!this.m_problems.containsKey(obj)) {
            return;
        }
        for (Problem p : this.m_problems.get(obj)) {
            MarkerHandler.getInstance().remove(p);
        }
        this.m_problems.remove(obj);
    }

    public Set<BaseCheck> getChecksFor(Object obj) {
        Object newObj = obj;
        if (obj instanceof ITestDataCubePO) {
            newObj = ((ITestDataCubePO)obj).getId();
        }
        HashSet<BaseCheck> checks = new HashSet<BaseCheck>();
        if (this.contains(newObj)) {
            for (Problem p : this.m_problems.get(newObj)) {
                checks.add(p.getCheck());
            }
        }
        return checks;
    }
}

