/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views.dataset;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.TextControlBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.rcp.filter.DataSetFilter;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamTextContentAssisted;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.WorkbenchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSetPage
extends Page
implements ISelectionListener,
IAdaptable,
DataEventDispatcher.IParamChangedListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener {
    protected static final int DATASET_NUMBER_COLUMNWIDTH = 30;
    protected static final int COLUMN_WIDTH = 140;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataSetPage.class);
    private static final long SEARCH_DELAY = 200L;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static Image inactiveImage = null;
    private static Image activeImage = null;
    private static Image pressedImage = null;
    private IPreferenceStore m_store = Plugin.getDefault().getPreferenceStore();
    private DataSetFilter m_filter;
    private Text m_searchText;
    private IParameterInterfacePO m_paramInterfaceObj;
    private Control m_control;
    private TableViewer m_tableViewer;
    private DSVTableCursor m_tableCursor;
    private Button m_addButton;
    private Button m_insertButton;
    private Button m_deleteButton;
    private Button m_upButton;
    private Button m_downButton;
    private Label m_clearButton;
    private ControlEnabler m_controlEnabler;
    private AbstractParamInterfaceBP<?> m_paramBP;
    private IWorkbenchPart m_currentPart;
    private IStructuredSelection m_currentSelection;
    private Long m_paramId;
    private int[] m_columnWidths;
    private int m_columnCount;

    static {
        ImageRegistry imgReg = JFaceResources.getImageRegistry();
        Display display = AbstractDataSetPage.getDisplay();
        if (imgReg != null && display != null) {
            ImageDescriptor disabledClearIcon = imgReg.getDescriptor(DISABLED_CLEAR_ICON);
            ImageDescriptor clearIcon = imgReg.getDescriptor(CLEAR_ICON);
            if (disabledClearIcon != null) {
                inactiveImage = disabledClearIcon.createImage();
            } else {
                LOG.error("Filter: \"Disabled Clear Icon\"-Descriptor could not be found!");
            }
            if (clearIcon != null) {
                activeImage = clearIcon.createImage();
                if (activeImage != null) {
                    pressedImage = new Image((Device)display, activeImage, 2);
                } else {
                    LOG.error("Filter: \"Pressed Clear Icon\" could not be created!");
                }
            } else {
                LOG.error("Filter: \"Clear Icon\"-Descriptor could not be found!");
            }
        }
    }

    public AbstractDataSetPage(AbstractParamInterfaceBP<?> bp) {
        this.setParamBP(bp);
    }

    private void setTableViewer(TableViewer tableViewer) {
        this.m_tableViewer = tableViewer;
    }

    private TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    private Table getTable() {
        return this.getTableViewer().getTable();
    }

    private void checkComboSelection(TestDataRowAction action, int row) {
        this.getTableViewer().refresh();
    }

    public void createControl(Composite parent) {
        Composite topLevelComposite = new Composite(parent, 0);
        topLevelComposite.setData("TEST_COMP_NAME", (Object)"DataSetViewPage");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        topLevelComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        topLevelComposite.setLayoutData((Object)layoutData);
        this.m_control = topLevelComposite;
        Composite buttonComp = new Composite(topLevelComposite, 2048);
        layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        buttonComp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        buttonComp.setLayoutData((Object)gridData);
        this.initTableViewer(buttonComp);
        this.createButtons(buttonComp);
        Plugin.getHelpSystem().setHelp((Control)this.getTable(), "org.eclipse.jubula.client.ua.help.guidancerDataSetViewContextId");
    }

    private void createButtons(Composite parent) {
        Composite bottomComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = 2;
        GridData gridDataBottom = new GridData(0, 0, true, false);
        gridDataBottom.horizontalAlignment = 4;
        gridDataBottom.horizontalSpan = 3;
        bottomComp.setLayoutData((Object)gridDataBottom);
        bottomComp.setLayout((Layout)layout);
        this.setAddButton(new Button(bottomComp, 0x1000008));
        this.getAddButton().setData("TEST_COMP_NAME", (Object)"DataSetView.AddButton");
        this.getAddButton().setText(Messages.JubulaDataSetViewAppend);
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getAddButton().setLayoutData((Object)gridData);
        this.setInsertButton(new Button(bottomComp, 0x1000008));
        this.getInsertButton().setData("TEST_COMP_NAME", (Object)"DataSetView.InsertButton");
        this.getInsertButton().setText(Messages.DataSetViewInsert);
        gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getInsertButton().setLayoutData((Object)gridData);
        this.setDeleteButton(new Button(bottomComp, 0x1000008));
        this.getDeleteButton().setData("TEST_COMP_NAME", (Object)"DataSetView.DeleteButton");
        this.getDeleteButton().setText(Messages.JubulaDataSetViewDelete);
        gridData = new GridData(32);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 80;
        this.getDeleteButton().setLayoutData((Object)gridData);
        this.setDownButton(new Button(bottomComp, 0x1000008));
        this.getDownButton().setData("TEST_COMP_NAME", (Object)"DataSetView.DownButton");
        this.getDownButton().setImage(IconConstants.DOWN_ARROW_IMAGE);
        gridData = new GridData(128);
        this.getDownButton().setLayoutData((Object)gridData);
        this.setUpButton(new Button(bottomComp, 0x1000008));
        this.getUpButton().setData("TEST_COMP_NAME", (Object)"DataSetView.UpButton");
        this.getUpButton().setImage(IconConstants.UP_ARROW_IMAGE);
        gridData = new GridData(128);
        this.getUpButton().setLayoutData((Object)gridData);
        this.addListenerToButtons();
        this.getControlEnabler().setControlsEnabled();
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void createClearFilterButton(Composite parent) {
        this.setClearButton(new Label(parent, 0));
        this.getClearButton().setData("TEST_COMP_NAME", (Object)"DataSetView.ClearFilterButton");
        this.getClearButton().setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.getClearButton().setImage(inactiveImage);
        this.getClearButton().setBackground(parent.getDisplay().getSystemColor(25));
        this.getClearButton().setToolTipText(Messages.DataSetClearFilterButton);
        this.getClearButton().addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener m_moveListener;

            public void mouseDown(MouseEvent e) {
                AbstractDataSetPage.this.getClearButton().setImage(pressedImage);
                this.m_moveListener = new MouseMoveListener(){
                    private boolean m_isMouseInButton = true;

                    public void mouseMove(MouseEvent e2) {
                        boolean isMouseInButton = this.isMouseInButton(e2);
                        if (isMouseInButton != this.m_isMouseInButton) {
                            this.m_isMouseInButton = isMouseInButton;
                            AbstractDataSetPage.this.getClearButton().setImage(isMouseInButton ? pressedImage : inactiveImage);
                        }
                    }
                };
                AbstractDataSetPage.this.getClearButton().addMouseMoveListener(this.m_moveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.m_moveListener != null) {
                    AbstractDataSetPage.this.getClearButton().removeMouseMoveListener(this.m_moveListener);
                    this.m_moveListener = null;
                    boolean isMouseInButton = this.isMouseInButton(e);
                    AbstractDataSetPage.this.getClearButton().setImage(isMouseInButton ? activeImage : inactiveImage);
                    if (isMouseInButton) {
                        AbstractDataSetPage.this.m_searchText.setText("");
                        AbstractDataSetPage.this.m_searchText.setFocus();
                    }
                }
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = AbstractDataSetPage.this.getClearButton().getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        this.getClearButton().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                AbstractDataSetPage.this.getClearButton().setImage(activeImage);
            }

            public void mouseExit(MouseEvent e) {
                AbstractDataSetPage.this.getClearButton().setImage(inactiveImage);
            }
        });
    }

    private boolean useNativeFilter(Composite parent) {
        Text tempText = new Text(parent, 2436);
        boolean usesNative = (tempText.getStyle() & 0x100) != 0;
        tempText.dispose();
        return usesNative;
    }

    private void initTableViewer(Composite parent) {
        this.createFilter(parent);
        this.createTableViewer(parent);
    }

    private void createFilter(Composite parent) {
        this.m_filter = new DataSetFilter();
        boolean usesNativeFilter = this.useNativeFilter(parent);
        Composite filterComposite = !usesNativeFilter ? new Composite(parent, 2048) : new Composite(parent, 0);
        filterComposite.setBackground(AbstractDataSetPage.getDisplay().getSystemColor(25));
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setFont(parent.getFont());
        GridData searchTextGridData = new GridData(4, 0x1000000, true, false);
        if (!usesNativeFilter) {
            this.m_searchText = new Text(filterComposite, 4);
            this.m_searchText.setLayoutData((Object)searchTextGridData);
            this.createClearFilterButton(filterComposite);
        } else {
            this.m_searchText = new Text(filterComposite, 2436);
            searchTextGridData.horizontalSpan = 2;
            this.m_searchText.setLayoutData((Object)searchTextGridData);
        }
        this.updateClearButtonVisibility(false);
        filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 65540);
        this.m_searchText.setMessage(WorkbenchMessages.FilteredTree_FilterMessage);
        WorkbenchJob searchJob = this.createSearchJob();
        this.m_searchText.addModifyListener(new ModifyListener((Job)searchJob){
            private final /* synthetic */ Job val$searchJob;
            {
                this.val$searchJob = job;
            }

            public void modifyText(ModifyEvent e) {
                if (AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor) {
                    if (AbstractDataSetPage.this.m_searchText.getText().isEmpty()) {
                        AbstractDataSetPage.this.updateClearButtonVisibility(false);
                        AbstractDataSetPage.this.updateBackgroundColor(false);
                    } else {
                        AbstractDataSetPage.this.updateClearButtonVisibility(true);
                        AbstractDataSetPage.this.updateBackgroundColor(true);
                    }
                    AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
                } else {
                    AbstractDataSetPage.this.updateClearButtonVisibility(!AbstractDataSetPage.this.m_searchText.getText().isEmpty());
                }
                this.val$searchJob.cancel();
                this.val$searchJob.schedule(200L);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
            }
        });
        this.setTableViewer(viewer);
        Table table = this.getTable();
        table.setData("TEST_COMP_NAME", (Object)"DataSetView.DataTable");
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        this.getTableViewer().setUseHashlookup(true);
        this.getTableViewer().setContentProvider((IContentProvider)new GeneralContentProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new GeneralLabelProvider());
        this.getTableViewer().addFilter((ViewerFilter)this.m_filter);
        this.setTableCursor(new DSVTableCursor(this.getTable(), 0));
    }

    private void updateBackgroundColor(boolean isActive) {
        if (isActive && this.m_store.getBoolean("BACKGROUND_COLORING_KEY")) {
            this.getTableViewer().getControl().setBackground(new Color((Device)Display.getCurrent(), Utils.intToRgb(this.m_store.getInt("BACKGROUND_COLOR_KEY"))));
        } else {
            this.getTableViewer().getControl().setBackground(Display.getCurrent().getSystemColor(1));
        }
    }

    private void updateClearButtonVisibility(boolean isVisible) {
        if (this.getClearButton() != null) {
            this.getClearButton().setVisible(isVisible);
        }
    }

    protected WorkbenchJob createSearchJob() {
        WorkbenchJob job = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AbstractDataSetPage.this.m_filter.setSearchText(AbstractDataSetPage.this.m_searchText.getText());
                AbstractDataSetPage.this.getTableViewer().refresh();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        return job;
    }

    private void logButton(Button but) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder str = new StringBuilder();
        str.append("\nData Set View button \"");
        if (but == this.getDownButton()) {
            str.append("Down");
        } else if (but == this.getUpButton()) {
            str.append("Up");
        } else {
            str.append(but.getText());
        }
        str.append("\" pressed. The row number: ");
        str.append(this.getSelectedDataSet());
        str.append("\nThe data set owner is the node ");
        str.append(this.getParamInterfaceObj().getSpecificationUser().toString());
        str.append(".\n");
        LOG.debug(str.toString());
    }

    private void addListenerToButtons() {
        this.getAddButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.addDataSet();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.ADDED, index);
                AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
                AbstractDataSetPage.this.logButton(AbstractDataSetPage.this.getAddButton());
            }
        });
        this.getInsertButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.insertDataSetAtCurrentSelection();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.INSERTED, index);
                AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
            }
        });
        this.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.removeDataSet();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.DELETED, index);
                AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
                AbstractDataSetPage.this.logButton(AbstractDataSetPage.this.getDeleteButton());
            }
        });
        this.getUpButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.moveDataSetUp();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.MOVED_UP, index);
                AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
                AbstractDataSetPage.this.logButton(AbstractDataSetPage.this.getUpButton());
            }
        });
        this.getDownButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.moveDataSetDown();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.MOVED_DOWN, index);
                AbstractDataSetPage.this.getControlEnabler().setControlsEnabled();
                AbstractDataSetPage.this.logButton(AbstractDataSetPage.this.getDownButton());
            }
        });
    }

    private int getSelectedDataSet() {
        int index = -1;
        try {
            index = Integer.parseInt(this.getTableViewer().getTable().getSelection()[0].getText(0)) - 1;
        }
        catch (Exception exception) {}
        return index;
    }

    private void moveDataSetDown() {
        int row = this.getSelectedDataSet();
        this.moveDataSet(row, row + 1);
    }

    private void moveDataSetUp() {
        int row = this.getSelectedDataSet();
        this.moveDataSet(row, row - 1);
    }

    private void moveDataSet(int fromIndex, int toIndex) {
        int rowCount = this.getParamInterfaceObj().getDataManager().getDataSetCount();
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            ITDManager man;
            if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
                this.getTableViewer().setInput((Object)man);
            }
            ITDManager tdman = this.getParamInterfaceObj().getDataManager();
            if (fromIndex >= 0 && fromIndex < rowCount && toIndex >= 0 && toIndex < rowCount) {
                IDataSetPO selectedDataSet = tdman.getDataSet(fromIndex);
                if (fromIndex > toIndex) {
                    tdman.insertDataSet(selectedDataSet, toIndex);
                    tdman.removeDataSet(fromIndex + 1);
                } else {
                    tdman.insertDataSet(selectedDataSet, toIndex + 1);
                    tdman.removeDataSet(fromIndex);
                }
                this.getTableCursor().setSelection(toIndex, this.getTableCursor().getColumn());
                this.getTableViewer().refresh();
                DataEventDispatcher.getInstance().fireParamChangedListener((Object)this);
                editor.getEditorHelper().setDirty(true);
            }
        }
    }

    private void addDataSet() {
        int rowCount = this.getParamInterfaceObj().getDataManager().getDataSetCount();
        this.insertDataSet(rowCount);
    }

    private void insertDataSetAtCurrentSelection() {
        int row = this.getSelectedDataSet();
        if (row >= 0) {
            this.insertDataSet(row);
        }
    }

    private void insertDataSet(int row) {
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            ITDManager man;
            if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
                this.getTableViewer().setInput((Object)man);
            }
            if (row > -1) {
                this.getParamBP().addDataSet(this.getParamInterfaceObj(), row);
            } else {
                this.addDataSet();
            }
            editor.getEditorHelper().setDirty(true);
            this.getTableViewer().refresh();
            int rowToSelect = row;
            if (rowToSelect == -1) {
                rowToSelect = this.getTable().getItemCount();
            } else {
                this.getTableCursor().setSelection(rowToSelect, 1);
                this.setFocus();
            }
            this.getTable().setSelection(rowToSelect);
            DataEventDispatcher.getInstance().fireParamChangedListener((Object)this);
        }
    }

    public Control getControl() {
        return this.m_control;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void setFocus() {
        this.getTable().setFocus();
    }

    private ControlEnabler getControlEnabler() {
        if (this.m_controlEnabler == null) {
            this.m_controlEnabler = new ControlEnabler();
        }
        return this.m_controlEnabler;
    }

    private void setAddButton(Button addButton) {
        this.m_addButton = addButton;
    }

    private Button getAddButton() {
        return this.m_addButton;
    }

    private void setInsertButton(Button insertButton) {
        this.m_insertButton = insertButton;
    }

    private Button getInsertButton() {
        return this.m_insertButton;
    }

    private void setDeleteButton(Button deleteButton) {
        this.m_deleteButton = deleteButton;
    }

    private Button getDeleteButton() {
        return this.m_deleteButton;
    }

    private void setUpButton(Button upButton) {
        this.m_upButton = upButton;
    }

    private Button getUpButton() {
        return this.m_upButton;
    }

    private void setDownButton(Button downButton) {
        this.m_downButton = downButton;
    }

    private Button getDownButton() {
        return this.m_downButton;
    }

    private void setClearButton(Label clearButton) {
        this.m_clearButton = clearButton;
    }

    private Label getClearButton() {
        return this.m_clearButton;
    }

    private void clearTableViewer() {
        this.getTable().removeAll();
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        DSVTableCursor tableCursor = this.getTableCursor();
        if (tableCursor != null && !tableCursor.isDisposed()) {
            tableCursor.dispose();
            this.setTableCursor(new DSVTableCursor(this.getTable(), 0));
        }
    }

    private String initDataSetColumn() {
        this.clearTableViewer();
        Table table = this.getTable();
        TableColumn dataSetNumberCol = new TableColumn(table, 0);
        dataSetNumberCol.setText(Messages.DataSetViewControllerDataSetNumber);
        if (this.m_columnWidths != null && this.m_columnWidths.length > 0 && this.m_columnCount == table.getColumnCount()) {
            dataSetNumberCol.setWidth(this.m_columnWidths[0]);
        } else {
            dataSetNumberCol.setWidth(30);
        }
        return dataSetNumberCol.getText();
    }

    private void packTable() {
        Table table = this.getTable();
        TableColumn[] columns = table.getColumns();
        int columnCount = columns.length;
        if (this.m_columnWidths != null && this.m_columnWidths.length > 0 && this.m_columnCount == columns.length) {
            columns[0].setWidth(this.m_columnWidths[0]);
        } else {
            columns[0].setWidth(30);
        }
        int i = 1;
        while (i < columnCount) {
            TableColumn column = columns[i];
            column.pack();
            if (this.m_columnWidths != null && this.m_columnWidths.length > i && this.m_columnCount == columns.length) {
                column.setWidth(this.m_columnWidths[i]);
            } else {
                column.setWidth(140);
            }
            ++i;
        }
    }

    private void initTableViewerParameterColumns() {
        int i;
        if (this.getParamInterfaceObj() == null) {
            return;
        }
        Table table = this.getTable();
        if (this.m_paramId == this.getParamInterfaceObj().getId()) {
            TableColumn[] tableColumns = table.getColumns();
            if (tableColumns != null && tableColumns.length != 0) {
                this.m_columnWidths = new int[tableColumns.length];
                i = 0;
                TableColumn[] tableColumnArray = tableColumns;
                int n = tableColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    this.m_columnWidths[i++] = column.getWidth();
                    ++n2;
                }
                this.m_columnCount = tableColumns.length;
            }
        } else {
            this.m_paramId = this.getParamInterfaceObj().getId();
            this.m_columnWidths = null;
        }
        String[] columnProperties = new String[this.getParamInterfaceObj().getParameterList().size() + 1];
        columnProperties[0] = this.initDataSetColumn();
        i = 1;
        int parameterListSize = this.getParamInterfaceObj().getParameterListSize();
        for (IParamDescriptionPO descr : this.getParamInterfaceObj().getParameterList()) {
            TableColumn column = new TableColumn(table, 0);
            String columnName = descr.getName();
            column.setText(columnName);
            columnProperties[i] = columnName;
            if (this.m_columnWidths == null || this.m_columnWidths.length <= i || this.m_columnCount != parameterListSize + 1) {
                column.setWidth(140);
            } else {
                column.setWidth(this.m_columnWidths[i]);
            }
            ++i;
        }
        this.getTableViewer().setColumnProperties(columnProperties);
    }

    private void updateView() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.clearTableViewer();
                IParameterInterfacePO paramObj = AbstractDataSetPage.this.getParamInterfaceObj();
                if (paramObj != null && AbstractDataSetPage.this.isNodeValid(paramObj)) {
                    AbstractDataSetPage.this.getTableViewer().setInput((Object)AbstractDataSetPage.this.getInputForTable(paramObj));
                    AbstractDataSetPage.this.createTable();
                } else {
                    AbstractDataSetPage.this.getTableViewer().setInput(null);
                }
                AbstractDataSetPage.this.getTableViewer().refresh();
            }
        });
    }

    protected abstract boolean isNodeValid(IParameterInterfacePO var1);

    private void createTable() {
        this.initTableViewerParameterColumns();
        this.packTable();
    }

    public static String getGuiStringForParamValue(IParameterInterfacePO paramObj, IParamDescriptionPO desc, int rowCount) {
        return AbstractParamInterfaceBP.getGuiStringForParamValue((IParameterInterfacePO)paramObj, (IParamDescriptionPO)desc, (int)rowCount);
    }

    public void handleParamChanged(Object caller) {
        if (caller != this) {
            this.initTableViewerParameterColumns();
            this.updateView();
        }
    }

    public void handleProjectLoaded() {
        this.setParamInterfaceObj(null);
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.getTableViewer().setInput(null);
            }
        });
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (dataState == DataEventDispatcher.DataState.Deleted && po.equals(this.getParamInterfaceObj())) {
            this.setParamInterfaceObj(null);
            this.updateView();
        }
        if (dataState == DataEventDispatcher.DataState.StructureModified && po instanceof ITestDataCategoryPO) {
            this.updateView();
        }
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.getControlEnabler().selectionChanged(AbstractDataSetPage.this.m_currentPart, (ISelection)AbstractDataSetPage.this.m_currentSelection);
            }
        });
    }

    private void removeDataSet() {
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        if (editor == null) {
            return;
        }
        if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            ITDManager man;
            if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
                this.getTableViewer().setInput((Object)man);
            }
            int row = this.getSelectedDataSet();
            try {
                if (row == -1 && this.getTableCursor().getRow() != null) {
                    row = this.getTable().indexOf(this.getTableCursor().getRow());
                }
                if (row > -1) {
                    editor.getEditorHelper().getEditSupport().lockWorkVersion();
                    this.getParamBP().removeDataSet(this.getParamInterfaceObj(), row, (IParamNameMapper)editor.getEditorHelper().getEditSupport().getParamMapper());
                    editor.getEditorHelper().setDirty(true);
                    this.getTableViewer().refresh();
                    this.setIsEntrySetComplete(this.getParamInterfaceObj());
                    if (this.getTable().getItemCount() != 0) {
                        if (this.getTable().getItemCount() <= row && this.getTable().getItemCount() > 0) {
                            this.getTable().setSelection(--row);
                        } else {
                            this.getTable().setSelection(row);
                        }
                        this.getTableCursor().setSelection(row, 1);
                    }
                    this.getControlEnabler().setControlsEnabled();
                    this.setFocus();
                    DataEventDispatcher.getInstance().fireParamChangedListener((Object)this);
                }
            }
            catch (PMException pme) {
                PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
            }
        }
    }

    private void reactOnChange(IWorkbenchPart part, IStructuredSelection selection) {
        this.m_currentPart = part;
        this.m_currentSelection = selection;
        this.getControlEnabler().selectionChanged(part, (ISelection)selection);
        IParameterInterfacePO paramInterfacePO = this.getSelectedParamInterfaceObj(selection);
        this.setParamInterfaceObj(paramInterfacePO);
        this.updateView();
    }

    private IParameterInterfacePO getSelectedParamInterfaceObj(IStructuredSelection selection) {
        IParameterInterfacePO paramInterfacePO = null;
        Object firstSel = selection.getFirstElement();
        if (firstSel instanceof BasicSearchResult.SearchResultElement) {
            firstSel = ((BasicSearchResult.SearchResultElement)firstSel).getObject();
        }
        if (firstSel instanceof IParameterInterfacePO) {
            paramInterfacePO = (IParameterInterfacePO)firstSel;
        }
        return paramInterfacePO;
    }

    protected abstract void setIsEntrySetComplete(IParameterInterfacePO var1);

    protected abstract boolean isEditorOpenOrIsPageTestDataCube(IParameterInterfacePO var1);

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.reactOnChange(part, (IStructuredSelection)selection);
    }

    private void setParamBP(AbstractParamInterfaceBP<?> paramBP) {
        this.m_paramBP = paramBP;
    }

    private AbstractParamInterfaceBP<?> getParamBP() {
        return this.m_paramBP;
    }

    private void setParamInterfaceObj(IParameterInterfacePO paramInterfaceObj) {
        this.m_paramInterfaceObj = paramInterfaceObj;
    }

    public IParameterInterfacePO getParamInterfaceObj() {
        return this.m_paramInterfaceObj;
    }

    private GuiParamValueConverter getGuiParamValueConverter(String value, IParameterInterfacePO paramInterfaceObj, IParamDescriptionPO currentParamDescription, IParamValueValidator dataValidator) {
        return new GuiParamValueConverter(value, paramInterfaceObj, currentParamDescription, dataValidator);
    }

    protected ITDManager getInputForTable(IParameterInterfacePO paramInterface) {
        return paramInterface.getDataManager();
    }

    private void setTableCursor(DSVTableCursor tableCursor) {
        this.m_tableCursor = tableCursor;
    }

    public DSVTableCursor getTableCursor() {
        return this.m_tableCursor;
    }

    public void navigateToCell(String keyCol, String keyVal, String valCol) {
        this.getTable().setFocus();
        int keyColInd = this.getColumnIndexByParamName(keyCol);
        if (keyColInd == -1) {
            return;
        }
        int rowNum = 0;
        ITDManager man = this.getParamInterfaceObj().getDataManager();
        for (IDataSetPO row : man.getDataSets()) {
            if (StringUtils.equals((String)((String)row.getColumnStringValues().get(keyColInd)), (String)keyVal)) break;
            ++rowNum;
        }
        if (rowNum >= man.getDataSetCount()) {
            return;
        }
        int valColNum = this.getColumnIndexByParamName(valCol) + 1;
        this.getTable().setSelection(rowNum);
        this.getTableCursor().setSelection(rowNum, valColNum);
    }

    public int getColumnIndexByParamName(String name) {
        int keyColInd = 0;
        for (IParamDescriptionPO desc : this.getParamInterfaceObj().getParameterList()) {
            if (StringUtils.equals((String)name, (String)desc.getName())) {
                return keyColInd;
            }
            ++keyColInd;
        }
        return -1;
    }

    public int getCurrentRow() {
        if (this.getTable().isDisposed()) {
            return -1;
        }
        return this.getTable().getSelectionIndex();
    }

    public int getCurrentCol() {
        if (this.getTable().isDisposed()) {
            return -1;
        }
        return this.getTableCursor().getColumn();
    }

    public void navigateToCellUsingRowCol(int row, int col) {
        if (this.getTable().isDisposed()) {
            return;
        }
        int newRow = Math.max(0, row);
        if (newRow >= this.getTable().getItemCount()) {
            newRow = 0;
        }
        this.getTable().setFocus();
        this.getTable().setSelection(newRow);
        if (col < 0 || col + 1 >= this.getTable().getColumnCount()) {
            return;
        }
        this.getTableCursor().setSelection(newRow, col + 1);
    }

    private static abstract class AbstractContentProvider
    implements IStructuredContentProvider {
        private AbstractContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private abstract class AbstractLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private AbstractLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (!AbstractDataSetPage.this.getControlEnabler().canEdit()) {
                return LayoutUtil.GRAY_COLOR;
            }
            return null;
        }
    }

    protected class ControlEnabler
    implements ISelectionListener {
        private boolean m_canEdit = false;

        protected ControlEnabler() {
        }

        public boolean canEdit() {
            return this.m_canEdit;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(selection instanceof IStructuredSelection) || AbstractDataSetPage.this.getTable().isDisposed()) {
                return;
            }
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            IParameterInterfacePO paramNode = AbstractDataSetPage.this.getSelectedParamInterfaceObj(strucSelection);
            boolean correctPart = false;
            if (part != null) {
                boolean bl = correctPart = part == AbstractDataSetPage.this || part.getAdapter(AbstractJBEditor.class) != null;
            }
            if (!correctPart) {
                AbstractDataSetPage.this.getTable().setForeground(LayoutUtil.GRAY_COLOR);
            } else {
                AbstractDataSetPage.this.getTable().setForeground(LayoutUtil.DEFAULT_OS_COLOR);
            }
            boolean hasInput = !strucSelection.isEmpty();
            boolean isEditorOpen = AbstractDataSetPage.this.isEditorOpenOrIsPageTestDataCube(paramNode);
            boolean hasParameter = false;
            boolean hasExcelFile = false;
            boolean hasReferencedDataCube = false;
            if (paramNode != null) {
                hasParameter = !paramNode.getParameterList().isEmpty();
                String dataFile = paramNode.getDataFile();
                hasExcelFile = dataFile != null && dataFile.length() != 0;
                hasReferencedDataCube = paramNode.getReferencedDataCube() != null;
            }
            boolean isCAP = paramNode instanceof ICapPO;
            this.m_canEdit = correctPart && hasInput && isEditorOpen && !isCAP && !hasExcelFile && !hasReferencedDataCube && hasParameter;
            this.setControlsEnabled();
        }

        public void setControlsEnabled() {
            AbstractDataSetPage.this.m_addButton.setEnabled(false);
            AbstractDataSetPage.this.m_insertButton.setEnabled(false);
            AbstractDataSetPage.this.m_deleteButton.setEnabled(false);
            AbstractDataSetPage.this.m_upButton.setEnabled(false);
            AbstractDataSetPage.this.m_downButton.setEnabled(false);
            if (!this.m_canEdit || StringUtils.isNotEmpty((String)AbstractDataSetPage.this.m_searchText.getText())) {
                return;
            }
            AbstractDataSetPage.this.m_addButton.setEnabled(true);
            int rowind = AbstractDataSetPage.this.getSelectedDataSet();
            if (rowind > -1) {
                AbstractDataSetPage.this.m_insertButton.setEnabled(true);
                AbstractDataSetPage.this.m_deleteButton.setEnabled(true);
                if (rowind > 0) {
                    AbstractDataSetPage.this.m_upButton.setEnabled(true);
                }
                if (rowind < AbstractDataSetPage.this.getTable().getItemCount() - 1) {
                    AbstractDataSetPage.this.m_downButton.setEnabled(true);
                }
            }
        }
    }

    public class DSVTableCursor
    extends TableCursor {
        private ControlEditor m_editor;
        private AbstractJBEditor m_tcEditor;
        private KeyAdapter m_keyListener;
        private MouseAdapter m_mouseListener;
        private CursorListener m_cursorListener;
        private EditorFocusListener m_focusListener;
        private boolean m_wasActivatedWithEnterKey;
        private String m_oldValue;
        private Listener m_listener;
        private int m_currentEditorIndex;
        private int m_currentSelectionIndex;

        public DSVTableCursor(Table parent, int style) {
            super(parent, style);
            this.m_keyListener = new EditorKeyListener();
            this.m_mouseListener = new EditorMouseListener();
            this.m_cursorListener = new CursorListener();
            this.m_focusListener = new EditorFocusListener();
            this.m_wasActivatedWithEnterKey = false;
            this.m_listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 13 && event.widget instanceof CCombo) {
                        DSVTableCursor.this.writeData();
                    }
                }
            };
            this.addSelectionListener((SelectionListener)this.m_cursorListener);
            this.addMouseListener((MouseListener)this.m_mouseListener);
            this.addKeyListener((KeyListener)this.m_keyListener);
            this.m_editor = new ControlEditor((Composite)this);
            this.m_editor.grabHorizontal = true;
            this.m_editor.grabVertical = true;
        }

        private int getColumnIndexOfProperty(String columnProperty) {
            Object[] props = AbstractDataSetPage.this.getTableViewer().getColumnProperties();
            int i = 0;
            while (i < props.length) {
                if (columnProperty.equals(props[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void writeData() {
            if (AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor) {
                this.m_tcEditor = (AbstractJBEditor)AbstractDataSetPage.this.m_currentPart;
            }
            if (this.m_tcEditor == null) {
                return;
            }
            int column = this.getColumn();
            Control editor = this.m_editor.getEditor();
            if (!TextControlBP.isTextValid(editor)) {
                TextControlBP.setText(this.m_oldValue, editor);
            }
            String property = AbstractDataSetPage.this.getTableViewer().getColumnProperties()[column].toString();
            String value = TextControlBP.getText(editor);
            if (this.m_oldValue != null && this.m_oldValue.equals(value)) {
                return;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            if (LOG.isDebugEnabled()) {
                this.logDataChange(property, value, this.m_oldValue, AbstractDataSetPage.this.getParamInterfaceObj().getSpecificationUser());
            }
            if (value != null && value.length() > 1300) {
                if ((value = value.substring(0, 1300)).getBytes(StandardCharsets.UTF_8).length > 4000) {
                    value = this.m_oldValue;
                }
                TextControlBP.setText(value, editor);
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.W_MAX_CHAR, (Object[])new Object[]{1300}, null);
                return;
            }
            this.writeDataSetData(property, value, this.m_tcEditor);
        }

        public Object getData() {
            if (this.getRow() == null) {
                return null;
            }
            return this.getRow().getText(this.getColumn());
        }

        private void logDataChange(String col, String newV, String oldV, INodePO node) {
            StringBuilder str = new StringBuilder();
            str.append("\nData Set value changed. Data owner node: ");
            str.append(node.toString());
            str.append(".\nEditor node: ");
            str.append(node.getSpecAncestor().toString());
            str.append("\nColumn: ");
            str.append(col);
            str.append(", Row: ");
            str.append(this.m_currentSelectionIndex);
            str.append(".\nValue change: \"");
            str.append(oldV);
            str.append("\" -> \"");
            str.append(newV);
            str.append("\".\n");
            LOG.debug(str.toString());
        }

        private void writeDataSetData(String property, Object value, AbstractJBEditor edit) {
            AbstractDataSetPage.this.getSelectedDataSet();
            int langIndex = this.getColumnIndexOfProperty(property);
            AbstractDataSetPage.this.getTable().getItem(this.m_currentSelectionIndex).setText(langIndex, value == null ? "" : (String)value);
            this.setValueToModel(value, edit, this.m_currentEditorIndex, this.m_currentEditorIndex);
        }

        private void setValueToModel(Object value, AbstractJBEditor editor, int paramIndex, int dsNumber) {
            if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                ParamNameBPDecorator mapper = editor.getEditorHelper().getEditSupport().getParamMapper();
                GuiParamValueConverter conv = AbstractDataSetPage.this.getGuiParamValueConverter((String)value, AbstractDataSetPage.this.getParamInterfaceObj(), this.getCurrentParamDescription(), ((CheckedParamText)this.m_editor.getEditor()).getDataValidator());
                if (conv.getErrors().isEmpty()) {
                    AbstractDataSetPage.this.getParamBP().startParameterUpdate(conv, dsNumber, (IParamNameMapper)mapper);
                    AbstractDataSetPage.this.setIsEntrySetComplete(AbstractDataSetPage.this.getParamInterfaceObj());
                    editor.getEditorHelper().setDirty(true);
                    new IsAliveThread(){

                        public void run() {
                            Plugin.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DataEventDispatcher ded = DataEventDispatcher.getInstance();
                                    ded.firePropertyChanged(false);
                                    ded.fireParamChangedListener((Object)AbstractDataSetPage.this);
                                }
                            });
                        }
                    }.start();
                }
            }
        }

        public void dispose() {
            this.removeSelectionListener((SelectionListener)this.m_cursorListener);
            this.removeMouseListener((MouseListener)this.m_mouseListener);
            Control editor = this.m_editor.getEditor();
            if (editor != null && !editor.isDisposed()) {
                editor.removeFocusListener((FocusListener)this.m_focusListener);
                editor.dispose();
            }
            super.dispose();
        }

        private boolean canModify() {
            boolean isEditor;
            if (!(AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor)) {
                return false;
            }
            AbstractJBEditor edit = (AbstractJBEditor)AbstractDataSetPage.this.m_currentPart;
            boolean isFirstColumn = this.getColumn() == 0;
            boolean bl = isEditor = edit != null;
            return !isFirstColumn && isEditor && AbstractDataSetPage.this.getControlEnabler().canEdit();
        }

        protected void checkSubclass() {
        }

        private Control createEditor() {
            Control control = TestDataControlFactory.createControl(AbstractDataSetPage.this.getParamInterfaceObj(), this.getParamName(), (Composite)this, 0);
            control.addKeyListener((KeyListener)this.m_keyListener);
            control.setFocus();
            control.addListener(13, this.m_listener);
            this.m_oldValue = this.getRow().getText(this.getColumn());
            TextControlBP.setText(this.m_oldValue, control);
            TextControlBP.selectAll(control);
            return control;
        }

        private String getParamName() {
            return AbstractDataSetPage.this.getTableViewer().getTable().getColumn(this.getColumn()).getText();
        }

        private IParamDescriptionPO getCurrentParamDescription() {
            String paramName = this.getParamName();
            return AbstractDataSetPage.this.getParamInterfaceObj().getParameterForName(paramName);
        }

        private void activateEditor() {
            if (this.canModify()) {
                this.m_editor.setEditor(this.createEditor());
                Control editorCtrl = this.m_editor.getEditor();
                if (editorCtrl != null && !editorCtrl.isDisposed()) {
                    editorCtrl.addFocusListener((FocusListener)this.m_focusListener);
                }
                TextControlBP.selectAll(this.m_editor.getEditor());
                this.m_currentEditorIndex = AbstractDataSetPage.this.getSelectedDataSet();
                this.m_currentSelectionIndex = AbstractDataSetPage.this.getTable().getSelectionIndex();
            }
        }

        private class CursorListener
        extends SelectionAdapter {
            private CursorListener() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DSVTableCursor.this.activateEditor();
                DSVTableCursor.this.m_wasActivatedWithEnterKey = true;
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractDataSetPage.this.getTable().setSelection(new TableItem[]{DSVTableCursor.this.getRow()});
            }
        }

        private class EditorFocusListener
        extends FocusAdapter {
            private EditorFocusListener() {
            }

            public void focusLost(FocusEvent e) {
                CheckedParamTextContentAssisted ed;
                if (DSVTableCursor.this.m_editor.getEditor() instanceof CheckedParamTextContentAssisted && (ed = (CheckedParamTextContentAssisted)DSVTableCursor.this.m_editor.getEditor()).isPopupOpen() && ed.isFocusControl()) {
                    super.focusLost(e);
                    return;
                }
                DSVTableCursor.this.writeData();
                DSVTableCursor.this.m_editor.getEditor().dispose();
                super.focusLost(e);
            }
        }

        private class EditorKeyListener
        extends KeyAdapter {
            private EditorKeyListener() {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                    return;
                }
                if (e.character != '\b' && e.character != '\u007f' && e.character != '\u001b' && e.character != '\r' && e.character != '\u1000050' && Character.isISOControl(e.character)) {
                    return;
                }
                if (e.getSource().equals(DSVTableCursor.this.m_editor.getEditor())) {
                    if (e.character == '\u001b') {
                        TextControlBP.setText(DSVTableCursor.this.m_oldValue, DSVTableCursor.this.m_editor.getEditor());
                        DSVTableCursor.this.writeData();
                        TableItem rowItem = DSVTableCursor.this.getRow();
                        int col = DSVTableCursor.this.getColumn();
                        rowItem.setText(col, DSVTableCursor.this.m_oldValue);
                        DSVTableCursor.this.m_editor.getEditor().dispose();
                        return;
                    }
                    if (e.character == '\r' || e.character == '\u1000050') {
                        if (DSVTableCursor.this.m_wasActivatedWithEnterKey) {
                            DSVTableCursor.this.m_wasActivatedWithEnterKey = false;
                            return;
                        }
                        this.handleCR();
                    }
                }
                if (e.getSource() instanceof DSVTableCursor) {
                    if (e.character == '\u001b') {
                        return;
                    }
                    DSVTableCursor.this.activateEditor();
                    if (DSVTableCursor.this.m_editor.getEditor() != null && !DSVTableCursor.this.m_editor.getEditor().isDisposed() && e.character != '\r' && e.character != '\u1000050' && !(DSVTableCursor.this.m_editor.getEditor() instanceof CCombo)) {
                        String sign = new Character(e.character).toString();
                        if (e.character == '\u007f' || e.character == '\b') {
                            sign = "";
                        }
                        TextControlBP.setText(sign, DSVTableCursor.this.m_editor.getEditor());
                        TextControlBP.setSelection(DSVTableCursor.this.m_editor.getEditor(), 1);
                    }
                }
            }

            private void handleCR() {
                Control editorControl;
                if (DSVTableCursor.this.m_editor.getEditor() instanceof CheckedParamTextContentAssisted) {
                    CheckedParamTextContentAssisted cfr_ignored_0 = (CheckedParamTextContentAssisted)DSVTableCursor.this.m_editor.getEditor();
                }
                if (!(editorControl = DSVTableCursor.this.m_editor.getEditor()).isDisposed()) {
                    DSVTableCursor.this.writeData();
                }
                if (!editorControl.isDisposed()) {
                    TableItem rowItem = DSVTableCursor.this.getRow();
                    int col = DSVTableCursor.this.getColumn();
                    rowItem.setText(col, TextControlBP.getText(editorControl));
                    editorControl.dispose();
                    int row = AbstractDataSetPage.this.getTable().indexOf(DSVTableCursor.this.getRow());
                    if (AbstractDataSetPage.this.getTable().getColumnCount() > col + 1) {
                        DSVTableCursor.this.setSelection(row, col + 1);
                        AbstractDataSetPage.this.getTable().setSelection(row);
                        DSVTableCursor.this.setFocus();
                    } else if (AbstractDataSetPage.this.getTable().getItemCount() > row + 1) {
                        DSVTableCursor.this.setSelection(row + 1, 1);
                        AbstractDataSetPage.this.getTable().setSelection(row + 1);
                    } else {
                        AbstractDataSetPage.this.getAddButton().setFocus();
                    }
                }
            }
        }

        private class EditorMouseListener
        extends MouseAdapter {
            private EditorMouseListener() {
            }

            public void mouseUp(MouseEvent e) {
                DSVTableCursor.this.activateEditor();
                DSVTableCursor.this.m_wasActivatedWithEnterKey = false;
            }
        }
    }

    private static class GeneralContentProvider
    extends AbstractContentProvider {
        private GeneralContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            ITDManager tdMan = (ITDManager)inputElement;
            List rows = tdMan.getDataSets();
            return rows.toArray();
        }
    }

    private class GeneralLabelProvider
    extends AbstractLabelProvider {
        private GeneralLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof IDataSetPO)) {
                return "";
            }
            ITDManager tdMan = (ITDManager)AbstractDataSetPage.this.getTableViewer().getInput();
            IDataSetPO row = (IDataSetPO)element;
            int rowCount = tdMan.getDataSets().indexOf(row);
            if (columnIndex == 0) {
                for (TableItem i : Arrays.asList(AbstractDataSetPage.this.getTable().getItems())) {
                    if (!(i instanceof IDataSetPO) || !((IDataSetPO)i).equals(element)) continue;
                    i.setBackground(columnIndex, AbstractDataSetPage.this.getTable().getDisplay().getSystemColor(22));
                    break;
                }
                return "" + (rowCount + 1);
            }
            List paramList = AbstractDataSetPage.this.getParamInterfaceObj().getParameterList();
            String value = "";
            if (columnIndex - 1 < paramList.size()) {
                IParamDescriptionPO desc = (IParamDescriptionPO)paramList.get(columnIndex - 1);
                IParameterInterfacePO paramInterface = AbstractDataSetPage.this.getParamInterfaceObj();
                value = AbstractDataSetPage.getGuiStringForParamValue(paramInterface, desc, rowCount);
            }
            return value;
        }
    }

    private static enum TestDataRowAction {
        ADDED,
        INSERTED,
        DELETED,
        MOVED_UP,
        MOVED_DOWN;

    }
}

