import { TextDocument, Position } from 'vscode-languageserver-types';
import * as ast from './main';
import { ParserDirective } from './parserDirective';
import { ImageTemplate } from './imageTemplate';
import { Instruction } from './instruction';
import { Arg } from './instructions/arg';
export declare class Dockerfile extends ImageTemplate implements ast.Dockerfile {
    private readonly document;
    private readonly initialInstructions;
    private readonly buildStages;
    private currentBuildStage;
    private directive;
    /**
     * Whether a FROM instruction has been added to this Dockerfile or not.
     */
    private foundFrom;
    constructor(document: TextDocument);
    getEscapeCharacter(): string;
    getInitialARGs(): Arg[];
    getContainingImage(position: Position): ImageTemplate;
    addInstruction(instruction: Instruction): void;
    setDirective(directive: ParserDirective): void;
    getDirective(): ParserDirective | null;
    resolveVariable(variable: string, line: number): string;
    getAvailableVariables(currentLine: number): string[];
}
