/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.actions.SashLayoutAction;
import org.eclipse.net4j.util.ui.views.MultiViewersView;
import org.eclipse.net4j.util.ui.widgets.CoolBarComposite;
import org.eclipse.net4j.util.ui.widgets.SashComposite;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class MasterDetailsView
extends MultiViewersView {
    private StructuredViewer master;
    private CTabFolder detailsFolder;
    private Object currentMasterElement = new Object();
    private String[] detailTitles;
    private CTabItem[] detailItems;
    private StructuredViewer[] details;
    private int currentDetailIndex;
    private SashComposite sash;

    public StructuredViewer getMaster() {
        return this.master;
    }

    public StructuredViewer[] getDetails() {
        return this.details;
    }

    public String[] getDetailTitles() {
        return this.detailTitles;
    }

    public Object getCurrentMasterElement() {
        return this.currentMasterElement;
    }

    public int getCurrentDetailIndex() {
        return this.currentDetailIndex;
    }

    public String getCurrentDetailTitle() {
        if (this.detailTitles == null || this.currentDetailIndex == -1) {
            return null;
        }
        return this.detailTitles[this.currentDetailIndex];
    }

    @Override
    protected Control createUI(Composite parent) {
        this.sash = new SashComposite(parent, 0, 10, 50, true){

            @Override
            protected Control createControl1(Composite parent) {
                MasterDetailsView.this.master = MasterDetailsView.this.createMaster(parent);
                return MasterDetailsView.this.master.getControl();
            }

            @Override
            protected Control createControl2(Composite parent) {
                return new CoolBarComposite(parent, 0){

                    @Override
                    protected Control createUI(Composite parent) {
                        MasterDetailsView.this.detailsFolder = new CTabFolder(parent, 0x800400);
                        MasterDetailsView.this.detailsFolder.setLayoutData((Object)UIUtil.createGridData());
                        MasterDetailsView.this.adjustDetails(null);
                        MasterDetailsView.this.detailsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                String title = MasterDetailsView.this.detailsFolder.getSelection().getText();
                                int detailIndex = MasterDetailsView.indexOf(MasterDetailsView.this.detailItems, title);
                                if (detailIndex != MasterDetailsView.this.currentDetailIndex) {
                                    MasterDetailsView.this.currentDetailIndex = detailIndex;
                                    this.updateCoolBar();
                                }
                            }
                        });
                        return MasterDetailsView.this.detailsFolder;
                    }

                    @Override
                    protected void fillCoolBar(IContributionManager manager) {
                        MasterDetailsView.this.fillCoolBar(manager);
                        manager.add((IAction)new RefreshAction());
                    }
                };
            }
        };
        this.sash.setVertical(true);
        this.setCurrentViewer(this.master);
        this.master.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    MasterDetailsView.this.masterSelectionChanged(event);
                }
                catch (Error ex) {
                    OM.LOG.error((Throwable)ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                    throw ex;
                }
            }
        });
        return this.sash;
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        super.fillLocalPullDown(manager);
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new SashLayoutAction.LayoutMenu(this.sash));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IAction)new RefreshAction());
    }

    protected void masterSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.master.getSelection();
        Object masterElement = selection.getFirstElement();
        this.adjustDetails(masterElement);
    }

    protected void adjustDetails(Object masterElement) {
        int n;
        CTabItem[] cTabItemArray;
        if (ObjectUtil.equals((Object)masterElement, (Object)this.currentMasterElement)) {
            return;
        }
        String oldDetailTitle = this.detailItems == null || this.currentDetailIndex < 0 ? null : this.detailItems[this.currentDetailIndex].getText();
        StructuredViewer[] oldDetails = this.details;
        CTabItem[] oldDetailItems = this.detailItems;
        this.detailTitles = this.getDetailTitles(masterElement);
        this.details = new StructuredViewer[this.detailTitles.length];
        this.detailItems = new CTabItem[this.detailTitles.length];
        int i = 0;
        while (i < this.detailTitles.length) {
            String title = this.detailTitles[i];
            int oldIndex = MasterDetailsView.indexOf(oldDetailItems, title);
            if (oldIndex != -1) {
                this.details[i] = oldDetails[oldIndex];
                oldDetailItems[oldIndex].setControl(null);
                oldDetailItems[oldIndex].dispose();
                oldDetailItems[oldIndex] = null;
            } else {
                this.details[i] = this.createDetail((Composite)this.detailsFolder, title);
            }
            this.detailItems[i] = new CTabItem(this.detailsFolder, 0, i);
            this.detailItems[i].setText(title);
            this.detailItems[i].setControl(this.details[i].getControl());
            ++i;
        }
        if (oldDetailItems != null) {
            cTabItemArray = oldDetailItems;
            n = oldDetailItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (item != null) {
                    item.dispose();
                }
                ++n2;
            }
        }
        this.currentMasterElement = masterElement;
        cTabItemArray = this.details;
        n = this.details.length;
        int n3 = 0;
        while (n3 < n) {
            CTabItem viewer = cTabItemArray[n3];
            this.setDetailInput((StructuredViewer)viewer, masterElement);
            ++n3;
        }
        this.currentDetailIndex = MasterDetailsView.indexOf(this.detailItems, oldDetailTitle);
        if (this.currentDetailIndex == -1 && this.details.length > 0) {
            this.currentDetailIndex = 0;
        }
        if (this.currentDetailIndex != -1) {
            this.detailsFolder.setSelection(this.currentDetailIndex);
        }
    }

    protected void setDetailInput(StructuredViewer viewer, Object input) {
        if (input != viewer.getInput()) {
            viewer.setInput(input);
        }
    }

    protected void fillCoolBar(IContributionManager manager) {
    }

    protected abstract StructuredViewer createMaster(Composite var1);

    protected abstract StructuredViewer createDetail(Composite var1, String var2);

    protected abstract String[] getDetailTitles(Object var1);

    public static int indexOf(CTabItem[] items, String title) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                CTabItem item = items[i];
                if (item != null && ObjectUtil.equals((Object)item.getText(), (Object)title)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected final class RefreshAction
    extends SafeAction {
        public RefreshAction() {
            super(Messages.getString("MasterDetailsView_2"), Messages.getString("MasterDetailsView_3"), OM.getImageDescriptor("icons/full/etool16/refresh.gif"));
        }

        @Override
        protected void safeRun() throws Exception {
            StructuredViewer viewer = MasterDetailsView.this.getCurrentViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
    }
}

