/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.io.IORuntimeException;

public class SetContainer<E>
extends Container<E>
implements IContainer.Modifiable<E>,
IContainer.Persistable<E> {
    private final Class<E> componentType;
    private final Set<E> set;
    private IContainer.Persistence<E> persistence;

    public SetContainer(Class<E> componentType) {
        this(componentType, new HashSet());
    }

    public SetContainer(Class<E> componentType, Set<E> set) {
        this.componentType = componentType;
        this.set = set;
    }

    public final Class<E> getComponentType() {
        return this.componentType;
    }

    @Override
    public final IContainer.Persistence<E> getPersistence() {
        return this.persistence;
    }

    @Override
    public final void setPersistence(IContainer.Persistence<E> persistence) {
        this.persistence = persistence;
    }

    public boolean isSavedWhenModified() {
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E[] getElements() {
        Object[] array;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            Object[] a = (Object[])Array.newInstance(this.componentType, this.set.size());
            array = this.set.toArray(a);
        }
        array = this.sortElements(array);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addElement(E element) {
        if (!this.validateElement(element)) {
            return false;
        }
        SingleDeltaContainerEvent<E> event = null;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            if (this.set.add(element)) {
                this.elementAdded(element);
                event = this.newContainerEvent(element, IContainerDelta.Kind.ADDED);
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllElements(Collection<E> elements) {
        ArrayList<E> validElements = new ArrayList<E>();
        for (E element : elements) {
            if (!this.validateElement(element)) continue;
            validElements.add(element);
        }
        ContainerEvent event = null;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            for (Object element : validElements) {
                if (!this.set.add(element)) continue;
                this.elementAdded(element);
                if (event == null) {
                    event = this.newContainerEvent();
                }
                event.addDelta(element, IContainerDelta.Kind.ADDED);
            }
            if (event != null) {
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeElement(E element) {
        SingleDeltaContainerEvent<E> event = null;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            if (this.set.remove(element)) {
                this.elementRemoved(element);
                event = this.newContainerEvent(element, IContainerDelta.Kind.REMOVED);
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllElements(Collection<E> elements) {
        ContainerEvent<E> event = null;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            for (E element : elements) {
                if (!this.set.remove(element)) continue;
                this.elementRemoved(element);
                if (event == null) {
                    event = this.newContainerEvent();
                }
                event.addDelta(element, IContainerDelta.Kind.REMOVED);
            }
            if (event != null) {
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ContainerEvent<E> event = null;
        SetContainer setContainer = this;
        synchronized (setContainer) {
            for (E element : this.set) {
                if (!this.set.contains(element)) continue;
                this.elementRemoved(element);
                if (event == null) {
                    event = this.newContainerEvent();
                }
                event.addDelta(element, IContainerDelta.Kind.REMOVED);
            }
            if (event != null) {
                this.notifyAll();
            }
        }
        if (event != null) {
            this.fireEvent(event);
            this.containerModified();
        }
    }

    @Override
    public synchronized void load() throws IORuntimeException {
        if (this.persistence != null) {
            Collection<E> elements = this.persistence.loadElements();
            this.set.clear();
            this.set.addAll(elements);
        }
    }

    @Override
    public synchronized void save() throws IORuntimeException {
        if (this.persistence != null) {
            this.persistence.saveElements(this.set);
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.load();
    }

    @Override
    protected void doDeactivate() throws Exception {
        if (!this.isSavedWhenModified()) {
            this.save();
        }
        super.doDeactivate();
    }

    protected Set<E> getSet() {
        return this.set;
    }

    protected E[] sortElements(E[] array) {
        return array;
    }

    protected boolean validateElement(E element) {
        return true;
    }

    protected void containerModified() {
        if (this.isSavedWhenModified()) {
            this.save();
        }
    }

    protected void elementAdded(E element) {
    }

    protected void elementRemoved(E element) {
    }
}

