/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.ui.commands;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ocl.pivot.internal.registry.CompleteOCLRegistry;
import org.eclipse.ocl.pivot.internal.resource.OCLAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.xtext.base.ui.utilities.PDEUtils;
import org.eclipse.ocl.xtext.completeocl.ui.messages.CompleteOCLUIMessages;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class LoadCompleteOCLResourceHandler
extends AbstractHandler {
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        EditingDomain editingDomain = LoadCompleteOCLResourceHandler.getEditingDomain(applicationContext);
        ResourceSet resourceSet = LoadCompleteOCLResourceHandler.getResourceSet(applicationContext);
        Object shell = HandlerUtil.getVariable((Object)applicationContext, (String)"activeShell");
        if (!(shell instanceof Shell)) {
            return null;
        }
        if (resourceSet != null) {
            ResourceDialog dialog = new ResourceDialog((Shell)shell, editingDomain, resourceSet);
            dialog.open();
        }
        return null;
    }

    public static @Nullable EditingDomain getEditingDomain(@Nullable Object evaluationContext) {
        Object o = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (!(o instanceof IEditorPart)) {
            return null;
        }
        IEditingDomainProvider editor = (IEditingDomainProvider)ClassUtil.getAdapter((IAdaptable)((IEditorPart)o), IEditingDomainProvider.class);
        if (editor == null) {
            return null;
        }
        EditingDomain editingDomain = editor.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        return editingDomain;
    }

    public static @Nullable ResourceSet getResourceSet(@Nullable Object evaluationContext) {
        Object o = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (!(o instanceof IEditorPart)) {
            return null;
        }
        IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)ClassUtil.getAdapter((IAdaptable)((IEditorPart)o), IEditingDomainProvider.class);
        if (editingDomainProvider != null) {
            EditingDomain editingDomain = editingDomainProvider.getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            ResourceSet resourceSet = editingDomain.getResourceSet();
            return resourceSet;
        }
        XtextEditor xtextEditor = (XtextEditor)ClassUtil.getAdapter((IAdaptable)((IEditorPart)o), XtextEditor.class);
        if (xtextEditor != null) {
            IXtextDocument document = xtextEditor.getDocument();
            ResourceSet resourceSet = (ResourceSet)document.readOnly((IUnitOfWork)new IUnitOfWork<ResourceSet, XtextResource>(){

                public ResourceSet exec(@Nullable XtextResource xtextResource) {
                    if (xtextResource == null) {
                        return null;
                    }
                    EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)((Resource)ClassUtil.nonNullState((Object)xtextResource)));
                    if (environmentFactory != null) {
                        return environmentFactory.getResourceSet();
                    }
                    return xtextResource.getResourceSet();
                }
            });
            return resourceSet;
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(LoadCompleteOCLResourceHandler.getResourceSet(evaluationContext) != null);
    }

    protected class ResourceDialog
    extends LoadResourceAction.LoadResourceDialog {
        protected final Shell parent;
        protected final @NonNull ResourceSet resourceSet;
        private DropTarget target;
        private Set<URI> registeredURIsForResourceSet;
        private DeferredLoadDocumentJob job;

        protected ResourceDialog(Shell parent, @NonNull EditingDomain domain, ResourceSet resourceSet) {
            super(parent, domain);
            this.job = null;
            this.parent = parent;
            this.resourceSet = resourceSet;
            int shellStyle = this.getShellStyle();
            int newShellStyle = shellStyle & 0xFFFC7FFF;
            this.setShellStyle(newShellStyle);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Load Complete OCL Document");
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            int operations = 5;
            this.target = new DropTarget((Control)this.uriField, operations);
            this.target.setTransfer(new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
            this.target.addDropListener((DropTargetListener)new URIDropTargetListener());
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite createDialogArea = (Composite)super.createDialogArea(parent);
            Composite buttonComposite = (Composite)createDialogArea.getChildren()[0];
            Button browseRegisteredOCLFiles = new Button(buttonComposite, 8);
            browseRegisteredOCLFiles.setText(CompleteOCLUIMessages.LoadCompleteOCLResource_BrowseRegisteredOCLFiles);
            this.prepareBrowseRegisteredOCLFiles(browseRegisteredOCLFiles);
            CompleteOCLRegistry registry = PDEUtils.createCompleteOCLRegistry();
            this.registeredURIsForResourceSet = registry.getResourceURIs(this.resourceSet);
            if (this.registeredURIsForResourceSet.isEmpty()) {
                browseRegisteredOCLFiles.setEnabled(false);
            } else {
                browseRegisteredOCLFiles.setEnabled(true);
            }
            FormData data = new FormData();
            Control[] children = buttonComposite.getChildren();
            data.right = new FormAttachment(children[0], -10);
            browseRegisteredOCLFiles.setLayoutData((Object)data);
            Label helpLabel = new Label(createDialogArea, 0x1000000);
            helpLabel.setText("You may Drag and Drop from an Eclipse or Operating System Explorer.");
            FormData data2 = new FormData();
            data2.top = new FormAttachment((Control)this.uriField, 20);
            data2.left = new FormAttachment(0, 10);
            data2.right = new FormAttachment(100, -10);
            helpLabel.setLayoutData((Object)data2);
            return createDialogArea;
        }

        private void prepareBrowseRegisteredOCLFiles(Button browseRegisteredOCLFiles) {
            browseRegisteredOCLFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RegisteredOCLFilesDialog registeredOCLFilesDialog = new RegisteredOCLFilesDialog(ResourceDialog.this.getShell());
                    registeredOCLFilesDialog.open();
                    Object[] result = registeredOCLFilesDialog.getResult();
                    if (result != null) {
                        StringBuffer uris = new StringBuffer();
                        int i = 0;
                        int length = result.length;
                        while (i < length) {
                            uris.append(result[i]);
                            uris.append("  ");
                            ++i;
                        }
                        ResourceDialog.this.uriField.setText((String.valueOf(ResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    }
                }
            });
        }

        protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
            Shell shell = this.parent;
            if (detailMessage != null) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, "source", 0, detailMessage, null);
                DiagnosticDialog.open((Shell)shell, (String)this.title, (String)primaryMessage, (Diagnostic)diagnostic);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)this.title, (String)primaryMessage);
            }
            return false;
        }

        protected void okPressed() {
            if (this.job == null) {
                this.getButton(0).setEnabled(false);
                this.getButton(1).setEnabled(false);
                @NonNull List urIs = this.getURIs();
                this.job = new DeferredLoadDocumentJob(urIs);
                this.job.schedule();
            } else {
                this.getButton(0).setEnabled(true);
                this.getButton(1).setEnabled(true);
                super.okPressed();
                this.job = null;
            }
        }

        public int open() {
            try {
                int n = super.open();
                return n;
            }
            catch (Throwable e) {
                @NonNull String primaryMessage = String.valueOf(e.getMessage());
                this.error(primaryMessage, null);
                return 1;
            }
            finally {
                if (this.target != null) {
                    this.target.dispose();
                    this.target = null;
                }
            }
        }

        protected boolean processResources() {
            if (this.job != null) {
                return this.job.getProcessedResourcesReturn();
            }
            return false;
        }

        protected boolean processResource(Resource resource) {
            throw new UnsupportedOperationException();
        }

        protected class DeferredLoadDocumentJob
        extends Job {
            private final @NonNull List<URI> uris;
            private boolean processedResourcesReturn;

            public DeferredLoadDocumentJob(List<URI> uris) {
                super("Deferred Load OCL Document");
                this.processedResourcesReturn = false;
                this.uris = uris;
            }

            protected IStatus run(IProgressMonitor monitor) {
                this.processedResourcesReturn = this.processResources();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceDialog.this.okPressed();
                    }
                });
                return Status.OK_STATUS;
            }

            protected boolean processResources() {
                OCLAdapter oclAdapter = OCLAdapter.getAdapter((ResourceSet)ResourceDialog.this.resourceSet);
                CompleteOCLLoader helper = new CompleteOCLLoader((EnvironmentFactory)oclAdapter.getEnvironmentFactory()){

                    protected boolean error(final @NonNull String primaryMessage, final @Nullable String detailMessage) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ResourceDialog.this.error(primaryMessage, detailMessage);
                            }
                        });
                        return false;
                    }
                };
                if (!helper.loadMetamodels()) {
                    return false;
                }
                for (final URI oclURI : this.uris) {
                    assert (oclURI != null);
                    try {
                        if (helper.loadDocument(oclURI)) continue;
                        return false;
                    }
                    catch (Throwable e) {
                        Status status = new Status(4, "org.eclipse.ocl.xtext.completeocl.ui", e.getLocalizedMessage(), e);
                        Display.getDefault().asyncExec(new Runnable((IStatus)status){
                            private final /* synthetic */ IStatus val$status;
                            {
                                this.val$status = iStatus;
                            }

                            @Override
                            public void run() {
                                ErrorDialog.openError((Shell)((DeferredLoadDocumentJob)DeferredLoadDocumentJob.this).ResourceDialog.this.parent, (String)"OCL->Load Document Failure", (String)("Failed to load '" + oclURI + "'"), (IStatus)this.val$status);
                            }
                        });
                        return false;
                    }
                }
                helper.installPackages();
                return true;
            }

            public boolean getProcessedResourcesReturn() {
                return this.processedResourcesReturn;
            }
        }

        private class RegisteredOCLFilesDialog
        extends ElementListSelectionDialog {
            public RegisteredOCLFilesDialog(Shell parent) {
                super(parent, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                    }
                });
                this.setMultipleSelection(true);
                this.setMessage(CompleteOCLUIMessages.LoadCompleteOCLResource_SelectRegisteredOCLFileURI);
                this.setFilter("*");
                this.setTitle(CompleteOCLUIMessages.LoadCompleteOCLResource_OCLFileSelection_label);
                this.setSize(100, 20);
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Object[] uris = ResourceDialog.this.registeredURIsForResourceSet.toArray(new URI[ResourceDialog.this.registeredURIsForResourceSet.size()]);
                Arrays.sort(uris, new URIComparator());
                this.setListElements(uris);
                return result;
            }
        }

        public class URIDropTargetListener
        extends DropTargetAdapter {
            public void dragEnter(DropTargetEvent e) {
                e.detail = 4;
            }

            public void dragOperationChanged(DropTargetEvent e) {
                e.detail = 4;
            }

            public void drop(DropTargetEvent event) {
                Object data = event.data;
                if (data == null) {
                    event.detail = 0;
                    return;
                }
                if (data instanceof IResource[]) {
                    StringBuilder s = new StringBuilder();
                    IResource[] iResourceArray = (IResource[])data;
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (s.length() > 0) {
                            s.append(" ");
                        }
                        s.append(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
                        ++n2;
                    }
                    ResourceDialog.this.uriField.setText(s.toString());
                } else if (data instanceof String[]) {
                    StringBuilder s = new StringBuilder();
                    String[] stringArray = (String[])data;
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String resource = stringArray[n3];
                        if (s.length() > 0) {
                            s.append(" ");
                        }
                        s.append(URI.createFileURI((String)resource));
                        ++n3;
                    }
                    ResourceDialog.this.uriField.setText(s.toString());
                } else {
                    ResourceDialog.this.uriField.setText((String)data);
                }
            }
        }
    }

    public static class URIComparator
    implements Comparator<URI> {
        @Override
        public int compare(URI o1, URI o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

