/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;

public class GroupingChecker {
    final PackageRoots nullPackageRoots = new PackageRoots(null);
    private Map<ResolverBundle, Map<String, PackageRoots>> bundles = new HashMap<ResolverBundle, Map<String, PackageRoots>>();

    public void populateRoots(ResolverBundle bundle) {
        ExportPackageDescription[] imports;
        BundleConstraint[] requires;
        if (this.bundles.containsKey(bundle)) {
            return;
        }
        BundleConstraint[] bundleConstraintArray = requires = bundle.getRequires();
        int n = requires.length;
        int n2 = 0;
        while (n2 < n) {
            BundleConstraint require = bundleConstraintArray[n2];
            ResolverBundle selectedSupplier = (ResolverBundle)require.getSelectedSupplier();
            if (selectedSupplier != null) {
                this.isConsistentInternal(bundle, selectedSupplier, new ArrayList<ResolverBundle>(1), true, null);
            }
            ++n2;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = imports = bundle.getBundleDescription().getResolvedImports();
        int n3 = imports.length;
        n = 0;
        while (n < n3) {
            ExportPackageDescription importPkg = exportPackageDescriptionArray[n];
            List exports = bundle.getResolver().getResolverExports().get(importPkg.getName());
            for (ResolverExport export : exports) {
                if (export.getExportPackageDescription() != importPkg) continue;
                this.isConsistentInternal(bundle, export, true, null);
            }
            ++n;
        }
    }

    public void populateRoots(ResolverBundle importingBundle, ResolverExport export) {
        Map<String, PackageRoots> packageRoots = this.bundles.get(importingBundle);
        if (packageRoots != null) {
            packageRoots.remove(export.getName());
        }
        PackageRoots roots = this.getPackageRoots(export.getExporter(), export.getName(), null);
        packageRoots.put(export.getName(), roots);
    }

    public PackageRoots[][] isConsistent(ResolverBundle requiringBundle, ResolverBundle matchingBundle) {
        List<PackageRoots[]> results = this.isConsistentInternal(requiringBundle, matchingBundle, new ArrayList<ResolverBundle>(1), false, null);
        return results == null ? null : (PackageRoots[][])results.toArray((T[])new PackageRoots[results.size()][]);
    }

    private List<PackageRoots[]> isConsistentInternal(ResolverBundle requiringBundle, ResolverBundle matchingBundle, List<ResolverBundle> visited, boolean dynamicImport, List<PackageRoots[]> results) {
        BundleConstraint[] supplierRequires;
        ResolverExport[] matchingExports;
        if (visited.contains(matchingBundle)) {
            return results;
        }
        visited.add(matchingBundle);
        ResolverExport[] resolverExportArray = matchingExports = matchingBundle.getExportPackages();
        int n = matchingExports.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverExport matchingExport = resolverExportArray[n2];
            if (matchingExport.getSubstitute() != null) {
                matchingExport = (ResolverExport)matchingExport.getSubstitute();
            }
            results = this.isConsistentInternal(requiringBundle, matchingExport, dynamicImport, results);
            ++n2;
        }
        BundleConstraint[] bundleConstraintArray = supplierRequires = matchingBundle.getRequires();
        int n3 = supplierRequires.length;
        n = 0;
        while (n < n3) {
            BundleConstraint supplierRequire = bundleConstraintArray[n];
            ResolverBundle reexported = (ResolverBundle)supplierRequire.getSelectedSupplier();
            if (reexported != null && ((BundleSpecification)supplierRequire.getVersionConstraint()).isExported()) {
                results = this.isConsistentInternal(requiringBundle, reexported, visited, dynamicImport, results);
            }
            ++n;
        }
        return results;
    }

    public PackageRoots[][] isConsistent(ResolverBundle importingBundle, ResolverExport matchingExport) {
        List<PackageRoots[]> results = this.isConsistentInternal(importingBundle, matchingExport, false, null);
        return results == null ? null : (PackageRoots[][])results.toArray((T[])new PackageRoots[results.size()][]);
    }

    public PackageRoots[][] isConsistent(ResolverBundle requiringBundle, GenericCapability matchingCapability) {
        String[] uses = matchingCapability.getUsesDirective();
        if (uses == null) {
            return null;
        }
        ArrayList<PackageRoots[]> results = new ArrayList<PackageRoots[]>(0);
        String[] stringArray = uses;
        int n = uses.length;
        int n2 = 0;
        while (n2 < n) {
            String usedPackage = stringArray[n2];
            PackageRoots providingRoots = this.getPackageRoots(matchingCapability.getResolverBundle(), usedPackage, null);
            providingRoots.addConflicts(requiringBundle, usedPackage, null, results);
            ++n2;
        }
        return results.size() == 0 ? null : (PackageRoots[][])results.toArray((T[])new PackageRoots[results.size()][]);
    }

    public PackageRoots[][] isDynamicConsistent(ResolverBundle importingBundle, ResolverExport matchingExport) {
        List<PackageRoots[]> results = this.isConsistentInternal(importingBundle, matchingExport, true, null);
        return results == null ? null : (PackageRoots[][])results.toArray((T[])new PackageRoots[results.size()][]);
    }

    private List<PackageRoots[]> isConsistentInternal(ResolverBundle importingBundle, ResolverExport matchingExport, boolean dyanamicImport, List<PackageRoots[]> results) {
        GenericConstraint[] genericRequires;
        PackageRoots exportingRoots = this.getPackageRoots(matchingExport.getExporter(), matchingExport.getName(), null);
        results = exportingRoots.isConsistentClassSpace(importingBundle, null, results);
        if (!dyanamicImport) {
            return results;
        }
        PackageRoots importingRoots = this.getPackageRoots(importingBundle, matchingExport.getName(), null);
        Map<String, PackageRoots> importingPackages = this.bundles.get(importingBundle);
        if (importingPackages != null) {
            for (PackageRoots roots : importingPackages.values()) {
                if (roots == importingRoots) continue;
                results = roots.isConsistentClassSpace(exportingRoots, matchingExport.getExporter(), null, results);
            }
        }
        GenericConstraint[] genericConstraintArray = genericRequires = importingBundle.getGenericRequires();
        int n = genericRequires.length;
        int n2 = 0;
        while (n2 < n) {
            GenericConstraint constraint = genericConstraintArray[n2];
            VersionSupplier[] suppliers = constraint.getMatchingCapabilities();
            if (suppliers != null) {
                VersionSupplier[] versionSupplierArray = suppliers;
                int n3 = suppliers.length;
                int n4 = 0;
                while (n4 < n3) {
                    VersionSupplier supplier = versionSupplierArray[n4];
                    String[] uses = ((GenericCapability)supplier).getUsesDirective();
                    if (uses != null) {
                        String[] stringArray = uses;
                        int n5 = uses.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String usedPackage = stringArray[n6];
                            if (usedPackage.equals(matchingExport.getName())) {
                                results = exportingRoots.addConflicts(supplier.getResolverBundle(), usedPackage, null, results);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return results;
    }

    PackageRoots getPackageRoots(ResolverBundle bundle, String packageName, List<ResolverBundle> visited) {
        PackageRoots packageRoots;
        Map<String, PackageRoots> packages = this.bundles.get(bundle);
        if (packages == null) {
            packages = new HashMap<String, PackageRoots>(5);
            this.bundles.put(bundle, packages);
        }
        if ((packageRoots = packages.get(packageName)) == null) {
            packageRoots = this.createPackageRoots(bundle, packageName, visited == null ? new ArrayList(1) : visited);
            packages.put(packageName, packageRoots);
        }
        return packageRoots != null ? packageRoots : this.nullPackageRoots;
    }

    private PackageRoots createPackageRoots(ResolverBundle bundle, String packageName, List<ResolverBundle> visited) {
        BundleConstraint[] requires;
        if (visited.contains(bundle)) {
            return null;
        }
        visited.add(bundle);
        if (bundle.getBundleDescription().isResolved()) {
            ExportPackageDescription[] imports;
            ExportPackageDescription[] exportPackageDescriptionArray = imports = bundle.getBundleDescription().getResolvedImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription importPkg = exportPackageDescriptionArray[n2];
                if (importPkg.getExporter() != bundle.getBundleDescription() && importPkg.getName().equals(packageName)) {
                    List exports2 = bundle.getResolver().getResolverExports().get(packageName);
                    for (ResolverExport export : exports2) {
                        if (export.getExportPackageDescription() != importPkg) continue;
                        return this.getPackageRoots(export.getExporter(), packageName, visited);
                    }
                }
                ++n2;
            }
        } else {
            ResolverExport selectedExport;
            ResolverImport imported = bundle.getImport(packageName);
            if (imported != null && imported.getSelectedSupplier() != null && (selectedExport = (ResolverExport)imported.getSelectedSupplier()).getExporter() != bundle) {
                return this.getPackageRoots(selectedExport.getExporter(), packageName, visited);
            }
        }
        ResolverExport[] exports = bundle.getExports(packageName);
        ArrayList<PackageRoots> roots = new ArrayList<PackageRoots>(0);
        BundleConstraint[] bundleConstraintArray = requires = bundle.getRequires();
        int exports2 = requires.length;
        int n = 0;
        while (n < exports2) {
            BundleConstraint require = bundleConstraintArray[n];
            ResolverBundle supplier = (ResolverBundle)require.getSelectedSupplier();
            if (supplier != null) {
                if (supplier.getExport(packageName) != null) {
                    PackageRoots requiredRoots = this.getPackageRoots(supplier, packageName, visited);
                    if (requiredRoots != this.nullPackageRoots) {
                        roots.add(requiredRoots);
                    }
                } else {
                    BundleConstraint[] supplierRequires;
                    BundleConstraint[] bundleConstraintArray2 = supplierRequires = supplier.getRequires();
                    int n3 = supplierRequires.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PackageRoots reExportedRoots;
                        BundleConstraint supplierRequire = bundleConstraintArray2[n4];
                        ResolverBundle reexported = (ResolverBundle)supplierRequire.getSelectedSupplier();
                        if (reexported != null && ((BundleSpecification)supplierRequire.getVersionConstraint()).isExported() && reexported.getExport(packageName) != null && (reExportedRoots = this.getPackageRoots(reexported, packageName, visited)) != this.nullPackageRoots) {
                            roots.add(reExportedRoots);
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
        if (exports.length > 0 || roots.size() > 1) {
            PackageRoots[] requiredRoots = roots.toArray(new PackageRoots[roots.size()]);
            if (exports.length == 0) {
                PackageRoots superSet = requiredRoots[0];
                int i = 1;
                while (i < requiredRoots.length) {
                    if (requiredRoots[i].superSet(superSet)) {
                        superSet = requiredRoots[i];
                    } else if (!superSet.superSet(requiredRoots[i])) {
                        superSet = null;
                        break;
                    }
                    ++i;
                }
                if (superSet != null) {
                    return superSet;
                }
            }
            PackageRoots result = new PackageRoots(packageName);
            Object[] objectArray = requiredRoots;
            int n5 = requiredRoots.length;
            int n6 = 0;
            while (n6 < n5) {
                PackageRoots requiredRoot = objectArray[n6];
                result.merge(requiredRoot);
                ++n6;
            }
            objectArray = exports;
            n5 = exports.length;
            n6 = 0;
            while (n6 < n5) {
                Object export = objectArray[n6];
                result.addRoot((ResolverExport)export);
                ++n6;
            }
            return result;
        }
        return roots.size() == 0 ? this.nullPackageRoots : (PackageRoots)roots.get(0);
    }

    public void clear() {
        this.bundles.clear();
    }

    public void clear(ResolverBundle rb) {
        this.bundles.remove(rb);
    }

    class PackageRoots {
        private String name;
        private ResolverExport[] roots;

        PackageRoots(String name) {
            this.name = name;
        }

        public boolean hasRoots() {
            return this.roots != null && this.roots.length > 0;
        }

        public void addRoot(ResolverExport export) {
            if (this.roots == null) {
                this.roots = new ResolverExport[]{export};
                return;
            }
            String exportBSN = export.getExporter().getName();
            if (exportBSN != null) {
                ResolverExport[] resolverExportArray = this.roots;
                int n = this.roots.length;
                int n2 = 0;
                while (n2 < n) {
                    ResolverExport root = resolverExportArray[n2];
                    if (export.getExporter() != root.getExporter() && exportBSN.equals(root.getExporter().getName())) {
                        return;
                    }
                    ++n2;
                }
            }
            if (!this.contains(export, this.roots)) {
                ResolverExport[] newRoots = new ResolverExport[this.roots.length + 1];
                System.arraycopy(this.roots, 0, newRoots, 0, this.roots.length);
                newRoots[this.roots.length] = export;
                this.roots = newRoots;
            }
        }

        private boolean contains(ResolverExport export, ResolverExport[] exports) {
            ResolverExport[] resolverExportArray = exports;
            int n = exports.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport e = resolverExportArray[n2];
                if (e == export) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void merge(PackageRoots packageRoots) {
            if (packageRoots == null || packageRoots.roots == null) {
                return;
            }
            int size = packageRoots.roots.length;
            int i = 0;
            while (i < size) {
                this.addRoot(packageRoots.roots[i]);
                ++i;
            }
        }

        public List<PackageRoots[]> isConsistentClassSpace(ResolverBundle importingBundle, List<PackageRoots> visited, List<PackageRoots[]> results) {
            if (this.roots == null) {
                return results;
            }
            if (visited == null) {
                visited = new ArrayList<PackageRoots>(1);
            }
            if (visited.contains(this)) {
                return results;
            }
            visited.add(this);
            int size = this.roots.length;
            int i = 0;
            while (i < size) {
                ResolverExport root = this.roots[i];
                String[] uses = root.getUsesDirective();
                if (uses != null) {
                    String[] stringArray = uses;
                    int n = uses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PackageRoots importingUsedRoots;
                        PackageRoots thisUsedRoots;
                        String use = stringArray[n2];
                        if (!use.equals(root.getName()) && (thisUsedRoots = GroupingChecker.this.getPackageRoots(root.getExporter(), use, null)) != (importingUsedRoots = GroupingChecker.this.getPackageRoots(importingBundle, use, null))) {
                            if (thisUsedRoots != GroupingChecker.this.nullPackageRoots && importingUsedRoots != GroupingChecker.this.nullPackageRoots && !this.subSet(thisUsedRoots.roots, importingUsedRoots.roots) && !this.subSet(importingUsedRoots.roots, thisUsedRoots.roots)) {
                                if (results == null) {
                                    results = new ArrayList<PackageRoots[]>(1);
                                }
                                results.add(new PackageRoots[]{this, importingUsedRoots});
                            }
                            results = thisUsedRoots.isConsistentClassSpace(importingBundle, visited, results);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            return results;
        }

        public List<PackageRoots[]> isConsistentClassSpace(PackageRoots exportingRoots, ResolverBundle exporter, List<PackageRoots> visited, List<PackageRoots[]> results) {
            if (this.roots == null) {
                return results;
            }
            ResolverExport[] resolverExportArray = this.roots;
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport root = resolverExportArray[n2];
                String[] uses = root.getUsesDirective();
                if (uses != null) {
                    if (visited == null) {
                        visited = new ArrayList<PackageRoots>(1);
                    }
                    if (visited.contains(this)) {
                        return results;
                    }
                    visited.add(this);
                    String[] stringArray = uses;
                    int n3 = uses.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String use = stringArray[n4];
                        if (!use.equals(root.getName()) && use.equals(exportingRoots.name)) {
                            PackageRoots thisUsedRoots = GroupingChecker.this.getPackageRoots(root.getExporter(), use, null);
                            PackageRoots exportingUsedRoots = GroupingChecker.this.getPackageRoots(exporter, use, null);
                            if (thisUsedRoots == exportingRoots) {
                                return results;
                            }
                            if (thisUsedRoots != GroupingChecker.this.nullPackageRoots && exportingUsedRoots != GroupingChecker.this.nullPackageRoots && !this.subSet(thisUsedRoots.roots, exportingUsedRoots.roots) && !this.subSet(exportingUsedRoots.roots, thisUsedRoots.roots)) {
                                if (results == null) {
                                    results = new ArrayList<PackageRoots[]>(1);
                                }
                                results.add(new PackageRoots[]{this, exportingUsedRoots});
                            }
                            results = thisUsedRoots.isConsistentClassSpace(exportingRoots, exporter, visited, results);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return results;
        }

        List<PackageRoots[]> addConflicts(ResolverBundle bundle, String usedPackage, List<PackageRoots> visited, List<PackageRoots[]> results) {
            PackageRoots bundleUsedRoots = GroupingChecker.this.getPackageRoots(bundle, usedPackage, null);
            if (this == bundleUsedRoots) {
                return results;
            }
            if (this != GroupingChecker.this.nullPackageRoots && bundleUsedRoots != GroupingChecker.this.nullPackageRoots && !this.subSet(this.roots, bundleUsedRoots.roots) && !this.subSet(bundleUsedRoots.roots, this.roots)) {
                if (results == null) {
                    results = new ArrayList<PackageRoots[]>(1);
                }
                results.add(new PackageRoots[]{this, bundleUsedRoots});
            }
            return this.isConsistentClassSpace(bundleUsedRoots, bundle, visited, results);
        }

        private boolean subSet(ResolverExport[] superSet, ResolverExport[] subSet) {
            ResolverExport[] resolverExportArray = subSet;
            int n = subSet.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverExport subexport = resolverExportArray[n2];
                boolean found = false;
                ResolverExport[] resolverExportArray2 = superSet;
                int n3 = superSet.length;
                int n4 = 0;
                while (n4 < n3) {
                    ResolverExport superexport = resolverExportArray2[n4];
                    if (subexport.getExporter() == superexport.getExporter()) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean superSet(PackageRoots subSet) {
            return this.subSet(this.roots, subSet.roots);
        }

        public String getName() {
            return this.name;
        }

        public ResolverExport[] getRoots() {
            return this.roots;
        }
    }
}

