/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.common.utils.TableUtil;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.nattable.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.viewpoints.policy.AbstractViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableCommandHelper
extends AbstractViewTypeHelper<PapyrusTable> {
    public TableCommandHelper() {
        super(PapyrusTable.class);
    }

    public boolean isSupported(EClass type) {
        return type == RepresentationPackage.eINSTANCE.getPapyrusTable();
    }

    public boolean isSupported(EObject view) {
        if (!(view instanceof Table)) {
            return false;
        }
        Table table = (Table)view;
        return table.getTableKindId() != null || table.getTableConfiguration() != null;
    }

    protected ViewPrototype doGetPrototypeFor(PapyrusTable papyrusTable) {
        return new TableViewPrototype(papyrusTable);
    }

    protected ViewPrototype doGetPrototypeOf(EObject view) {
        return TableUtil.getPrototype((Table)view, false);
    }
}

