/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.inspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.access.AccessManager;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.api.inspector.FeatureCase;
import org.eclipse.passage.lic.api.inspector.FeatureInspector;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.equinox.ApplicationConfigurations;
import org.eclipse.passage.lic.internal.equinox.inspector.EquinoxFeatureCase;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/passage/lic/api/AccessEvents/*"})
public class EquinoxFeatureInspector
implements FeatureInspector,
EventHandler {
    private final Map<String, List<EquinoxFeatureCase>> cases = new HashMap<String, List<EquinoxFeatureCase>>();
    private final Map<String, List<LicensingRequirement>> requirements = new HashMap<String, List<LicensingRequirement>>();
    private final Map<String, List<RestrictionVerdict>> restrictions = new HashMap<String, List<RestrictionVerdict>>();
    private AccessManager accessManager;

    @Reference
    public void bindAccessManager(AccessManager manager) {
        this.accessManager = manager;
    }

    public void unbindAccessManager(AccessManager manager) {
        if (this.accessManager == manager) {
            this.accessManager = null;
        }
    }

    public void handleEvent(Event event) {
    }

    public LicensingConfiguration getLicensingConfiguration() {
        return ApplicationConfigurations.getLicensingConfiguration();
    }

    public FeatureCase inspectFeatures(String ... identifiers) {
        return this.inspectFeatures(Arrays.asList(identifiers));
    }

    public FeatureCase inspectFeatures(Iterable<String> identifiers) {
        ArrayList<String> ids = new ArrayList<String>();
        identifiers.forEach(ids::add);
        if (ids.isEmpty()) {
            LicensingConfiguration configuration = this.getLicensingConfiguration();
            Iterable resolved = this.accessManager.resolveRequirements(configuration);
            resolved.forEach(r -> {
                boolean bl = ids.add(r.getFeatureIdentifier());
            });
        }
        EquinoxFeatureCase efc = new EquinoxFeatureCase(this, ids);
        for (String featureId : ids) {
            this.cases.computeIfAbsent(featureId, list -> new ArrayList()).add(efc);
        }
        return efc;
    }

    void close(EquinoxFeatureCase equinoxFeatureCase) {
        Iterable<String> featureIdentifiers = equinoxFeatureCase.getFeatureIdentifiers();
        for (String featureId : featureIdentifiers) {
            List<EquinoxFeatureCase> list = this.cases.get(featureId);
            list.remove(equinoxFeatureCase);
            if (!list.isEmpty()) continue;
            this.cases.remove(featureId);
        }
    }

    public Iterable<LicensingRequirement> getRequirements(Iterable<String> featureIdentifiers) {
        LicensingConfiguration configuration = this.getLicensingConfiguration();
        ArrayList<LicensingRequirement> result = new ArrayList<LicensingRequirement>();
        for (String featureId : featureIdentifiers) {
            List found = this.requirements.computeIfAbsent(featureId, list -> new ArrayList());
            if (found.isEmpty()) {
                Iterable<LicensingRequirement> examined = this.resolveFeatureRequirements(featureId, configuration);
                examined.forEach(found::add);
            }
            found.forEach(result::add);
        }
        return result;
    }

    public Iterable<RestrictionVerdict> getRestrictions(Iterable<String> featureIdentifiers) {
        LicensingConfiguration configuration = this.getLicensingConfiguration();
        ArrayList<RestrictionVerdict> result = new ArrayList<RestrictionVerdict>();
        for (String featureId : featureIdentifiers) {
            List found = this.restrictions.computeIfAbsent(featureId, list -> new ArrayList());
            found.clear();
            Iterable<RestrictionVerdict> examined = this.examineFeaturePermissions(featureId, configuration);
            examined.forEach(found::add);
            found.forEach(result::add);
        }
        return result;
    }

    public Iterable<RestrictionVerdict> examineFeaturePermissions(String featureId, LicensingConfiguration configuration) {
        ArrayList<LicensingRequirement> featureRequirements = new ArrayList<LicensingRequirement>();
        Iterable resolved = this.accessManager.resolveRequirements(configuration);
        for (LicensingRequirement requirement : resolved) {
            if (!featureId.equals(requirement.getFeatureIdentifier())) continue;
            featureRequirements.add(requirement);
        }
        ArrayList<LicensingCondition> conditions = new ArrayList<LicensingCondition>();
        Iterable extractConditions = this.accessManager.extractConditions(configuration);
        for (LicensingCondition condition : extractConditions) {
            if (!featureId.equals(condition.getFeatureIdentifier())) continue;
            conditions.add(condition);
        }
        Iterable permissions = this.accessManager.evaluateConditions(configuration, conditions);
        ArrayList<RestrictionVerdict> verdicts = new ArrayList<RestrictionVerdict>();
        Iterable examined = this.accessManager.examinePermissions(configuration, featureRequirements, permissions);
        examined.forEach(verdicts::add);
        return verdicts;
    }

    public Iterable<LicensingRequirement> resolveFeatureRequirements(String featureId, LicensingConfiguration configuration) {
        if (featureId == null) {
            return Collections.emptyList();
        }
        ArrayList<LicensingRequirement> result = new ArrayList<LicensingRequirement>();
        Iterable resolveRequirements = this.accessManager.resolveRequirements(configuration);
        for (LicensingRequirement requirement : resolveRequirements) {
            if (!featureId.equals(requirement.getFeatureIdentifier())) continue;
            result.add(requirement);
        }
        return Collections.unmodifiableList(result);
    }
}

