/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.hc.i18n.HcMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRequests {
    private static final String PROTOCOL_TYPE_ID = "http";
    private static final String USER = "user";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequests.class);

    public static Map<String, String> initRequestParams(String host, String port, String roleId, String productId, String productVersion) {
        HashMap<String, String> requestAttributes = new HashMap<String, String>();
        requestAttributes.put(HOST, host);
        requestAttributes.put(PORT, port);
        requestAttributes.put(USER, "12345678");
        requestAttributes.put("role", roleId);
        requestAttributes.put("licensing.product.identifier", productId);
        requestAttributes.put("licensing.product.version", productVersion);
        return requestAttributes;
    }

    private static URIBuilder createRequestUriBuilder(Map<String, String> attributes) {
        String host = null;
        String port = null;
        String hostAttr = attributes.get(HOST);
        if (!(hostAttr instanceof String)) {
            String message = NLS.bind((String)HcMessages.HttpRequests_e_host_invalid, (Object)String.valueOf(hostAttr));
            LOG.info(message);
            return null;
        }
        host = hostAttr;
        String portAttr = attributes.get(PORT);
        if (!(portAttr instanceof String)) {
            String message = NLS.bind((String)HcMessages.HttpRequests_e_port_invalid, (Object)String.valueOf(portAttr));
            LOG.info(message);
            return null;
        }
        port = portAttr;
        String requestHead = String.format("%s://%s:%s", PROTOCOL_TYPE_ID, host, port);
        try {
            URIBuilder builder = new URIBuilder(requestHead);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey().equals(HOST) || entry.getKey().equals(PORT)) continue;
                builder.setParameter(entry.getKey(), entry.getValue());
            }
            return builder;
        }
        catch (URISyntaxException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    public static URIBuilder createRequestURI(Map<String, String> attributes, String action) {
        attributes.put("action", action);
        attributes.put("licensing.content.type", "application/xml");
        return HttpRequests.createRequestUriBuilder(attributes);
    }
}

