/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.terminal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.php.composer.ui.terminal.TerminalConsole;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.control.actions.AbstractTerminalAction;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCut;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;

class TerminalConsolePage
extends Page {
    public static final String TOOLBAR_GROUP_ID = "org.eclipse.php.composer.ui.console.Toolbar";
    private final TerminalConsole terminalConsole;
    private Composite mainComposite;
    private ITerminalViewControl tViewCtrl;
    private MenuManager contextMenuManager;
    private final List<AbstractTerminalAction> contextMenuActions = new ArrayList<AbstractTerminalAction>();
    private Action stopAction = new Action("Stop", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_STOP")){

        public void run() {
            TerminalConsolePage.this.terminalConsole.getTerminalConnector().disconnect();
        }
    };
    private Action removeInactiveAction = new Action("Close All Inactive Consoles", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL")){

        public void run() {
            IConsole[] consoles;
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            HashSet<IConsole> toRemove = new HashSet<IConsole>();
            IConsole[] iConsoleArray = consoles = consoleManager.getConsoles();
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                TerminalConsole terminalConsole;
                TerminalConsolePage terminalConsolePage;
                IConsole console = iConsoleArray[n2];
                if (console instanceof TerminalConsole && (terminalConsolePage = (terminalConsole = (TerminalConsole)console).getTerminalConsolePage()) != null && terminalConsolePage.getTerminalState() == TerminalState.CLOSED) {
                    toRemove.add(console);
                }
                ++n2;
            }
            consoleManager.removeConsoles(toRemove.toArray(new IConsole[toRemove.size()]));
        }
    };
    private Job connectTerminalJob = new ConnectTerminalJob();
    private ITerminalService.Done done;
    private final ITerminalListener listener = new ITerminalListener(){

        public void setState(TerminalState state) {
            if (state == TerminalState.CONNECTING || state == TerminalState.CONNECTED) {
                TerminalConsolePage.this.stopAction.setEnabled(true);
            } else if (state == TerminalState.CLOSED) {
                TerminalConsolePage.this.stopAction.setEnabled(false);
                TerminalConsolePage.this.done.done(Status.OK_STATUS);
            }
        }

        public void setTerminalTitle(String title) {
        }
    };

    public TerminalConsolePage(TerminalConsole console, ITerminalService.Done done) {
        this.terminalConsole = console;
        this.done = done;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IToolBarManager toolBarManager = pageSite.getActionBars().getToolBarManager();
        toolBarManager.insertBefore("outputGroup", (IContributionItem)new GroupMarker(TOOLBAR_GROUP_ID));
        toolBarManager.appendToGroup(TOOLBAR_GROUP_ID, (IAction)this.stopAction);
        toolBarManager.appendToGroup(TOOLBAR_GROUP_ID, (IAction)this.removeInactiveAction);
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new FillLayout());
        this.tViewCtrl = TerminalViewControlFactory.makeControl((ITerminalListener)this.listener, (Composite)this.mainComposite, (ITerminalConnector[])new ITerminalConnector[0]);
        this.tViewCtrl.setConnector(this.terminalConsole.getTerminalConnector());
        boolean invert = Platform.getPreferencesService().getBoolean("org.eclipse.tm.terminal.control", "TerminalPrefInvertColors", false, null);
        this.tViewCtrl.setInvertedColors(invert);
        this.contextMenuManager = new MenuManager("#PopupMenu");
        this.contextMenuManager.add((IAction)this.addAction((AbstractTerminalAction)new TerminalActionCut(this.tViewCtrl)));
        this.contextMenuManager.add((IAction)this.addAction((AbstractTerminalAction)new TerminalActionCopy(this.tViewCtrl)));
        this.contextMenuManager.add((IAction)this.addAction((AbstractTerminalAction)new TerminalActionPaste(this.tViewCtrl)));
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (AbstractTerminalAction action : TerminalConsolePage.this.contextMenuActions) {
                    action.updateAction(true);
                }
            }
        });
        this.tViewCtrl.getControl().setMenu(this.contextMenuManager.createContextMenu(this.tViewCtrl.getControl()));
        this.connectTerminalJob.schedule();
    }

    private AbstractTerminalAction addAction(AbstractTerminalAction action) {
        this.contextMenuActions.add(action);
        return action;
    }

    public Control getControl() {
        return this.mainComposite;
    }

    public void setFocus() {
        this.tViewCtrl.setFocus();
    }

    public TerminalConsole getConsole() {
        return this.terminalConsole;
    }

    public void dispose() {
        this.contextMenuManager.dispose();
        this.tViewCtrl.disposeTerminal();
        super.dispose();
    }

    public TerminalState getTerminalState() {
        return this.tViewCtrl.getState();
    }

    public void connectTerminal() {
        if (!this.tViewCtrl.isConnected()) {
            this.connectTerminalJob.schedule();
        }
    }

    public void disconnectTerminal() {
        if (this.tViewCtrl.getState() != TerminalState.CLOSED) {
            this.tViewCtrl.disconnectTerminal();
        }
    }

    public void setScrollLock(boolean enabled) {
        this.tViewCtrl.setScrollLock(enabled);
    }

    public boolean getScrollLock() {
        return this.tViewCtrl.isScrollLock();
    }

    class ConnectTerminalJob
    extends UIJob {
        public ConnectTerminalJob() {
            super("Connect Terminal");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TerminalConsolePage.this.tViewCtrl != null && !TerminalConsolePage.this.tViewCtrl.isDisposed()) {
                TerminalConsolePage.this.tViewCtrl.clearTerminal();
                TerminalConsolePage.this.tViewCtrl.connectTerminal();
            }
            return Status.OK_STATUS;
        }
    }
}

