/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.workspace.RcpttCore;

public class NamedElementReferencesResolver {
    public static Map<IProject, Set<IQ7NamedElement>> resolveMissingReferences(IQ7NamedElement element) throws ModelException {
        HashMap<IProject, Set<IQ7NamedElement>> missing = new HashMap<IProject, Set<IQ7NamedElement>>();
        if (element == null) {
            return missing;
        }
        IFile file = (IFile)element.getResource();
        if (file == null) {
            return missing;
        }
        IProject project = file.getProject();
        if (!project.exists() || !project.isOpen()) {
            return missing;
        }
        IQ7Project q7Project = RcpttCore.create((IProject)project);
        NamedElementReferencesResolver.resolveReferences(element, q7Project, missing);
        IProject[] referenced = null;
        try {
            referenced = project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        IProject[] iProjectArray = referenced;
        int n = referenced.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (missing.containsKey(p)) {
                missing.remove(p);
            }
            ++n2;
        }
        return missing;
    }

    private static void resolveReferences(IQ7NamedElement element, IQ7Project current, Map<IProject, Set<IQ7NamedElement>> references) throws ModelException {
        block5: {
            TestSuiteItem[] items;
            block6: {
                block4: {
                    String[] verifications;
                    String[] contexts;
                    if (!(element instanceof ITestCase)) break block4;
                    String[] stringArray = contexts = ((ITestCase)element).getContexts();
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String contextId = stringArray[n2];
                        NamedElementReferencesResolver.resolveElementReferences(contextId, current, references);
                        ++n2;
                    }
                    String[] stringArray2 = verifications = ((ITestCase)element).getVerifications();
                    int n3 = verifications.length;
                    n = 0;
                    while (n < n3) {
                        String verificationId = stringArray2[n];
                        NamedElementReferencesResolver.resolveElementReferences(verificationId, current, references);
                        ++n;
                    }
                    break block5;
                }
                if (!(element instanceof IContext)) break block6;
                for (String contextId : RcpttCore.getInstance().getContextReferences((IContext)element)) {
                    NamedElementReferencesResolver.resolveElementReferences(contextId, current, references);
                }
                break block5;
            }
            if (!(element instanceof ITestSuite)) break block5;
            TestSuiteItem[] testSuiteItemArray = items = ((ITestSuite)element).getItems();
            int n = items.length;
            int n4 = 0;
            while (n4 < n) {
                TestSuiteItem item = testSuiteItemArray[n4];
                NamedElementReferencesResolver.resolveElementReferences(item.getNamedElementId(), current, references);
                ++n4;
            }
        }
    }

    private static void resolveElementReferences(String elementId, IQ7Project current, Map<IProject, Set<IQ7NamedElement>> references) throws ModelException {
        if (current.findNamedElement(elementId).length != 0) {
            return;
        }
        IProject[] iProjectArray = RcpttCore.getQ7Projects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject p = iProjectArray[n2];
            IQ7NamedElement[] elements = Q7SearchCore.findById((String)elementId, (ISearchScope)new ISearchScope(){

                public IPath[] getPaths() {
                    return new IPath[]{p.getFullPath()};
                }

                public boolean contains(IPath path) {
                    return false;
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            if (elements != null) {
                IQ7NamedElement[] iQ7NamedElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource;
                    IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n4];
                    Set<IQ7NamedElement> set = references.get(p);
                    if (set == null) {
                        set = new HashSet<IQ7NamedElement>();
                    }
                    if ((resource = iq7NamedElement.getResource()).isAccessible()) {
                        IProject project = resource.getProject();
                        set.add(iq7NamedElement);
                        references.put(project, set);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private NamedElementReferencesResolver() {
    }
}

