/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsPackage;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.tags.TagsFilterComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectTagsFilterDialog
extends TrayDialog {
    private static final String SETTINGS_KEY = "SelectTagDialog";
    private TagsFilterComposite tagsComposite;
    private TreeViewer tagsViewer;
    private TableViewer listViewer;
    private final List<Tag> selectedTags = new ArrayList<Tag>();
    private final List<IQ7NamedElement> selectedItems = new ArrayList<IQ7NamedElement>();

    public SelectTagsFilterDialog(Shell parentShell) {
        super(parentShell);
        Assert.isNotNull((Object)parentShell, (String)"parentShell");
        this.setShellStyle(66768);
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        this.tagsComposite = new TagsFilterComposite(panel, false);
        this.tagsViewer = this.tagsComposite.getTagsViewer();
        this.listViewer = this.tagsComposite.getListViewer();
        this.tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                SelectTagsFilterDialog.this.clearResult();
                for (Object o : iss.toList()) {
                    SelectTagsFilterDialog.this.selectedTags.add((Tag)o);
                }
                SelectTagsFilterDialog.this.validate();
            }
        });
        this.tagsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectTagsFilterDialog.this.setReturnCode(0);
                SelectTagsFilterDialog.this.selectedTags.clear();
                SelectTagsFilterDialog.this.selectedTags.add((Tag)((IStructuredSelection)event.getSelection()).getFirstElement());
                SelectTagsFilterDialog.this.close();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                SelectTagsFilterDialog.this.clearResult();
                for (Object o : iss.toList()) {
                    SelectTagsFilterDialog.this.selectedItems.add((IQ7NamedElement)o);
                }
                SelectTagsFilterDialog.this.validate();
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectTagsFilterDialog.this.setReturnCode(0);
                SelectTagsFilterDialog.this.selectedItems.clear();
                SelectTagsFilterDialog.this.selectedItems.add((IQ7NamedElement)((IStructuredSelection)event.getSelection()).getFirstElement());
                SelectTagsFilterDialog.this.close();
            }
        });
        TagsRegistry tagsRegistry = Q7UIPlugin.getDefault().getTags();
        this.tagsComposite.tags = EMFObservables.observeList((EObject)tagsRegistry, (EStructuralFeature)TagsPackage.Literals.TAGS_REGISTRY__TAGS);
        this.tagsViewer.setInput((Object)this.tagsComposite.tags);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)panel, "org.eclipse.rcptt.help.q7_tags");
        return panel;
    }

    protected void validate() {
        Button button = this.getButton(0);
        if (button != null) {
            if (!this.selectedTags.isEmpty() || !this.selectedItems.isEmpty()) {
                button.setEnabled(true);
            } else {
                button.setEnabled(false);
            }
        }
    }

    public List<Tag> getSelectedTags() {
        return this.selectedTags;
    }

    public List<IQ7NamedElement> getSelectedItems() {
        return this.selectedItems;
    }

    private void clearResult() {
        this.selectedTags.clear();
        this.selectedItems.clear();
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.clearResult();
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectTagDialog_Title);
        newShell.setImage(Images.getImageDescriptor("icons/tag.gif").createImage());
        newShell.layout(true);
    }

    public int open() {
        this.clearResult();
        return super.open();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(SETTINGS_KEY);
        if (section == null) {
            section = root.addNewSection(SETTINGS_KEY);
        }
        return section;
    }
}

