/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.page;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.page.PageNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eScoutTier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class PageNewWizardPage
extends CompilationUnitNewWizardPage {
    public static final String PROP_SHARED_SOURCE_FOLDER = "sharedSourceFolder";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    public static final String PROP_CREATE_ABSTRACT_PAGE = "createAbstractPage";
    protected ProposalTextField m_sharedSourceFolder;
    protected ProposalTextField m_serverSourceFolder;
    private Button m_createAbstractPageButton;
    private boolean m_isPageWithTable;

    public PageNewWizardPage(PackageContainer packageContainer) {
        super(PageNewWizardPage.class.getName(), packageContainer, "TablePage", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable", ScoutTier.Client);
        this.setTitle("Create a new Page");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New Page Details");
    }

    public PageNewWizard getWizard() {
        return (PageNewWizard)super.getWizard();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.guessSharedFolders();
        this.createPageServiceGroup(parent);
        this.createOptionsGroup(parent);
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.getSuperTypeField().getContentProvider();
        superTypeContentProvider.setTypeProposalFilter(superTypeContentProvider.getTypeProposalFilter().and(element -> !"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage".equals(element.getFullyQualifiedName())));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_page_page_context");
    }

    protected void createOptionsGroup(Composite p) {
        Group optionsGroup = FieldToolkit.createGroupBox(p, "Options");
        GridLayoutFactory.swtDefaults().applyTo((Composite)optionsGroup);
        GridDataFactory.defaultsFor((Control)optionsGroup).align(4, 1).applyTo((Control)optionsGroup);
        this.m_createAbstractPageButton = FieldToolkit.createCheckBox((Composite)optionsGroup, "Create an Abstract Super Page", this.isCreateAbstractPage());
        this.m_createAbstractPageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageNewWizardPage.this.setIsCreateAbstractPageInternal(PageNewWizardPage.this.m_createAbstractPageButton.getSelection());
                PageNewWizardPage.this.pingStateChanging();
            }
        });
        GridDataFactory.defaultsFor((Control)this.m_createAbstractPageButton).indent(5, 2).applyTo((Control)this.m_createAbstractPageButton);
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessSharedFolders();
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        IType superType = this.getSuperType();
        if (!JdtUtils.exists((IJavaElement)superType)) {
            this.setIsPageWithTable(false);
            return;
        }
        try {
            ITypeHierarchy supertypeHierarchy = superType.newSupertypeHierarchy(null);
            this.setIsPageWithTable(JdtUtils.hierarchyContains((ITypeHierarchy)supertypeHierarchy, (String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable"));
            if (this.isPageWithTable()) {
                this.setReadOnlySuffix("TablePage");
            } else {
                this.setReadOnlySuffix("NodePage");
            }
            this.setViewSharedSourceFolder();
            this.setViewServerSourceFolder();
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Unable to calculate super type hierarchy for type '{}'.", (Object[])new Object[]{superType.getFullyQualifiedName(), e});
        }
    }

    protected void setViewServerSourceFolder() {
        if (this.m_serverSourceFolder == null) {
            return;
        }
        this.m_serverSourceFolder.setEnabled(this.isPageWithTable());
    }

    protected void setViewSharedSourceFolder() {
        if (this.m_sharedSourceFolder == null) {
            return;
        }
        this.m_sharedSourceFolder.setEnabled(this.isPageWithTable());
    }

    protected void guessSharedFolders() {
        IPackageFragmentRoot clientSourceFolder = this.getSourceFolder();
        if (!JdtUtils.exists((IJavaElement)clientSourceFolder)) {
            return;
        }
        this.setServerSourceFolder(S2eScoutTier.wrap((ScoutTier)ScoutTier.Client).convert(ScoutTier.Server, clientSourceFolder).orElse(null));
        this.setSharedSourceFolder(S2eScoutTier.wrap((ScoutTier)ScoutTier.Client).convert(ScoutTier.Shared, clientSourceFolder).orElse(null));
    }

    @Override
    protected int getLabelWidth() {
        return 120;
    }

    protected void createPageServiceGroup(Composite p) {
        Group parent = FieldToolkit.createGroupBox(p, "PageData and Service Source Folders");
        this.m_sharedSourceFolder = FieldToolkit.createSourceFolderField((Composite)parent, "Shared Source Folder", ScoutTier.Shared, this.getLabelWidth());
        this.m_sharedSourceFolder.acceptProposal(this.getSharedSourceFolder());
        this.m_sharedSourceFolder.addProposalListener(proposal -> {
            this.setSharedSourceFolderInternal((IPackageFragmentRoot)proposal);
            this.pingStateChanging();
        });
        this.setViewSharedSourceFolder();
        this.m_serverSourceFolder = FieldToolkit.createSourceFolderField((Composite)parent, "Server Source Folder", ScoutTier.Server, this.getLabelWidth());
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.setEnabled(this.isPageWithTable());
        this.m_serverSourceFolder.addProposalListener(proposal -> {
            this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
            this.pingStateChanging();
        });
        this.setViewServerSourceFolder();
        GridLayoutFactory.swtDefaults().applyTo((Composite)parent);
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        GridDataFactory.defaultsFor((Control)this.m_sharedSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).indent(0, 8).applyTo((Control)this.m_sharedSourceFolder);
        GridDataFactory.defaultsFor((Control)this.m_serverSourceFolder).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_serverSourceFolder);
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusVisibility());
    }

    protected IStatus getStatusVisibility() {
        if (!JdtUtils.exists((IJavaElement)this.getSharedSourceFolder())) {
            return Status.OK_STATUS;
        }
        if (JdtUtils.exists((IJavaElement)this.getServerSourceFolder()) && !this.getServerSourceFolder().getJavaProject().isOnClasspath((IJavaElement)this.getSharedSourceFolder().getJavaProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The Shared Source Folder is not accessible from the selected Server Source Folder.");
        }
        if (JdtUtils.exists((IJavaElement)this.getSourceFolder()) && !this.getSourceFolder().getJavaProject().isOnClasspath((IJavaElement)this.getSharedSourceFolder().getJavaProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The Shared Source Folder is not accessible from the selected Page Source Folder.");
        }
        return Status.OK_STATUS;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.getProperty(PROP_SHARED_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.setPropertyWithChangingControl(this.m_sharedSourceFolder, () -> this.setSharedSourceFolderInternal(sharedSourceFolder), field -> field.acceptProposal(sharedSourceFolder));
    }

    protected boolean setSharedSourceFolderInternal(IPackageFragmentRoot sharedSourceFolder) {
        return this.setProperty(PROP_SHARED_SOURCE_FOLDER, sharedSourceFolder);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.setPropertyWithChangingControl(this.m_serverSourceFolder, () -> this.setServerSourceFolderInternal(serverSourceFolder), field -> field.acceptProposal(serverSourceFolder));
    }

    protected boolean setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        return this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder);
    }

    public boolean isCreateAbstractPage() {
        Boolean val = this.getProperty(PROP_CREATE_ABSTRACT_PAGE, Boolean.class);
        return val != null && val != false;
    }

    public void setIsCreateAbstractPage(boolean createAbstractPage) {
        this.setPropertyWithChangingControl(this.m_createAbstractPageButton, () -> this.setIsCreateAbstractPageInternal(createAbstractPage), field -> field.setSelection(createAbstractPage));
    }

    protected boolean setIsCreateAbstractPageInternal(boolean createAbstractPage) {
        return this.setProperty(PROP_CREATE_ABSTRACT_PAGE, createAbstractPage);
    }

    protected boolean isPageWithTable() {
        return this.m_isPageWithTable;
    }

    protected void setIsPageWithTable(boolean isPageWithTable) {
        this.m_isPageWithTable = isPageWithTable;
    }
}

