/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.border;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.Border;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.BorderPainter;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.border.LineBorderPainter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class LineBorder
implements Border {
    RGB rgb;
    int lineWidth = 1;
    int gapSize = 5;

    public LineBorder() {
        this(new RGB(0, 0, 0));
    }

    public LineBorder(RGB rgb) {
        this.setRGB(rgb);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.gapSize;
        result = 31 * result + this.lineWidth;
        result = 31 * result + (this.rgb == null ? 0 : this.rgb.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineBorder other = (LineBorder)obj;
        if (this.gapSize != other.gapSize) {
            return false;
        }
        if (this.lineWidth != other.lineWidth) {
            return false;
        }
        return !(this.rgb == null ? other.rgb != null : !this.rgb.equals((Object)other.rgb));
    }

    public void setRGB(RGB rgb) {
        this.rgb = new RGB(rgb.red, rgb.green, rgb.blue);
    }

    public RGB getRGB() {
        return new RGB(this.rgb.red, this.rgb.green, this.rgb.blue);
    }

    public void setLineWidth(int points) {
        if (points < 1) {
            points = 1;
        }
        this.lineWidth = points;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setGapSize(int points) {
        if (points < 1) {
            points = 1;
        }
        this.gapSize = points;
    }

    public int getGapSize() {
        return Math.max(this.lineWidth, this.gapSize);
    }

    @Override
    public BorderPainter createPainter(Device device, GC gc) {
        return new LineBorderPainter(this, device, gc);
    }
}

