/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.viatra.query.runtime.registry.IDefaultRegistryView;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.impl.QuerySpecificationRegistryImpl;

public class QuerySpecificationRegistry
implements IQuerySpecificationRegistry {
    private static final QuerySpecificationRegistry INSTANCE = new QuerySpecificationRegistry();
    private final QuerySpecificationRegistryImpl internalRegistry = new QuerySpecificationRegistryImpl();
    private final Set<IRegistrySourceConnector> delayedConnectors = new HashSet<IRegistrySourceConnector>();

    public static IQuerySpecificationRegistry getInstance() {
        return INSTANCE;
    }

    protected QuerySpecificationRegistry() {
    }

    protected IQuerySpecificationRegistry getInternalRegistry() {
        if (!this.delayedConnectors.isEmpty()) {
            Iterator<IRegistrySourceConnector> it = this.delayedConnectors.iterator();
            while (it.hasNext()) {
                IRegistrySourceConnector connector = it.next();
                this.internalRegistry.addSource(connector);
                it.remove();
            }
        }
        return this.internalRegistry;
    }

    protected void addDelayedSourceConnector(IRegistrySourceConnector connector) {
        this.delayedConnectors.add(connector);
    }

    @Override
    public boolean addSource(IRegistrySourceConnector connector) {
        return this.getInternalRegistry().addSource(connector);
    }

    @Override
    public boolean removeSource(IRegistrySourceConnector connector) {
        return this.getInternalRegistry().removeSource(connector);
    }

    @Override
    public IDefaultRegistryView getDefaultView() {
        return this.getInternalRegistry().getDefaultView();
    }

    @Override
    public IRegistryView createView() {
        return this.getInternalRegistry().createView();
    }

    @Override
    public IRegistryView createView(IRegistryViewFilter filter) {
        return this.getInternalRegistry().createView(filter);
    }

    @Override
    public IRegistryView createView(IRegistryViewFactory factory) {
        return this.getInternalRegistry().createView(factory);
    }
}

