/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences.event;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.internal.core.model.property.event.IPreferenceConstants;
import org.eclipse.wb.internal.core.preferences.Messages;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.CheckButtonEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.ComboSelectionEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.ComboTextEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.RadioButtonsEditor;
import org.eclipse.wb.internal.core.utils.binding.providers.BooleanPreferenceProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.IntegerPreferenceProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public abstract class EventsPreferencePage
extends PreferencePage
implements IPreferenceConstants,
IWorkbenchPreferencePage {
    private final IPreferenceStore m_store;
    private final DataBindManager m_bindManager = new DataBindManager();
    private Button m_typeAnonymous;
    private Button m_typeInnerClass;
    private Button m_typeInterface;
    private Combo m_innerClassPosition;
    private Button m_createStubMethods;
    private Combo m_stubMethodNameTemplate;
    private Combo m_innerClassNameTemplate;
    private Button m_deleteStubMethods;
    private Button m_finalParameters;
    private Button m_decorateIcon;

    public EventsPreferencePage(IPreferenceStore preferenceStore) {
        this.m_store = preferenceStore;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)container).noMargins();
        this.createControls(container);
        return container;
    }

    private void createControls(Composite container) {
        Label eventCodeTypeLabel = new Label(container, 0);
        eventCodeTypeLabel.setText(Messages.EventsPreferencePage_typeLabel);
        this.m_typeAnonymous = new Button(container, 16);
        GridDataFactory.create((Control)this.m_typeAnonymous).indentH(20);
        this.m_typeAnonymous.setText(Messages.EventsPreferencePage_typeAnonymous);
        this.m_typeInnerClass = new Button(container, 16);
        GridDataFactory.create((Control)this.m_typeInnerClass).indentH(20);
        this.m_typeInnerClass.setText(Messages.EventsPreferencePage_typeInner);
        this.m_bindManager.addUpdateEvent((Widget)this.m_typeInnerClass, 13);
        this.m_innerClassPosition = new Combo(container, 8);
        GridDataFactory.create((Control)this.m_innerClassPosition).grabH().fillH().indentH(40);
        this.m_innerClassPosition.setItems(new String[]{Messages.EventsPreferencePage_typeInnerFirstInClass, Messages.EventsPreferencePage_typeInnerLastInClass, Messages.EventsPreferencePage_typeInnerBeforeFirstListener, Messages.EventsPreferencePage_typeInnerAfterLastListener});
        UiUtils.setVisibleItemCount((Combo)this.m_innerClassPosition, (int)this.m_innerClassPosition.getItemCount());
        this.m_innerClassNameTemplate = new Combo(container, 0);
        GridDataFactory.create((Control)this.m_innerClassNameTemplate).grabH().fill().indentH(40);
        this.m_innerClassNameTemplate.setToolTipText(EventsPreferencePage.getInnerClassNameToolTipText());
        this.m_innerClassNameTemplate.setItems(new String[]{"${Component_name}${Listener_name}", "${Component_name}${Listener_className}"});
        UiUtils.setVisibleAll((Combo)this.m_innerClassNameTemplate);
        this.m_typeInterface = new Button(container, 16);
        GridDataFactory.create((Control)this.m_typeInterface).indentH(20);
        this.m_typeInterface.setText(Messages.EventsPreferencePage_typeInterface);
        String toolTipText = EventsPreferencePage.getStubEventHandlerMethodNameToolTipText();
        this.m_createStubMethods = new Button(container, 32);
        this.m_createStubMethods.setText(Messages.EventsPreferencePage_stubLabel);
        this.m_createStubMethods.setToolTipText(toolTipText);
        this.m_bindManager.addUpdateEvent((Widget)this.m_createStubMethods, 13);
        this.m_stubMethodNameTemplate = new Combo(container, 0);
        GridDataFactory.create((Control)this.m_stubMethodNameTemplate).grabH().fill().indentH(20);
        this.m_stubMethodNameTemplate.setToolTipText(toolTipText);
        this.m_stubMethodNameTemplate.setItems(new String[]{"do_${component_name}_${event_name}", "do${Component_name}${Event_name}", "handle_${component_name}_${event_name}", "handle${Component_name}${Event_name}", "${component_name}${Event_name}", "${event_name}${Component_name}", "${event_name}${Component_name}${Component_class_name}"});
        UiUtils.setVisibleAll((Combo)this.m_stubMethodNameTemplate);
        Label patternsLabel = new Label(container, 64);
        GridDataFactory.create((Control)patternsLabel).grabH().fillH().indentH(20);
        patternsLabel.setToolTipText(toolTipText);
        patternsLabel.setText(String.valueOf(Messages.EventsPreferencePage_patternHint1) + Messages.EventsPreferencePage_patternHint2 + Messages.EventsPreferencePage_patternHint3 + Messages.EventsPreferencePage_patternHint4 + Messages.EventsPreferencePage_patternHint5 + Messages.EventsPreferencePage_patternHint6);
        this.m_deleteStubMethods = new Button(container, 32);
        this.m_deleteStubMethods.setText(Messages.EventsPreferencePage_deleteStubsFlag);
        this.m_finalParameters = new Button(container, 32);
        this.m_finalParameters.setText(Messages.EventsPreferencePage_finalParametersFlag);
        this.m_decorateIcon = new Button(container, 32);
        this.m_decorateIcon.setText(Messages.EventsPreferencePage_decorateIconFlag);
        this.m_bindManager.addUpdateRunnable(new Runnable(){

            public void run() {
                boolean inner = EventsPreferencePage.this.m_typeInnerClass.getSelection();
                EventsPreferencePage.this.m_innerClassPosition.setEnabled(inner);
                EventsPreferencePage.this.m_innerClassNameTemplate.setEnabled(inner);
                EventsPreferencePage.this.m_createStubMethods.setEnabled(!inner);
                EventsPreferencePage.this.m_stubMethodNameTemplate.setEnabled(!inner);
                EventsPreferencePage.this.m_stubMethodNameTemplate.setEnabled(EventsPreferencePage.this.m_createStubMethods.getSelection());
            }
        });
        this.m_bindManager.bind((IDataEditor)new RadioButtonsEditor(container), (IDataProvider)new IntegerPreferenceProvider(this.m_store, "property.events.codeType"));
        this.m_bindManager.bind((IDataEditor)new ComboSelectionEditor(this.m_innerClassPosition), (IDataProvider)new IntegerPreferenceProvider(this.m_store, "property.events.innerClassPosition"));
        this.m_bindManager.bind((IDataEditor)new ComboTextEditor(this.m_innerClassNameTemplate), (IDataProvider)new StringPreferenceProvider(this.m_store, "innerClassName"));
        this.m_bindManager.bind((IDataEditor)new CheckButtonEditor(this.m_createStubMethods), (IDataProvider)new BooleanPreferenceProvider(this.m_store, "property.events.stubCreate"));
        this.m_bindManager.bind((IDataEditor)new ComboTextEditor(this.m_stubMethodNameTemplate), (IDataProvider)new StringPreferenceProvider(this.m_store, "stubName"));
        this.m_bindManager.bind((IDataEditor)new CheckButtonEditor(this.m_deleteStubMethods), (IDataProvider)new BooleanPreferenceProvider(this.m_store, "property.events.stubDelete"));
        this.m_bindManager.bind((IDataEditor)new CheckButtonEditor(this.m_finalParameters), (IDataProvider)new BooleanPreferenceProvider(this.m_store, "property.events.finalParameters"));
        this.m_bindManager.bind((IDataEditor)new CheckButtonEditor(this.m_decorateIcon), (IDataProvider)new BooleanPreferenceProvider(this.m_store, "property.events.decorateIcon"));
        this.m_bindManager.performUpdate();
    }

    private static String getStubEventHandlerMethodNameToolTipText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.EventsPreferencePage_stubPatternHint1);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint2);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint3);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint4);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint5);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint6);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint7);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint8);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint9);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint10);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint11);
        buffer.append(Messages.EventsPreferencePage_stubPatternHint12);
        return buffer.toString();
    }

    private static String getInnerClassNameToolTipText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.EventsPreferencePage_innerPatternHint1);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint2);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint3);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint4);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint5);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint6);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint7);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint8);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint9);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint10);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint11);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint12);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint13);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint14);
        buffer.append(Messages.EventsPreferencePage_innerPatternHint15);
        return buffer.toString();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.m_bindManager.performDefault();
    }

    public boolean performOk() {
        this.m_bindManager.performCommit();
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

