import { YAMLSchemaService } from './yamlSchemaService';
import { PromiseConstructor, Thenable, JSONWorkerContribution } from 'vscode-json-languageservice';
import { CompletionItem, CompletionList, TextDocument, Position } from 'vscode-languageserver-types';
import { LanguageSettings } from '../yamlLanguageService';
export declare class YAMLCompletion {
    private schemaService;
    private contributions;
    private promise;
    private customTags;
    private completion;
    constructor(schemaService: YAMLSchemaService, contributions?: JSONWorkerContribution[], promiseConstructor?: PromiseConstructor);
    configure(languageSettings: LanguageSettings, customTags: Array<String>): void;
    doResolve(item: CompletionItem): Thenable<CompletionItem>;
    doComplete(document: TextDocument, position: Position, isKubernetes?: boolean): Thenable<CompletionList>;
    private getPropertyCompletions;
    private getValueCompletions;
    private getContributedValueCompletions;
    private getCustomTagValueCompletions;
    private addSchemaValueCompletions;
    private addSchemaValueCompletionsCore;
    private addDefaultValueCompletions;
    private addEnumValueCompletions;
    private collectTypes;
    private addBooleanValueCompletion;
    private addNullValueCompletion;
    private addCustomTagValueCompletion;
    private getLabelForValue;
    private getSuggestionKind;
    private getCurrentWord;
    private findItemAtOffset;
    private getInsertTextForPlainText;
    private getInsertTextForValue;
    private getInsertTextForObject;
    private getInsertTextForArray;
    private getInsertTextForProperty;
    private evaluateSeparatorAfter;
    /**
     * Corrects simple syntax mistakes to load possible nodes even if a semicolon is missing
     */
    private completionHelper;
    private is_EOL;
    private setKubernetesParserOption;
}
