/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipRelayRunner;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.CallFunctionOnData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.EvaluateData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.RemoteObjectValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParamsWithResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.CallArgumentParam;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.CallFunctionOnParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.EvaluateParams;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class EvaluateHack {
    private final WipTabImpl tabImpl;
    private final AtomicInteger uniqueIdCounter = new AtomicInteger(0);
    private boolean objectInjected = false;
    private static final String GLOBAL_VARIABLE_NAME = "_com_chromium_debug_helper";

    public EvaluateHack(WipTabImpl tabImpl) {
        this.tabImpl = tabImpl;
    }

    public RelayOk evaluateAsync(String expression, Map<String, ? extends WipValueBuilder.SerializableValue> additionalContext, WipValueLoader destinationValueLoader, EvaluateCommandHandler<?> evaluateCommandHandler, final JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
        RelaySyncCallback relaySyncCallback = new RelaySyncCallback(syncCallback);
        final EvaluateSession evaluateSession = new EvaluateSession(expression, additionalContext, destinationValueLoader, evaluateCommandHandler);
        final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
        GenericCallback<Void> postEnsureCallback = new GenericCallback<Void>(){

            public void success(Void value) {
                RelayOk relayOk = evaluateSession.run(callback, guard.getRelay());
                guard.discharge(relayOk);
            }

            public void failure(Exception exception) {
                if (callback != null) {
                    callback.failure(exception);
                }
            }
        };
        return this.ensureObjectInjected(postEnsureCallback, guard.asSyncCallback());
    }

    synchronized void pageReloaded() {
        this.objectInjected = false;
    }

    private synchronized RelayOk ensureObjectInjected(GenericCallback<Void> callback, SyncCallback syncCallback) {
        if (this.objectInjected) {
            callback.success(null);
            return RelaySyncCallback.finish((SyncCallback)syncCallback);
        }
        this.objectInjected = true;
        return this.injectObject(callback, syncCallback);
    }

    private RelayOk injectObject(final GenericCallback<Void> callback, SyncCallback syncCallback) {
        String injectedObjectText = "{ data: {}, code: {}}";
        String expression = "(function() { _com_chromium_debug_helper = " + injectedObjectText + " ; })()";
        EvaluateParams evaluateParams = new EvaluateParams(expression, null, false, null, null, true, null);
        GenericCallback<EvaluateData> wrappedCallback = new GenericCallback<EvaluateData>(){

            public void success(EvaluateData value) {
                callback.success(null);
            }

            public void failure(Exception exception) {
                callback.failure(new Exception("Failed to inject evaluate helper script into remote VM", exception));
            }
        };
        return this.tabImpl.getCommandProcessor().send(evaluateParams, wrappedCallback, syncCallback);
    }

    public static interface EvaluateCommandHandler<DATA> {
        public WipParamsWithResponse<DATA> createRequest(String var1, WipValueLoader var2);

        public JsEvaluateContext.ResultOrException processResult(DATA var1, WipValueLoader var2);

        public Exception processFailure(Exception var1);
    }

    private class EvaluateSession {
        private final String userExpression;
        private final Map<String, ? extends WipValueBuilder.SerializableValue> additionalContext;
        private final WipValueLoader destinationValueLoader;
        private final EvaluateCommandHandler<?> evaluateCommandHandler;
        private final String dataId;

        EvaluateSession(String expression, Map<String, ? extends WipValueBuilder.SerializableValue> additionalContext, WipValueLoader destinationValueLoader, EvaluateCommandHandler<?> evaluateCommandHandler) {
            this.dataId = "d" + EvaluateHack.this.uniqueIdCounter.incrementAndGet();
            this.userExpression = expression;
            this.additionalContext = additionalContext;
            this.destinationValueLoader = destinationValueLoader;
            this.evaluateCommandHandler = evaluateCommandHandler;
        }

        RelayOk run(final JsEvaluateContext.EvaluateCallback callback, RelaySyncCallback relay) {
            WipRelayRunner.Step<JsEvaluateContext.ResultOrException> step = this.createFillDataObjectStep();
            GenericCallback<JsEvaluateContext.ResultOrException> innerCallback = callback == null ? null : new GenericCallback<JsEvaluateContext.ResultOrException>(){

                public void success(JsEvaluateContext.ResultOrException value) {
                    callback.success(value);
                }

                public void failure(Exception exception) {
                    callback.failure(exception);
                }
            };
            return WipRelayRunner.run(EvaluateHack.this.tabImpl.getCommandProcessor(), step, innerCallback, relay);
        }

        private WipRelayRunner.Step<JsEvaluateContext.ResultOrException> createFillDataObjectStep() {
            if (this.additionalContext.isEmpty()) {
                throw new IllegalArgumentException("Empty context");
            }
            StringBuilder assigmentBuilder = new StringBuilder();
            StringBuilder parametersBuilder = new StringBuilder();
            String thisObjectId = null;
            final ArrayList<CallArgumentParam> additionalObjectIds = new ArrayList<CallArgumentParam>(0);
            String tempObjectRef = "_com_chromium_debug_helper.data." + this.dataId + ".";
            for (Map.Entry<String, ? extends WipValueBuilder.SerializableValue> entry : this.additionalContext.entrySet()) {
                String commandParamName;
                WipValueBuilder.SerializableValue jsValueBase = entry.getValue();
                if (thisObjectId == null && jsValueBase.getRefId() != null) {
                    commandParamName = "this";
                    thisObjectId = jsValueBase.getRefId();
                } else {
                    commandParamName = "p" + additionalObjectIds.size();
                    CallArgumentParam callArgumentParam = jsValueBase.createCallArgumentParam();
                    if (callArgumentParam == null) {
                        throw new IllegalArgumentException("Cannot serialize additional context property " + entry.getKey());
                    }
                    additionalObjectIds.add(callArgumentParam);
                    if (parametersBuilder.length() != 0) {
                        parametersBuilder.append(", ");
                    }
                    parametersBuilder.append(commandParamName);
                }
                assigmentBuilder.append(String.valueOf(tempObjectRef) + entry.getKey() + " = " + commandParamName + ";\n");
            }
            if (thisObjectId == null) {
                throw new IllegalArgumentException("At least one additional parameter must be an object");
            }
            final String functionText = "function(" + parametersBuilder + ") { " + EvaluateHack.GLOBAL_VARIABLE_NAME + ".data." + this.dataId + " = {};\n" + assigmentBuilder + "}";
            final String thisObjectIdFinal = thisObjectId;
            return new WipRelayRunner.SendStepWithResponse<CallFunctionOnData, JsEvaluateContext.ResultOrException>(){

                @Override
                public WipParamsWithResponse<CallFunctionOnData> getParams() {
                    List arguments = additionalObjectIds.isEmpty() ? null : additionalObjectIds;
                    return new CallFunctionOnParams(thisObjectIdFinal, functionText, arguments, null, true, null);
                }

                @Override
                public WipRelayRunner.Step<JsEvaluateContext.ResultOrException> processResponse(CallFunctionOnData response) {
                    if (response.wasThrown() == Boolean.TRUE) {
                        return EvaluateSession.this.createHandleErrorStep(response.result());
                    }
                    return EvaluateSession.this.createEvaluateStep(EvaluateSession.this.evaluateCommandHandler);
                }

                @Override
                public Exception processFailure(Exception cause) {
                    return cause;
                }
            };
        }

        private <EVAL_DATA> WipRelayRunner.Step<JsEvaluateContext.ResultOrException> createEvaluateStep(final EvaluateCommandHandler<EVAL_DATA> commandHandler) {
            return new WipRelayRunner.SendStepWithResponse<EVAL_DATA, JsEvaluateContext.ResultOrException>(){

                @Override
                public WipParamsWithResponse<EVAL_DATA> getParams() {
                    String script = "with (_com_chromium_debug_helper.data." + EvaluateSession.this.dataId + ") { return (" + EvaluateSession.this.userExpression + "); }";
                    String wrappedExpression = "(function() {" + script + "})()";
                    WipParamsWithResponse paramsWithResponse = commandHandler.createRequest(wrappedExpression, EvaluateSession.this.destinationValueLoader);
                    return paramsWithResponse;
                }

                @Override
                public WipRelayRunner.Step<JsEvaluateContext.ResultOrException> processResponse(EVAL_DATA response) {
                    JsEvaluateContext.ResultOrException resultOrException = commandHandler.processResult(response, EvaluateSession.this.destinationValueLoader);
                    EvaluateSession.this.clearTempObjectAsync();
                    return WipRelayRunner.createFinalStep(resultOrException);
                }

                @Override
                public Exception processFailure(Exception cause) {
                    return commandHandler.processFailure(cause);
                }
            };
        }

        private void clearTempObjectAsync() {
            String script = "delete _com_chromium_debug_helper.data." + this.dataId + ";";
            String deleteDataExpression = "(function() {" + script + "})()";
            EvaluateParams evaluateParams = new EvaluateParams(deleteDataExpression, null, null, null, null, true, null);
            EvaluateHack.this.tabImpl.getCommandProcessor().send((WipParams)evaluateParams, null, null);
        }

        private WipRelayRunner.Step<JsEvaluateContext.ResultOrException> createHandleErrorStep(final RemoteObjectValue remoteObjectValue) {
            return new WipRelayRunner.SendStepWithResponse<CallFunctionOnData, JsEvaluateContext.ResultOrException>(){

                @Override
                public WipParamsWithResponse<CallFunctionOnData> getParams() {
                    String functionText = "function() { return String(this.message); }";
                    return new CallFunctionOnParams(remoteObjectValue.objectId(), functionText, null, null, true, null);
                }

                @Override
                public WipRelayRunner.Step<JsEvaluateContext.ResultOrException> processResponse(CallFunctionOnData response) throws WipRelayRunner.ProcessException {
                    throw new WipRelayRunner.ProcessException("Helper script failed on remote: " + response.result().value());
                }

                @Override
                public Exception processFailure(Exception cause) {
                    return cause;
                }
            };
        }
    }
}

