/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.InternalEList;

public class ConflictMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        Conflict conflict = target.getConflict();
        return conflict != null && conflict.getKind() == ConflictKind.REAL;
    }

    @Override
    public boolean apply(IMergeCriterion criterion) {
        return criterion == null || criterion == IMergeCriterion.NONE;
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (ConflictMerger.isInTerminalState(target)) {
            return;
        }
        if (target.getSource() == DifferenceSource.LEFT) {
            Conflict conflict = target.getConflict();
            Predicate<Diff> conflictVsMoveAndDelete = this.isConflictVsMoveAndDelete(target, DifferenceKind.MOVE, DifferenceKind.DELETE);
            for (Diff conflictedDiff : this.getDifferences(conflict)) {
                if (conflictedDiff.getSource() != DifferenceSource.RIGHT) continue;
                if (conflictVsMoveAndDelete.apply((Object)conflictedDiff)) {
                    conflictedDiff.setState(DifferenceState.DISCARDED);
                    continue;
                }
                this.mergeConflictedDiff(conflictedDiff, true, monitor);
            }
        }
        this.getMergerDelegate(target).copyLeftToRight(target, monitor);
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (ConflictMerger.isInTerminalState(target)) {
            return;
        }
        if (target.getSource() == DifferenceSource.RIGHT) {
            Conflict conflict = target.getConflict();
            Predicate<Diff> conflictVsMoveAndDelete = this.isConflictVsMoveAndDelete(target, DifferenceKind.MOVE, DifferenceKind.DELETE);
            for (Diff conflictedDiff : this.getDifferences(conflict)) {
                if (conflictedDiff.getSource() != DifferenceSource.LEFT) continue;
                if (conflictVsMoveAndDelete.apply((Object)conflictedDiff)) {
                    conflictedDiff.setState(DifferenceState.DISCARDED);
                    continue;
                }
                this.mergeConflictedDiff(conflictedDiff, false, monitor);
            }
        }
        this.getMergerDelegate(target).copyRightToLeft(target, monitor);
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean rightToLeft) {
        Set<Diff> result = super.getDirectMergeDependencies(diff, rightToLeft);
        if (AbstractMerger.isAccepting(diff, rightToLeft)) {
            Conflict conflict = diff.getConflict();
            DifferenceSource source = diff.getSource();
            Predicate<Diff> conflictVsMoveAndDelete = this.isConflictVsMoveAndDelete(diff, DifferenceKind.DELETE, DifferenceKind.MOVE);
            for (Diff conflictingDiff : this.getDifferences(conflict)) {
                if (conflictingDiff.getSource() == source || conflictingDiff.getKind() == DifferenceKind.MOVE || conflictVsMoveAndDelete.apply((Object)conflictingDiff)) continue;
                result.add(conflictingDiff);
            }
        }
        return result;
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean rightToLeft) {
        Set<Diff> result = super.getDirectResultingMerges(diff, rightToLeft);
        if (AbstractMerger.isAccepting(diff, rightToLeft)) {
            Conflict conflict = diff.getConflict();
            DifferenceSource source = diff.getSource();
            Predicate<Diff> conflictVsMoveAndDelete = this.isConflictVsMoveAndDelete(diff, DifferenceKind.DELETE, DifferenceKind.MOVE);
            for (Diff conflictingDiff : this.getDifferences(conflict)) {
                if (conflictingDiff.getSource() == source || conflictingDiff.getKind() == DifferenceKind.MOVE && !conflictVsMoveAndDelete.apply((Object)conflictingDiff)) continue;
                result.add(conflictingDiff);
            }
        }
        return result;
    }

    private List<Diff> getDifferences(Conflict conflict) {
        return ((InternalEList)conflict.getDifferences()).basicList();
    }

    private Predicate<Diff> isConflictVsMoveAndDelete(final Diff diff, DifferenceKind diffKind, final DifferenceKind otherDiffKind) {
        if (diff.getKind() == diffKind && diff instanceof ReferenceChange) {
            return new Predicate<Diff>(){
                private EObject targetValue;
                private IEqualityHelper equalityHelper;

                public boolean apply(Diff input) {
                    if (input.getKind() == otherDiffKind && input instanceof ReferenceChange) {
                        if (this.equalityHelper == null) {
                            this.equalityHelper = diff.getMatch().getComparison().getEqualityHelper();
                            this.targetValue = ((ReferenceChange)diff).getValue();
                        }
                        return this.equalityHelper.matchingValues(this.targetValue, ((ReferenceChange)input).getValue());
                    }
                    return false;
                }
            };
        }
        return Predicates.alwaysFalse();
    }

    private void mergeConflictedDiff(Diff conflictedDiff, boolean leftToRight, Monitor monitor) {
        if (conflictedDiff.getKind() != DifferenceKind.MOVE) {
            DelegatingMerger delegate = this.getMergerDelegate(conflictedDiff);
            if (leftToRight) {
                delegate.copyLeftToRight(conflictedDiff, monitor);
            } else {
                delegate.copyRightToLeft(conflictedDiff, monitor);
            }
        } else {
            conflictedDiff.setState(DifferenceState.DISCARDED);
        }
    }

    @Override
    protected DelegatingMerger getMergerDelegate(Diff diff) {
        IMergeCriterion criterion = (IMergeCriterion)this.getMergeOptions().get("merge.criterion");
        Iterator<IMerger> it = ((IMerger.Registry2)this.getRegistry()).getMergersByRankDescending(diff, criterion);
        IMerger merger = this;
        while (it.hasNext() && merger == this) {
            merger = it.next();
        }
        if (merger == null) {
            throw new IllegalStateException("No merger found for diff " + diff.getClass().getSimpleName());
        }
        return new DelegatingMerger(merger, criterion);
    }
}

