/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.File;
import java.io.IOException;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.Activator;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPGDB1;
import org.eclipse.photran.internal.core.vpg.PhotranVPGWriter;
import org.eclipse.photran.internal.core.vpg.VPGDB;
import org.eclipse.photran.internal.core.vpg.VPGLog;
import org.eclipse.photran.internal.core.vpg.db.profiling.ProfilingDB;
import org.eclipse.photran.internal.core.vpg.eclipse.IEclipseVPGComponentFactory;

public class PhotranVPGComponentFactory
implements IEclipseVPGComponentFactory<IFortranAST, Token, PhotranTokenRef> {
    @Override
    public VPGLog<Token, PhotranTokenRef> createLog() {
        File logFile = new File(String.valueOf(Activator.getDefault().getStateLocation().addTrailingSeparator().toOSString()) + "photran83vpg-log.txt");
        return new VPGLog<Token, PhotranTokenRef>(logFile, this);
    }

    @Override
    public VPGDB<IFortranAST, Token, PhotranTokenRef> createDatabase(VPGLog<Token, PhotranTokenRef> log) {
        File file;
        File file2 = file = FortranCorePlugin.inTestingMode() ? PhotranVPGComponentFactory.createTempFile() : PhotranVPGComponentFactory.getFileInPluginStateLocation();
        if (FortranPreferences.ENABLE_VPG_LOGGING.getValue()) {
            System.out.println("Using Photran VPG database " + file.getAbsolutePath());
        }
        return new ProfilingDB<IFortranAST, Token, PhotranTokenRef>(new PhotranVPGDB1(this, file, log));
    }

    private static File createTempFile() {
        try {
            File f = File.createTempFile("vpg", null);
            f.deleteOnExit();
            return f;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static File getFileInPluginStateLocation() {
        return new File(String.valueOf(Activator.getDefault().getStateLocation().addTrailingSeparator().toOSString()) + "photran83vpg.new");
    }

    public PhotranVPGWriter createVPGWriter(VPGDB<IFortranAST, Token, PhotranTokenRef> db, VPGLog<Token, PhotranTokenRef> log) {
        return new PhotranVPGWriter(db, log);
    }

    @Override
    public PhotranTokenRef getVPGNode(String filename, int offset, int length) {
        return new PhotranTokenRef(filename, offset, length);
    }
}

