/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.MultiLineStyledTextInputDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.StyledTextInputDialog;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextObjectEditor
extends ObjectEditor {
    protected Text text;
    protected boolean multiLine = false;
    protected boolean testMultiLine = true;
    protected Button expandButton;

    public TextObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        GridData data;
        this.createLabel(composite, label);
        if (this.testMultiLine && super.isMultiLineText()) {
            this.multiLine = true;
        }
        if (this.multiLine) {
            style |= 0x202;
        }
        this.text = this.getToolkit().createText(composite, "", style | 0x800);
        if (this.multiLine) {
            this.expandButton = this.getToolkit().createButton(composite, null, 8);
            this.expandButton.setImage(Activator.getDefault().getImage("20/expand.jpg"));
            this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Dialog dialog = TextObjectEditor.this.createTextInputDialog();
                    TextObjectEditor.this.showTextInputDialog(dialog);
                }
            });
            data = new GridData(1, 1, false, false, 1, 1);
            data.horizontalIndent = 0;
            data.verticalIndent = 0;
            this.expandButton.setLayoutData((Object)data);
            data = new GridData(4, 0x1000000, true, false, 1, 1);
            data.heightHint = 100;
        } else {
            data = new GridData(4, 0x1000000, true, false, 2, 1);
        }
        this.text.setLayoutData((Object)data);
        int textLimit = this.multiLine ? Text.LIMIT : Bpmn2Preferences.getInstance(this.object).getTextLimit();
        this.text.setTextLimit(textLimit);
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && TextObjectEditor.this.multiLine) {
                    e.doit = false;
                }
            }
        });
        this.setText(this.getText());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TextObjectEditor.this.isWidgetUpdating) {
                    TextObjectEditor.this.setValue(TextObjectEditor.this.text.getText());
                }
            }
        });
        Object result = this.getExtendedProperty("ui.can.edit");
        if (result instanceof Boolean) {
            this.setEditable((Boolean)result);
        }
        return this.text;
    }

    protected Dialog createTextInputDialog() {
        String title;
        String initialValue = ExtendedPropertiesProvider.getTextValue(this.object, this.feature);
        String string = title = this.getLabel() == null ? null : this.getLabel().getText();
        if (title == null || title.isEmpty()) {
            title = String.valueOf(ExtendedPropertiesProvider.getLabel(this.object)) + " " + ExtendedPropertiesProvider.getLabel(this.object, this.feature);
        }
        MultiLineStyledTextInputDialog dialog = new MultiLineStyledTextInputDialog(this.getControl().getShell(), title, null, initialValue, null);
        return dialog;
    }

    protected int showTextInputDialog(Dialog dialog) {
        int result = dialog.open();
        if (result == 0 && dialog instanceof StyledTextInputDialog) {
            this.setValue(((StyledTextInputDialog)dialog).getValue());
        }
        return result;
    }

    public void setMultiLine(boolean multiLine) {
        this.testMultiLine = false;
        this.multiLine = multiLine;
    }

    @Override
    public void setObject(EObject object) {
        super.setObject(object);
        this.updateText();
    }

    @Override
    public void setObject(EObject object, EStructuralFeature feature) {
        super.setObject(object, feature);
        this.updateText();
    }

    @Override
    public boolean setValue(Object result) {
        if (this.multiLine && result instanceof String) {
            result = TextObjectEditor.fromPlatformString((String)result);
        }
        if (super.setValue(result)) {
            this.updateText();
            return true;
        }
        this.text.setText(this.getText());
        return false;
    }

    protected void updateText() {
        try {
            this.isWidgetUpdating = true;
            if (!this.text.isDisposed()) {
                String oldText = this.text.getText();
                String newText = this.getText();
                if (newText != null && !newText.equals(oldText)) {
                    int pos = this.text.getCaretPosition();
                    this.setText(newText);
                    this.text.setSelection(pos, pos);
                }
            }
        }
        finally {
            this.isWidgetUpdating = false;
        }
    }

    protected void setText(String value) {
        if (value == null) {
            value = "";
        }
        if (!value.equals(this.text.getText())) {
            this.text.setText(value);
        }
    }

    protected String getText() {
        String value = this.getBusinessObjectDelegate().getTextValue(this.object, this.feature);
        if (this.multiLine && value instanceof String) {
            value = TextObjectEditor.toPlatformString(value);
        }
        if (value == null) {
            return this.canSetNull() ? null : "";
        }
        return value.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        EStructuralFeature f;
        if (notification.getEventType() == -1) {
            super.notifyChanged(notification);
        } else if (this.object == notification.getNotifier() && notification.getFeature() instanceof EStructuralFeature && (f = (EStructuralFeature)notification.getFeature()) != null && (f.getName().equals(this.feature.getName()) || f.getName().equals("mixed"))) {
            this.updateText();
            super.notifyChanged(notification);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.text.setVisible(visible);
        GridData data = (GridData)this.text.getLayoutData();
        data.exclude = !visible;
        this.text.getParent().redraw();
        if (this.expandButton != null && !this.expandButton.isDisposed()) {
            this.expandButton.setVisible(visible);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
            this.text = null;
        }
        if (this.expandButton != null && !this.expandButton.isDisposed()) {
            this.expandButton.dispose();
            this.expandButton = null;
        }
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    public static String fromPlatformString(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll(Text.DELIMITER, "\n");
    }

    public static String toPlatformString(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\n", Text.DELIMITER);
    }
}

