/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CMakeConsoleWrapper;
import org.eclipse.cdt.cmake.core.internal.CMakeErrorParser;
import org.eclipse.cdt.cmake.core.internal.CMakeUtils;
import org.eclipse.cdt.cmake.core.internal.Messages;
import org.eclipse.cdt.cmake.is.core.CompileCommandsJsonParser;
import org.eclipse.cdt.cmake.is.core.IIndexerInfoConsumer;
import org.eclipse.cdt.cmake.is.core.ParseRequest;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;

public class CMakeBuildConfiguration
extends CBuildConfiguration {
    public static final String CMAKE_GENERATOR = "cmake.generator";
    public static final String CMAKE_ARGUMENTS = "cmake.arguments";
    public static final String CMAKE_ENV = "cmake.environment";
    public static final String BUILD_COMMAND = "cmake.command.build";
    public static final String CLEAN_COMMAND = "cmake.command.clean";
    private ICMakeToolChainFile toolChainFile;
    private Map<IResource, IScannerInfo> infoPerResource;
    private boolean cmakeListsModified;

    public CMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, null, "run");
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode) {
        super(config, name, toolChain, launchMode);
        this.toolChainFile = toolChainFile;
    }

    public ICMakeToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return (Platform.getOS().equals(toolchain.getProperty("os")) || "linux-container".equals(toolchain.getProperty("os"))) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            boolean runCMake;
            String generator = this.getProperty(CMAKE_GENERATOR);
            if (generator == null) {
                generator = "Ninja";
            }
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            this.infoPerResource = new HashMap<IResource, IScannerInfo>();
            ConsoleOutputStream infoStream = console.getInfoStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingIn, buildDir.toString()));
            if (this.toolChainFile == null && !this.isLocal()) {
                ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
                this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
                if (this.toolChainFile == null) {
                    console.getErrorStream().write(Messages.CMakeBuildConfiguration_NoToolchainFile);
                    return null;
                }
            }
            if (!(runCMake = this.cmakeListsModified)) {
                switch (generator) {
                    case "Ninja": {
                        runCMake = !Files.exists(buildDir.resolve("build.ninja"), new LinkOption[0]);
                        break;
                    }
                    case "Unix Makefiles": {
                        runCMake = !Files.exists(buildDir.resolve("Makefile"), new LinkOption[0]);
                        break;
                    }
                    default: {
                        boolean bl = runCMake = !Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0]);
                    }
                }
            }
            if (runCMake) {
                CMakeBuildConfiguration.deleteCMakeErrorMarkers(project);
                infoStream.write(String.format(Messages.CMakeBuildConfiguration_Configuring, buildDir));
                this.cleanBuildDirectory(buildDir);
                ArrayList<String> command = new ArrayList<String>();
                command.add("cmake");
                command.add("-G");
                command.add(generator);
                if (this.toolChainFile != null) {
                    command.add("-DCMAKE_TOOLCHAIN_FILE=" + this.toolChainFile.getPath().toString());
                }
                switch (this.getLaunchMode()) {
                    case "debug": {
                        command.add("-DCMAKE_BUILD_TYPE=Debug");
                        break;
                    }
                    case "run": {
                        command.add("-DCMAKE_BUILD_TYPE=Release");
                        break;
                    }
                }
                command.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
                String userArgs = this.getProperty(CMAKE_ARGUMENTS);
                if (userArgs != null) {
                    command.addAll(Arrays.asList(userArgs.trim().split("\\s+")));
                }
                IProject srcFolder = project;
                command.add(new File(srcFolder.getLocationURI()).getAbsolutePath());
                infoStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                Path workingDir = new Path(this.getBuildDirectory().toString());
                CMakeConsoleWrapper errConsole = new CMakeConsoleWrapper((IContainer)srcFolder, console);
                Process p = this.startBuildProcess(command, new IEnvironmentVariable[0], (IPath)workingDir, errConsole, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                    return null;
                }
                this.watchProcess(p, errConsole);
                this.cmakeListsModified = false;
            }
            Throwable throwable = null;
            String string = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                String buildCommand;
                epm.setOutputStream((OutputStream)console.getOutputStream());
                ArrayList<String> command = new ArrayList<String>();
                String envStr = this.getProperty(CMAKE_ENV);
                ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
                if (envStr != null) {
                    List<String> envList = CMakeUtils.stripEnvVars(envStr);
                    for (String s : envList) {
                        int index = s.indexOf("=");
                        if (index == -1) {
                            envVars.add(new EnvironmentVariable(s));
                            continue;
                        }
                        envVars.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                    }
                }
                if ((buildCommand = this.getProperty(BUILD_COMMAND)) == null) {
                    command.add("cmake");
                    command.add("--build");
                    command.add(".");
                    if ("Ninja".equals(generator)) {
                        command.add("--");
                        command.add("-v");
                    }
                } else {
                    command.addAll(Arrays.asList(buildCommand.split(" ")));
                }
                infoStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Process p = this.startBuildProcess(command, envVars.toArray(new IEnvironmentVariable[0]), (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                    return null;
                }
                this.watchProcess(p, new IConsoleParser[]{epm});
                project.refreshLocal(2, monitor);
                this.processCompileCommandsFile(console, monitor);
                infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingComplete, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
                return new IProject[]{project};
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Building, project.getName()), e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            String generator = this.getProperty(CMAKE_GENERATOR);
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0])) {
                outStream.write(Messages.CMakeBuildConfiguration_NotFound);
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            String cleanCommand = this.getProperty(CLEAN_COMMAND);
            if (cleanCommand == null) {
                if (generator == null || generator.equals("Ninja")) {
                    command.add("ninja");
                    command.add("clean");
                } else {
                    command.add("make");
                    command.add("clean");
                }
            } else {
                command.addAll(Arrays.asList(cleanCommand.split(" ")));
            }
            IEnvironmentVariable[] env = new IEnvironmentVariable[]{};
            outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command, env, (IPath)workingDir, console, monitor);
            if (p == null) {
                console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                return;
            }
            this.watchProcess(p, console);
            outStream.write(Messages.CMakeBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    private void processCompileCommandsFile(IConsole console, IProgressMonitor monitor) throws CoreException {
        CompileCommandsJsonParser parser = new CompileCommandsJsonParser(new ParseRequest((CBuildConfiguration)this, (IIndexerInfoConsumer)new CMakeIndexerInfoConsumer(this::setScannerInformation), CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)this), console));
        parser.parse(monitor);
    }

    private static void cleanDirectory(java.nio.file.Path dir) throws IOException {
        java.nio.file.Path[] files;
        SimpleFileVisitor<java.nio.file.Path> deltor = new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                super.postVisitDirectory(dir, exc);
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
        java.nio.file.Path[] pathArray = files = (java.nio.file.Path[])Files.list(dir).toArray(java.nio.file.Path[]::new);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            java.nio.file.Path file = pathArray[n2];
            Files.walkFileTree(file, (FileVisitor<? super java.nio.file.Path>)deltor);
            ++n2;
        }
    }

    private void cleanBuildDirectory(java.nio.file.Path buildDir) throws IOException {
        if (!Files.exists(buildDir, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(buildDir, new LinkOption[0])) {
            CMakeBuildConfiguration.cleanDirectory(buildDir);
        }
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        if (this.infoPerResource == null) {
            this.infoPerResource = new HashMap<IResource, IScannerInfo>();
            try {
                this.processCompileCommandsFile(null, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return this.infoPerResource.get(resource);
    }

    private void setScannerInformation(Map<IResource, IScannerInfo> infoPerResource) {
        this.infoPerResource = infoPerResource;
    }

    public void elementChanged(ElementChangedEvent event) {
        super.elementChanged(event);
        if (event.getType() != 1) {
            return;
        }
        if (!this.cmakeListsModified) {
            this.processElementDelta(event.getDelta());
        }
    }

    private boolean processElementDelta(ICElementDelta delta) {
        int n;
        IResourceDelta[] resourceDeltas;
        if (delta == null) {
            return true;
        }
        if (delta.getKind() == 4 && (delta.getFlags() & 1) != 0 && (resourceDeltas = delta.getResourceDeltas()) != null) {
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            int n2 = resourceDeltas.length;
            n = 0;
            while (n < n2) {
                String name;
                IResourceDelta resourceDelta = iResourceDeltaArray[n];
                IResource resource = resourceDelta.getResource();
                if (resource.getType() == 1 && ((name = resource.getName()).equals("CMakeLists.txt") || name.endsWith(".cmake"))) {
                    this.cmakeListsModified = true;
                    return false;
                }
                ++n;
            }
        }
        ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
        n = iCElementDeltaArray.length;
        int n3 = 0;
        while (n3 < n) {
            ICElementDelta child = iCElementDeltaArray[n3];
            if (!this.processElementDelta(child)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean processLine(String line) {
        return true;
    }

    public boolean processLine(String line, List<Job> jobsArray) {
        return true;
    }

    public void shutdown() {
    }

    private static void deleteCMakeErrorMarkers(IProject project) throws CoreException {
        project.deleteMarkers(CMakeErrorParser.CMAKE_PROBLEM_MARKER_ID, false, 2);
    }

    private static class CMakeIndexerInfoConsumer
    implements IIndexerInfoConsumer {
        private Map<IResource, IScannerInfo> infoPerResource = new HashMap<IResource, IScannerInfo>();
        private boolean haveUpdates;
        private final Consumer<Map<IResource, IScannerInfo>> resultSetter;

        public CMakeIndexerInfoConsumer(Consumer<Map<IResource, IScannerInfo>> resultSetter) {
            this.resultSetter = Objects.requireNonNull(resultSetter);
        }

        public void acceptSourceFileInfo(String sourceFileName, List<String> systemIncludePaths, Map<String, String> definedSymbols, List<String> includePaths, List<String> macroFiles, List<String> includeFiles) {
            IFile file = this.getFileForCMakePath(sourceFileName);
            if (file != null) {
                ExtendedScannerInfo info = new ExtendedScannerInfo(definedSymbols, (String[])systemIncludePaths.stream().toArray(String[]::new), (String[])macroFiles.stream().toArray(String[]::new), (String[])includeFiles.stream().toArray(String[]::new), (String[])includePaths.stream().toArray(String[]::new));
                this.infoPerResource.put((IResource)file, (IScannerInfo)info);
                this.haveUpdates = true;
            }
        }

        private IFile getFileForCMakePath(String sourceFileName) {
            Path path = new Path(sourceFileName);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            return file;
        }

        public void shutdown() {
            if (this.haveUpdates) {
                this.resultSetter.accept(this.infoPerResource);
                this.infoPerResource = null;
                this.haveUpdates = false;
            }
        }
    }
}

