/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import java.util.function.Supplier;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;

public class ScriptTemplateProposal
extends TemplateProposal
implements ICompletionProposalExtension4 {
    private Supplier<Image> fImageFactory;
    private Image fComputedImage;
    private boolean isRelevanceOverriden;
    private int relevanceOverride;

    public ScriptTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public ScriptTemplateProposal(Template template, TemplateContext context, IRegion region, Supplier<Image> image, int relevance) {
        super(template, context, region, null, relevance);
        this.fImageFactory = image;
    }

    public int getRelevance() {
        return this.isRelevanceOverriden ? this.relevanceOverride : super.getRelevance();
    }

    public void setImageFactory(Supplier<Image> factory) {
        this.fImageFactory = factory;
    }

    public Supplier<Image> getImageFactory() {
        return this.fImageFactory;
    }

    public void setRelevance(int value) {
        this.relevanceOverride = value;
        this.isRelevanceOverriden = true;
    }

    public String getAdditionalProposalInfo() {
        TemplateContext context = this.getContext();
        if (context instanceof ScriptTemplateContext) {
            ScriptTemplateContext scriptContext = (ScriptTemplateContext)context;
            try {
                this.getContext().setReadOnly(true);
                TemplateBuffer templateBuffer = scriptContext.evaluate(this.getTemplate());
                IDocument document = scriptContext.getDocument();
                String indenting = ScriptTemplateContext.calculateIndent(document, scriptContext.getStart());
                String delimeter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                String info = templateBuffer.getString();
                return info.replaceAll(String.valueOf(delimeter) + indenting, delimeter);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (TemplateException templateException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getTemplateName() {
        return this.getTemplate().getName();
    }

    public String getPattern() {
        return this.getTemplate().getPattern();
    }

    public boolean isAutoInsertable() {
        if (this.isSelectionTemplate()) {
            return false;
        }
        return this.getTemplate().isAutoInsertable();
    }

    private boolean isSelectionTemplate() {
        DocumentTemplateContext ctx;
        return this.getContext() instanceof DocumentTemplateContext && (ctx = (DocumentTemplateContext)this.getContext()).getCompletionLength() > 0;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public Image getImage() {
        if (this.fComputedImage != null) {
            return this.fComputedImage;
        }
        if (this.fImageFactory != null) {
            this.fComputedImage = this.fImageFactory.get();
            return this.fComputedImage;
        }
        return super.getImage();
    }
}

