/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.findreferences;

import com.google.common.base.Predicate;
import com.google.inject.Injector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;

public class DotReferenceFinder
extends ReferenceFinder {
    private static DotReferenceFinder INSTANCE;

    private DotReferenceFinder() {
    }

    static DotReferenceFinder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DotReferenceFinder();
            Injector injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.Dot");
            injector.injectMembers((Object)INSTANCE);
        }
        return INSTANCE;
    }

    protected IReferenceFinder getLanguageSpecificReferenceFinder(URI candidate) {
        return DotReferenceFinder.getInstance();
    }

    public void findReferences(TargetURIs targetURIs, Resource resource, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        for (URI targetURI : targetURIs) {
            EObject target = resource.getEObject(targetURI.fragment());
            if (!(target instanceof NodeId)) continue;
            acceptor.accept(target, targetURI, null, -1, target, targetURI);
            NodeId selectedNodeId = (NodeId)target;
            for (NodeId source : DotAstHelper.getAllNodeIds((NodeId)selectedNodeId)) {
                URI sourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)source);
                acceptor.accept((EObject)source, sourceURI, null, -1, target, targetURI);
            }
        }
    }

    public void findReferences(Predicate<URI> targetURIs, EObject scope, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        if (targetURIs instanceof TargetURIs) {
            this.findReferences((TargetURIs)targetURIs, scope.eResource(), acceptor, monitor);
        }
    }
}

