/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Stmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DotAstHelper {
    public static NodeId getNodeId(NodeId nodeId) {
        Object _xblockexpression = null;
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)nodeId, DotGraph.class);
        Iterable<NodeStmt> _allNodeStatements = DotAstHelper.getAllNodeStatements(dotGraph);
        for (NodeStmt nodeStmt : _allNodeStatements) {
            if (nodeStmt.getNode() == null || !Objects.equal((Object)nodeStmt.getNode().getName(), (Object)nodeId.getName())) continue;
            return nodeStmt.getNode();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static List<NodeId> getAllNodeIds(NodeId baseNodeId) {
        LinkedList _xblockexpression = null;
        LinkedList result = CollectionLiterals.newLinkedList();
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)baseNodeId, DotGraph.class);
        Iterable _filter = Iterables.filter(dotGraph.getStmts(), NodeStmt.class);
        for (NodeStmt nodeStmt : _filter) {
            NodeId nodeId = nodeStmt.getNode();
            if (nodeId == null || !Objects.equal((Object)nodeId.getName(), (Object)baseNodeId.getName()) || Objects.equal((Object)nodeId, (Object)baseNodeId)) continue;
            result.add(nodeId);
        }
        Iterable _filter_1 = Iterables.filter(dotGraph.getStmts(), EdgeStmtNode.class);
        for (EdgeStmtNode edgeStmtNode : _filter_1) {
            EdgeRhs edgeRHS;
            NodeId nodeId = edgeStmtNode.getNode();
            if (nodeId != null && Objects.equal((Object)nodeId.getName(), (Object)baseNodeId.getName()) && nodeId != baseNodeId) {
                result.add(nodeId);
            }
            if (!((edgeRHS = (EdgeRhs)IterableExtensions.head(edgeStmtNode.getEdgeRHS())) instanceof EdgeRhsNode) || (nodeId = ((EdgeRhsNode)edgeRHS).getNode()) == null || !Objects.equal((Object)nodeId.getName(), (Object)baseNodeId.getName()) || nodeId == baseNodeId) continue;
            result.add(nodeId);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static LinkedList<Attribute> getAllAttributesSameValue(Attribute comparator) {
        LinkedList _xblockexpression = null;
        LinkedList result = CollectionLiterals.newLinkedList();
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)comparator, DotGraph.class);
        Object comparatorParsed = DotAttributes.parsed(comparator);
        Functions.Function1 _function = e -> {
            boolean _xblockexpression_1 = false;
            Object parsed = DotAttributes.parsed(e);
            boolean _xifexpression = false;
            _xifexpression = parsed instanceof EObject && comparatorParsed instanceof EObject ? EcoreUtil2.equals((EObject)((EObject)parsed), (EObject)((EObject)comparatorParsed)) : Objects.equal((Object)parsed, (Object)comparatorParsed);
            _xblockexpression_1 = _xifexpression;
            return _xblockexpression_1;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)dotGraph, Attribute.class), (Functions.Function1)_function);
        for (Attribute candidate : _filter) {
            result.add(candidate);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static LinkedList<Attribute> getAllAttributesSameName(Attribute comparator) {
        LinkedList _xblockexpression = null;
        LinkedList result = CollectionLiterals.newLinkedList();
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)comparator, DotGraph.class);
        ID _name = null;
        if (comparator != null) {
            _name = comparator.getName();
        }
        String _value = null;
        if (_name != null) {
            _value = _name.toValue();
        }
        String comparatorName = _value;
        Functions.Function1 _function = e -> {
            ID _name_1 = null;
            if (e != null) {
                _name_1 = e.getName();
            }
            String _value_1 = null;
            if (_name_1 != null) {
                _value_1 = _name_1.toValue();
            }
            return Objects.equal((Object)_value_1, (Object)comparatorName);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)dotGraph, Attribute.class), (Functions.Function1)_function);
        for (Attribute candidate : _filter) {
            result.add(candidate);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static String getColorSchemeAttributeValue(Attribute attribute) {
        return DotAstHelper.getDependedOnAttributeValue(attribute, "colorscheme");
    }

    public static String getDependedOnAttributeValue(Attribute dependentAttribute, String attributeName) {
        ID dependedOnValue_3;
        ID dependedOnValue_2;
        AttrStmt attrStmt;
        NodeStmt nodeStmt;
        Object _xblockexpression = null;
        EdgeStmtNode edgeStmtNode = (EdgeStmtNode)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, EdgeStmtNode.class);
        if (edgeStmtNode != null) {
            ID dependedOnValue = DotAstHelper.getAttributeValue(edgeStmtNode.getAttrLists(), attributeName);
            if (dependedOnValue != null) {
                return dependedOnValue.toValue();
            }
            dependedOnValue = DotAstHelper.getGlobalDependedOnValue(edgeStmtNode, AttributeType.EDGE, attributeName);
            if (dependedOnValue != null) {
                return dependedOnValue.toValue();
            }
        }
        if ((nodeStmt = (NodeStmt)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, NodeStmt.class)) != null) {
            ID dependedOnValue_1 = DotAstHelper.getAttributeValue(nodeStmt.getAttrLists(), attributeName);
            if (dependedOnValue_1 != null) {
                return dependedOnValue_1.toValue();
            }
            dependedOnValue_1 = DotAstHelper.getGlobalDependedOnValue(nodeStmt, AttributeType.NODE, attributeName);
            if (dependedOnValue_1 != null) {
                return dependedOnValue_1.toValue();
            }
        }
        if ((attrStmt = (AttrStmt)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, AttrStmt.class)) != null && (dependedOnValue_2 = DotAstHelper.getAttributeValue(attrStmt.getAttrLists(), attributeName)) != null) {
            return dependedOnValue_2.toValue();
        }
        Subgraph subgraph = (Subgraph)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, Subgraph.class);
        if (subgraph != null && (dependedOnValue_3 = DotAstHelper.getAttributeValue(subgraph, attributeName)) != null) {
            return dependedOnValue_3.toValue();
        }
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)dependentAttribute, DotGraph.class);
        if (dotGraph != null) {
            ID dependedOnValue_4 = DotAstHelper.getAttributeValueAll(dotGraph, attributeName);
            if (dependedOnValue_4 != null) {
                return dependedOnValue_4.toValue();
            }
            dependedOnValue_4 = DotAstHelper.getGlobalDependedOnValue(dotGraph, AttributeType.GRAPH, attributeName);
            if (dependedOnValue_4 != null) {
                return dependedOnValue_4.toValue();
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static ID getGlobalDependedOnValue(EObject eObject, AttributeType attributeType, String attributeName) {
        ID value_1;
        ID value;
        Object _xblockexpression = null;
        Subgraph subgraph = (Subgraph)EcoreUtil2.getContainerOfType((EObject)eObject, Subgraph.class);
        if (subgraph != null && (value = DotAstHelper.getAttributeValue(subgraph.getStmts(), attributeType, attributeName)) != null) {
            return value;
        }
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)eObject, DotGraph.class);
        if (dotGraph != null && (value_1 = DotAstHelper.getAttributeValue(dotGraph.getStmts(), attributeType, attributeName)) != null) {
            return value_1;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static ID getAttributeValue(EList<Stmt> stmts, AttributeType attributeType, String attributeName) {
        Object _xblockexpression = null;
        for (Stmt stmt : stmts) {
            AttributeType _type;
            boolean _equals;
            if (!(stmt instanceof AttrStmt) || !(_equals = Objects.equal((Object)((Object)(_type = ((AttrStmt)stmt).getType())), (Object)((Object)attributeType)))) continue;
            return DotAstHelper.getAttributeValue(((AttrStmt)stmt).getAttrLists(), attributeName);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValue(DotGraph graph, String name) {
        Object _xblockexpression = null;
        EList<Stmt> _stmts = graph.getStmts();
        for (Stmt stmt : _stmts) {
            ID value;
            ID _switchResult = null;
            boolean _matched = false;
            if (stmt instanceof Attribute) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue((Attribute)stmt, name);
            }
            if ((value = _switchResult) == null) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValueAll(DotGraph graph, String name) {
        Object _xblockexpression = null;
        EList<Stmt> _stmts = graph.getStmts();
        for (Stmt stmt : _stmts) {
            ID value;
            ID _switchResult = null;
            boolean _matched = false;
            if (stmt instanceof AttrStmt) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue(((AttrStmt)stmt).getAttrLists(), name);
            }
            if (!_matched && stmt instanceof Attribute) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue((Attribute)stmt, name);
            }
            if ((value = _switchResult) == null) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValue(Subgraph subgraph, String name) {
        Object _xblockexpression = null;
        EList<Stmt> _stmts = subgraph.getStmts();
        for (Stmt stmt : _stmts) {
            ID value;
            ID _switchResult = null;
            boolean _matched = false;
            if (stmt instanceof Attribute) {
                _matched = true;
                _switchResult = DotAstHelper.getAttributeValue((Attribute)stmt, name);
            }
            if ((value = _switchResult) == null) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public static ID getAttributeValue(List<AttrList> attrLists, String name) {
        Object _xblockexpression = null;
        for (AttrList attrList : attrLists) {
            ID value = DotAstHelper.getAttributeValue(attrList, name);
            if (value == null) continue;
            return value;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static ID getAttributeValue(AttrList attrList, String name) {
        Functions.Function1 _function = it -> {
            String _value = it.getName().toValue();
            return Objects.equal((Object)_value, (Object)name);
        };
        Attribute _findFirst = (Attribute)IterableExtensions.findFirst(attrList.getAttributes(), (Functions.Function1)_function);
        ID _value = null;
        if (_findFirst != null) {
            _value = _findFirst.getValue();
        }
        return _value;
    }

    private static ID getAttributeValue(Attribute attribute, String name) {
        Object _xblockexpression = null;
        boolean _equals = attribute.getName().toValue().equals(name);
        if (_equals) {
            return attribute.getValue();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private static Iterable<NodeStmt> getAllNodeStatements(DotGraph dotGraph) {
        Iterable _xblockexpression = null;
        Iterable nodeStamentsInDotGraph = Iterables.filter(dotGraph.getStmts(), NodeStmt.class);
        LinkedList nodeStatementsInSubgraphs = CollectionLiterals.newLinkedList();
        Consumer<Subgraph> _function = it -> {
            List<NodeStmt> _allNodeStatementsInSubgraph = DotAstHelper.getAllNodeStatementsInSubgraph(it);
            Iterables.addAll((Collection)nodeStatementsInSubgraphs, _allNodeStatementsInSubgraph);
        };
        Iterables.filter(dotGraph.getStmts(), Subgraph.class).forEach(_function);
        _xblockexpression = Iterables.concat((Iterable)nodeStamentsInDotGraph, (Iterable)nodeStatementsInSubgraphs);
        return _xblockexpression;
    }

    private static List<NodeStmt> getAllNodeStatementsInSubgraph(Subgraph subgraph) {
        List _xblockexpression = null;
        List nodeStatementInSubgraph = IterableExtensions.toList((Iterable)Iterables.filter(subgraph.getStmts(), NodeStmt.class));
        Consumer<Subgraph> _function = it -> {
            List<NodeStmt> _allNodeStatementsInSubgraph = DotAstHelper.getAllNodeStatementsInSubgraph(it);
            Iterables.addAll((Collection)nodeStatementInSubgraph, _allNodeStatementsInSubgraph);
        };
        Iterables.filter(subgraph.getStmts(), Subgraph.class).forEach(_function);
        _xblockexpression = nodeStatementInSubgraph;
        return _xblockexpression;
    }
}

