/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.archive.dto.AutDTO;
import org.eclipse.jubula.client.archive.dto.CategoryDTO;
import org.eclipse.jubula.client.archive.dto.CheckConfigurationDTO;
import org.eclipse.jubula.client.archive.dto.ComponentNameDTO;
import org.eclipse.jubula.client.archive.dto.ExecCategoryDTO;
import org.eclipse.jubula.client.archive.dto.NamedTestDataDTO;
import org.eclipse.jubula.client.archive.dto.NodeDTO;
import org.eclipse.jubula.client.archive.dto.ReportingRuleDTO;
import org.eclipse.jubula.client.archive.dto.ReusedProjectDTO;
import org.eclipse.jubula.client.archive.dto.TestCaseDTO;
import org.eclipse.jubula.client.archive.dto.TestDataCategoryDTO;
import org.eclipse.jubula.client.archive.dto.TestJobDTO;
import org.eclipse.jubula.client.archive.dto.TestSuiteDTO;
import org.eclipse.jubula.client.archive.dto.TestresultSummaryDTO;
import org.eclipse.jubula.client.archive.dto.UsedToolkitDTO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ProjectVersion;

public class ProjectDTO
extends NodeDTO {
    private List<TestDataCategoryDTO> m_testDataCategories = new ArrayList<TestDataCategoryDTO>();
    private List<NamedTestDataDTO> m_namedTestDatas = new ArrayList<NamedTestDataDTO>();
    private List<AutDTO> m_auts = new ArrayList<AutDTO>();
    private List<NodeDTO> m_categories = new ArrayList<NodeDTO>();
    private List<NodeDTO> m_execCategories = new ArrayList<NodeDTO>();
    private Integer m_majorProjectVersion;
    private Integer m_minorProjectVersion;
    private Integer m_trackingSpan;
    private Integer m_microProjectVersion;
    private Integer m_metaDataVersion;
    private Integer m_testResultDetailsCleanupInterval;
    private boolean m_isReusable = false;
    private boolean m_isProtected = false;
    private List<ReusedProjectDTO> m_reusedProjects = new ArrayList<ReusedProjectDTO>();
    private List<UsedToolkitDTO> m_usedToolkits = new ArrayList<UsedToolkitDTO>();
    private List<ComponentNameDTO> m_componentNames = new ArrayList<ComponentNameDTO>();
    private List<TestresultSummaryDTO> m_testresultSummaries = new ArrayList<TestresultSummaryDTO>();
    private List<CheckConfigurationDTO> m_checkConfigurations = new ArrayList<CheckConfigurationDTO>();
    private boolean m_teststyleEnabled = false;
    private boolean m_isReportOnSuccess = false;
    private boolean m_isReportOnFailure = false;
    private boolean m_trackingEnabled = false;
    private String m_almRepositoryName;
    private String m_dashboardURL;
    private String m_trackingAttribute;
    private String m_trackingUnit;
    private String m_markupLanguage;
    private String m_projectVersionQualifier;
    private String m_autToolKit;
    private List<ReportingRuleDTO> m_reportingRules = new ArrayList<ReportingRuleDTO>();

    public ProjectDTO() {
    }

    public ProjectDTO(IProjectPO project) {
        super((INodePO)project);
    }

    @JsonProperty(value="testDataCategories")
    public List<TestDataCategoryDTO> getTestDataCategories() {
        return this.m_testDataCategories;
    }

    public void addTestDataCategorie(TestDataCategoryDTO testDataCategorie) {
        this.m_testDataCategories.add(testDataCategorie);
    }

    @JsonProperty(value="namedTestDatas")
    public List<NamedTestDataDTO> getNamedTestDatas() {
        return this.m_namedTestDatas;
    }

    public void addNamedTestData(NamedTestDataDTO namedTestData) {
        this.m_namedTestDatas.add(namedTestData);
    }

    @JsonProperty(value="auts")
    public List<AutDTO> getAuts() {
        return this.m_auts;
    }

    public void addAut(AutDTO aut) {
        this.m_auts.add(aut);
    }

    @JsonProperty(value="categories")
    public List<NodeDTO> getCategories() {
        return this.m_categories;
    }

    public void addCategory(NodeDTO node) {
        if (!(node instanceof TestCaseDTO) && !(node instanceof CategoryDTO)) {
            throw new IllegalArgumentException();
        }
        this.m_categories.add(node);
    }

    @JsonProperty(value="execCategories")
    public List<NodeDTO> getExecCategories() {
        return this.m_execCategories;
    }

    public void addExecCategorie(NodeDTO node) {
        if (!(node instanceof TestSuiteDTO || node instanceof TestJobDTO || node instanceof ExecCategoryDTO)) {
            throw new IllegalArgumentException();
        }
        this.m_execCategories.add(node);
    }

    @JsonIgnore
    public ProjectVersion getProjectVersion() {
        return new ProjectVersion(this.m_majorProjectVersion, this.m_minorProjectVersion, this.m_microProjectVersion);
    }

    @JsonProperty(value="metaDataVersion")
    public Integer getMetaDataVersion() {
        return this.m_metaDataVersion;
    }

    public void setMetaDataVersion(Integer metaDataVersion) {
        this.m_metaDataVersion = metaDataVersion;
    }

    @JsonProperty(value="microProjectVersion")
    public Integer getMicroProjectVersion() {
        return this.m_microProjectVersion;
    }

    public void setMicroProjectVersion(Integer microProjectVersion) {
        this.m_microProjectVersion = microProjectVersion;
    }

    @JsonProperty(value="majorProjectVersion")
    public Integer getMajorProjectVersion() {
        return this.m_majorProjectVersion;
    }

    public void setMajorProjectVersion(Integer majorProjectVersion) {
        this.m_majorProjectVersion = majorProjectVersion;
    }

    @JsonProperty(value="minorProjectVersion")
    public Integer getMinorProjectVersion() {
        return this.m_minorProjectVersion;
    }

    public void setMinorProjectVersion(Integer minorProjectVersion) {
        this.m_minorProjectVersion = minorProjectVersion;
    }

    @JsonProperty(value="trackingSpan")
    public Integer getTrackingSpan() {
        return this.m_trackingSpan;
    }

    public void setTrackingSpan(Integer trackingSpan) {
        this.m_trackingSpan = trackingSpan;
    }

    @JsonProperty(value="testResultDetailsCleanupInterval")
    public Integer getTestResultDetailsCleanupInterval() {
        return this.m_testResultDetailsCleanupInterval;
    }

    public void setTestResultDetailsCleanupInterval(Integer testResultDetailsCleanupInterval) {
        this.m_testResultDetailsCleanupInterval = testResultDetailsCleanupInterval;
    }

    @JsonProperty(value="isReusable")
    public boolean isReusable() {
        return this.m_isReusable;
    }

    public void setReusable(boolean isReusable) {
        this.m_isReusable = isReusable;
    }

    @JsonProperty(value="isProtected")
    public boolean isProtected() {
        return this.m_isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.m_isProtected = isProtected;
    }

    @JsonProperty(value="reusedProjects")
    public List<ReusedProjectDTO> getReusedProjects() {
        return this.m_reusedProjects;
    }

    public void addReusedProject(ReusedProjectDTO reusedProject) {
        this.m_reusedProjects.add(reusedProject);
    }

    @JsonProperty(value="usedToolkits")
    public List<UsedToolkitDTO> getUsedToolkits() {
        return this.m_usedToolkits;
    }

    public void addUsedToolkit(UsedToolkitDTO usedToolkit) {
        this.m_usedToolkits.add(usedToolkit);
    }

    @JsonProperty(value="componentNames")
    public List<ComponentNameDTO> getComponentNames() {
        return this.m_componentNames;
    }

    public void addComponentName(ComponentNameDTO componentName) {
        this.m_componentNames.add(componentName);
    }

    @JsonProperty(value="testresultSummaries")
    public List<TestresultSummaryDTO> getTestresultSummaries() {
        return this.m_testresultSummaries;
    }

    public void addTestresultSummary(TestresultSummaryDTO testresultSummary) {
        this.m_testresultSummaries.add(testresultSummary);
    }

    public void setTestresultSummaries(List<TestresultSummaryDTO> testresultSummaries) {
        this.m_testresultSummaries = testresultSummaries;
    }

    @JsonProperty(value="checkConfigurations")
    public List<CheckConfigurationDTO> getCheckConfigurations() {
        return this.m_checkConfigurations;
    }

    public void addCheckConfiguration(CheckConfigurationDTO checkConfiguration) {
        this.m_checkConfigurations.add(checkConfiguration);
    }

    @JsonProperty(value="teststyleEnabled")
    public boolean isTeststyleEnabled() {
        return this.m_teststyleEnabled;
    }

    public void setTeststyleEnabled(boolean teststyleEnabled) {
        this.m_teststyleEnabled = teststyleEnabled;
    }

    @JsonProperty(value="isReportOnSuccess")
    public boolean isReportOnSuccess() {
        return this.m_isReportOnSuccess;
    }

    public void setReportOnSuccess(boolean isReportOnSuccess) {
        this.m_isReportOnSuccess = isReportOnSuccess;
    }

    @JsonProperty(value="isReportOnFailure")
    public boolean isReportOnFailure() {
        return this.m_isReportOnFailure;
    }

    public void setReportOnFailure(boolean isReportOnFailure) {
        this.m_isReportOnFailure = isReportOnFailure;
    }

    @JsonProperty(value="trackingEnabled")
    public boolean isTrackingEnabled() {
        return this.m_trackingEnabled;
    }

    public void setTrackingEnabled(boolean trackingEnabled) {
        this.m_trackingEnabled = trackingEnabled;
    }

    @JsonProperty(value="almRepositoryName")
    @Deprecated
    public String getAlmRepositoryName() {
        return this.m_almRepositoryName;
    }

    @Deprecated
    public void setAlmRepositoryName(String almRepositoryName) {
    }

    @JsonProperty(value="dashboardURL")
    @Deprecated
    public String getDashboardURL() {
        return this.m_dashboardURL;
    }

    @Deprecated
    public void setDashboardURL(String dashboardURL) {
    }

    @JsonProperty(value="trackingAttribute")
    public String getTrackingAttribute() {
        return this.m_trackingAttribute;
    }

    public void setTrackingAttribute(String trackingAttribute) {
        this.m_trackingAttribute = trackingAttribute;
    }

    @JsonProperty(value="trackingUnit")
    public String getTrackingUnit() {
        return this.m_trackingUnit;
    }

    public void setTrackingUnit(String trackingUnit) {
        this.m_trackingUnit = trackingUnit;
    }

    @JsonProperty(value="markupLanguage")
    public String getMarkupLanguage() {
        return this.m_markupLanguage;
    }

    public void setMarkupLanguage(String markupLanguage) {
        this.m_markupLanguage = markupLanguage;
    }

    @JsonProperty(value="projectVersionQualifier")
    public String getProjectVersionQualifier() {
        return this.m_projectVersionQualifier;
    }

    public void setProjectVersionQualifier(String projectVersionQualifier) {
        this.m_projectVersionQualifier = projectVersionQualifier;
    }

    @JsonProperty(value="autToolKit")
    public String getAutToolKit() {
        return this.m_autToolKit;
    }

    public void setAutToolKit(String autToolKit) {
        this.m_autToolKit = autToolKit;
    }

    @JsonProperty(value="reportingRules")
    public List<ReportingRuleDTO> getReportingRules() {
        return this.m_reportingRules;
    }

    public void addReportingRule(ReportingRuleDTO reportingRule) {
        this.m_reportingRules.add(reportingRule);
    }
}

