/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 1;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private Button m_nodeInsertButton;
    private Button m_nodeAddButton;
    private Button m_showCountersButton;
    private Button m_reminderEnableButton;
    private Spinner m_reminderIntervalSpinner;
    private IPreferenceStore m_store = Plugin.getDefault().getPreferenceStore();

    public EditorPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite);
        this.createShowCountersButton(composite);
        this.createInsertNodeAfterSelectedNodeButton(composite);
        this.createSaveReminderSettings(composite);
        this.updateWidgets();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.editorPrefPageContextId");
        return composite;
    }

    private void createShowCountersButton(Composite composite) {
        this.m_showCountersButton = new Button(composite, 32);
        this.m_showCountersButton.setText(Messages.EditorPreferencePageShowCountersCheckBox);
        this.m_showCountersButton.setSelection(Plugin.getDefault().getPreferenceStore().getBoolean("SHOWCOUNTERS_PREF_KEY"));
    }

    private void createInsertNodeAfterSelectedNodeButton(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.PrefPageBasicNodeInsertionGroup);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)layoutData);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.EditorPreferencePageAddPositionText);
        new Label((Composite)group, 0);
        this.m_nodeAddButton = new Button((Composite)group, 16);
        this.m_nodeAddButton.setText(Messages.PrefPageBasicAddNewNode);
        this.m_nodeAddButton.setSelection(!this.m_store.getBoolean("NODE_INSERT_KEY"));
        this.m_nodeInsertButton = new Button((Composite)group, 16);
        this.m_nodeInsertButton.setText(Messages.PrefPageBasicInsertNewNode);
        this.m_nodeInsertButton.setSelection(this.m_store.getBoolean("NODE_INSERT_KEY"));
    }

    private void createSaveReminderSettings(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.PrefPageBasicSaveReminderGroup);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)layoutData);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.EditorPreferencePageSaveReminderText);
        new Label((Composite)group, 0);
        this.m_reminderEnableButton = new Button((Composite)group, 32);
        this.m_reminderEnableButton.setText(Messages.PrefPageBasicEnableSaveReminder);
        this.m_reminderEnableButton.setSelection(this.m_store.getBoolean("SAVE_REMINDER_ENABLE_KEY"));
        this.m_reminderEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorPreferencePage.this.updateWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite c = new Composite((Composite)group, 0);
        c.setLayout((Layout)new RowLayout());
        Label l1 = new Label(c, 0);
        l1.setText(Messages.PrefPageBasicReminderInterval1);
        this.m_reminderIntervalSpinner = new Spinner(c, 2048);
        this.m_reminderIntervalSpinner.setMinimum(1);
        this.m_reminderIntervalSpinner.setMaximum(60);
        this.m_reminderIntervalSpinner.setSelection(this.m_store.getInt("SAVE_REMINDER_INTERVAL_KEY"));
        this.m_reminderIntervalSpinner.setIncrement(1);
        Label l2 = new Label(c, 0);
        l2.setText(Messages.PrefPageBasicReminderInterval2);
    }

    private void updateWidgets() {
        this.m_reminderIntervalSpinner.setEnabled(this.m_reminderEnableButton.getSelection());
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeData);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.EditorPreferencePageDescription);
    }

    protected void performDefaults() {
        this.m_showCountersButton.setSelection(this.m_store.getDefaultBoolean("SHOWCOUNTERS_PREF_KEY"));
        this.m_nodeInsertButton.setSelection(this.m_store.getDefaultBoolean("NODE_INSERT_KEY"));
        this.m_nodeAddButton.setSelection(!this.m_store.getDefaultBoolean("NODE_INSERT_KEY"));
        this.m_reminderEnableButton.setSelection(this.m_store.getDefaultBoolean("SAVE_REMINDER_ENABLE_KEY"));
        this.m_reminderIntervalSpinner.setSelection(this.m_store.getDefaultInt("SAVE_REMINDER_INTERVAL_KEY"));
        this.updateWidgets();
    }

    public boolean performOk() {
        this.m_store.setValue("SHOWCOUNTERS_PREF_KEY", this.m_showCountersButton.getSelection());
        this.m_store.setValue("NODE_INSERT_KEY", this.m_nodeInsertButton.getSelection());
        this.m_store.setValue("SAVE_REMINDER_ENABLE_KEY", this.m_reminderEnableButton.getSelection());
        this.m_store.setValue("SAVE_REMINDER_INTERVAL_KEY", this.m_reminderIntervalSpinner.getSelection());
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
    }
}

