/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.console.DSPProcess;
import org.eclipse.lsp4e.debug.console.DSPStreamsProxy;
import org.eclipse.lsp4e.debug.debugmodel.DSPBreakpointManager;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.lsp4e.debug.debugmodel.TraceInputStream;
import org.eclipse.lsp4e.debug.debugmodel.TraceOutputStream;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.LoadedSourceEventArguments;
import org.eclipse.lsp4j.debug.ModuleEventArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.ProcessEventArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArgumentsKind;
import org.eclipse.lsp4j.debug.RunInTerminalResponse;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.validation.ReflectiveMessageValidator;

public class DSPDebugTarget
extends DSPDebugElement
implements IDebugTarget,
IDebugProtocolClient {
    private static final boolean TRACE_IO = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.lsp4e.debug/trace/io"));
    private static final boolean TRACE_MESSAGES = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.lsp4e.debug/trace/messages"));
    private ExecutorService threadPool = Executors.newCachedThreadPool();
    private ILaunch launch;
    private Future<?> debugProtocolFuture;
    private IDebugProtocolServer debugProtocolServer;
    private Capabilities capabilities;
    private CompletableFuture<Void> initialized = new CompletableFuture();
    private Map<Integer, DSPThread> threads = Collections.synchronizedMap(new TreeMap());
    private AtomicBoolean refreshThreads = new AtomicBoolean(true);
    private boolean fTerminated = false;
    private boolean fSentTerminateRequest = false;
    private String targetName = null;
    private Runnable processCleanup;
    private DSPBreakpointManager breakpointManager;
    private DSPProcess process;
    private InputStream in;
    private OutputStream out;
    private Map<String, Object> dspParameters;

    public DSPDebugTarget(ILaunch launch, Runnable processCleanup, InputStream in, OutputStream out, Map<String, Object> dspParameters) {
        super(null);
        this.in = in;
        this.out = out;
        this.launch = launch;
        this.processCleanup = processCleanup;
        this.dspParameters = dspParameters;
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                PrintWriter traceMessages = TRACE_MESSAGES ? new PrintWriter(System.out) : null;
                if (TRACE_IO) {
                    this.in = new TraceInputStream(this.in, System.out);
                    this.out = new TraceOutputStream(this.out, System.out);
                }
                UnaryOperator wrapper = consumer -> {
                    MessageConsumer result = consumer;
                    if (traceMessages != null) {
                        result = message -> {
                            traceMessages.println(message);
                            traceMessages.flush();
                            consumer.consume(message);
                        };
                    }
                    result = new ReflectiveMessageValidator(result);
                    return result;
                };
                InputStream in2 = this.in;
                OutputStream out2 = this.out;
                ExecutorService threadPool2 = this.threadPool;
                Launcher<? extends IDebugProtocolServer> debugProtocolLauncher = this.createLauncher(wrapper, in2, out2, threadPool2);
                this.debugProtocolFuture = debugProtocolLauncher.startListening();
                this.debugProtocolServer = (IDebugProtocolServer)debugProtocolLauncher.getRemoteProxy();
                CompletableFuture<Void> future = this.initialize(this.dspParameters, (IProgressMonitor)subMonitor);
                DSPDebugTarget.monitorGet(future, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                this.terminated();
                throw e;
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected Launcher<? extends IDebugProtocolServer> createLauncher(UnaryOperator<MessageConsumer> wrapper, InputStream in, OutputStream out, ExecutorService threadPool) {
        Launcher debugProtocolLauncher = DSPLauncher.createClientLauncher((IDebugProtocolClient)this, (InputStream)in, (OutputStream)out, (ExecutorService)threadPool, wrapper);
        return debugProtocolLauncher;
    }

    private CompletableFuture<Void> initialize(Map<String, Object> dspParameters, IProgressMonitor monitor) {
        InitializeRequestArguments arguments = new InitializeRequestArguments();
        arguments.setClientID("lsp4e.debug");
        String adapterId = "adapterId";
        if (dspParameters.containsKey("type") && dspParameters.get("type") instanceof String) {
            adapterId = (String)dspParameters.get("type");
        }
        arguments.setAdapterID(adapterId);
        arguments.setPathFormat("path");
        arguments.setSupportsVariableType(Boolean.valueOf(true));
        arguments.setSupportsVariablePaging(Boolean.valueOf(true));
        arguments.setLinesStartAt1(Boolean.valueOf(true));
        arguments.setColumnsStartAt1(Boolean.valueOf(true));
        arguments.setSupportsRunInTerminalRequest(Boolean.valueOf(true));
        this.targetName = Objects.toString(dspParameters.get("program"), "Debug Adapter Target");
        monitor.subTask("Initializing connection to debug adapter");
        boolean isLaunchRequest = "launch".equals(dspParameters.getOrDefault("request", "launch"));
        CompletionStage future = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getDebugProtocolServer().initialize(arguments).thenAccept(capabilities -> {
            monitor.worked(10);
            this.capabilities = capabilities;
        })).thenRun(() -> {
            this.process = new DSPProcess(this);
            if (isLaunchRequest) {
                this.launch.addProcess((IProcess)this.process);
            }
        })).thenCompose(v -> {
            monitor.worked(10);
            if (isLaunchRequest) {
                monitor.subTask("Launching program");
                return this.getDebugProtocolServer().launch(dspParameters);
            }
            monitor.subTask("Attaching to running program");
            return this.getDebugProtocolServer().attach(dspParameters);
        })).handle((q, t) -> {
            if (t != null) {
                this.initialized.completeExceptionally((Throwable)t);
            }
            return q;
        })).thenCombineAsync(this.initialized, (v1, v2) -> {
            monitor.worked(10);
            return null;
        })).thenCompose(v -> {
            monitor.worked(10);
            monitor.subTask("Sending breakpoints");
            this.breakpointManager = new DSPBreakpointManager(this.getBreakpointManager(), this.getDebugProtocolServer(), this.capabilities);
            return this.breakpointManager.initialize();
        })).thenCompose(v -> {
            monitor.worked(30);
            monitor.subTask("Sending configuration done");
            if (Boolean.TRUE.equals(this.capabilities.getSupportsConfigurationDoneRequest())) {
                return this.getDebugProtocolServer().configurationDone(new ConfigurationDoneArguments());
            }
            return CompletableFuture.completedFuture(null);
        });
        return future;
    }

    private void terminated() {
        this.fTerminated = true;
        this.fireTerminateEvent();
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.process, 8)});
        if (this.breakpointManager != null) {
            this.breakpointManager.shutdown();
        }
        this.debugProtocolFuture.cancel(true);
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processCleanup.run();
    }

    public void initialized() {
        this.initialized.complete(null);
    }

    protected void requestFailed(String message, Throwable e) throws DebugException {
        throw DSPDebugTarget.newTargetRequestFailedException(message, e);
    }

    @Override
    public DSPDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminated(TerminatedEventArguments body) {
        this.terminated();
    }

    public void terminate() throws DebugException {
        boolean shouldSendTerminateRequest;
        boolean bl = shouldSendTerminateRequest = !this.fSentTerminateRequest && Boolean.TRUE.equals(this.getCapabilities().getSupportsTerminateRequest()) && "launch".equals(this.dspParameters.getOrDefault("request", "launch"));
        if (shouldSendTerminateRequest) {
            this.fSentTerminateRequest = true;
            this.getDebugProtocolServer().terminate(new TerminateArguments());
        } else {
            DisconnectArguments arguments = new DisconnectArguments();
            arguments.setTerminateDebuggee(Boolean.valueOf(true));
            this.getDebugProtocolServer().disconnect(arguments).thenRun(this::terminated);
        }
    }

    public void continued(ContinuedEventArguments body) {
        this.threadPool.execute(() -> {
            DSPThread source = null;
            source = this.getThread(body.getThreadId());
            if (source == null || body.getAllThreadsContinued() == null || body.getAllThreadsContinued().booleanValue()) {
                Arrays.asList(this.getThreads()).forEach(DSPThread::continued);
            }
            if (source != null) {
                source.fireResumeEvent(32);
            }
        });
    }

    public void stopped(StoppedEventArguments body) {
        this.threadPool.execute(() -> {
            DSPThread source = null;
            if (body.getThreadId() != null) {
                source = this.getThread(body.getThreadId());
            }
            if (source == null || body.getAllThreadsStopped() == null || body.getAllThreadsStopped().booleanValue()) {
                Arrays.asList(this.getThreads()).forEach(t -> {
                    t.stopped();
                    t.fireChangeEvent(16);
                });
            }
            if (source != null) {
                source.stopped();
                source.fireSuspendEvent(this.calcDetail(body.getReason()));
            }
        });
    }

    private int calcDetail(String reason) {
        if (reason.equals("breakpoint") || reason.equals("entry") || reason.equals("exception")) {
            return 16;
        }
        if (reason.equals("step")) {
            return 2;
        }
        if (reason.equals("pause")) {
            return 32;
        }
        return 0;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended() && this.getThreads().length > 0;
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended() && this.getThreads().length > 0;
    }

    public boolean isSuspended() {
        DSPThread[] dspThreads = this.getThreads();
        boolean anyMatch = Arrays.asList(dspThreads).stream().anyMatch(DSPThread::isSuspended);
        return anyMatch;
    }

    public void resume() throws DebugException {
        DSPThread[] dspThreads = this.getThreads();
        if (dspThreads.length > 0) {
            dspThreads[0].resume();
        }
    }

    public void suspend() throws DebugException {
        DSPThread[] dspThreads = this.getThreads();
        if (dspThreads.length > 0) {
            dspThreads[0].suspend();
        }
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.getDebugProtocolServer().disconnect(new DisconnectArguments()).thenRun(this::terminated);
    }

    public boolean isDisconnected() {
        return this.fTerminated;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSPThread[] getThreads() {
        if (!this.refreshThreads.getAndSet(false)) {
            Map<Integer, DSPThread> map = this.threads;
            synchronized (map) {
                Collection<DSPThread> values = this.threads.values();
                return values.toArray(new DSPThread[values.size()]);
            }
        }
        try {
            CompletableFuture threads2 = this.getDebugProtocolServer().threads();
            CompletionStage future = threads2.thenApplyAsync(threadsResponse -> {
                Map<Integer, DSPThread> map = this.threads;
                synchronized (map) {
                    org.eclipse.lsp4j.debug.Thread[] body;
                    TreeMap<Integer, DSPThread> lastThreads = new TreeMap<Integer, DSPThread>(this.threads);
                    this.threads.clear();
                    org.eclipse.lsp4j.debug.Thread[] threadArray = body = threadsResponse.getThreads();
                    int n = body.length;
                    int n2 = 0;
                    while (n2 < n) {
                        org.eclipse.lsp4j.debug.Thread thread = threadArray[n2];
                        DSPThread dspThread = (DSPThread)((Object)((Object)lastThreads.get(thread.getId())));
                        if (dspThread == null) {
                            dspThread = new DSPThread(this, thread.getId());
                        }
                        dspThread.update(thread);
                        this.threads.put(thread.getId(), dspThread);
                        ++n2;
                    }
                    Collection<DSPThread> values = this.threads.values();
                    return values.toArray(new DSPThread[values.size()]);
                }
            });
            return (DSPThread[])((CompletableFuture)future).get();
        }
        catch (RuntimeException | ExecutionException e) {
            if (this.isTerminated()) {
                return new DSPThread[0];
            }
            DSPPlugin.logError(e);
            return new DSPThread[0];
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new DSPThread[0];
        }
    }

    private DSPThread getThread(Integer threadId) {
        return this.threads.computeIfAbsent(threadId, id -> new DSPThread(this, threadId));
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length > 0;
    }

    public String getName() {
        return this.targetName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return !this.isTerminated() && this.breakpointManager.supportsBreakpoint(breakpoint);
    }

    public void exited(ExitedEventArguments args) {
    }

    public void thread(ThreadEventArguments args) {
        this.refreshThreads.set(true);
        this.fireChangeEvent(512);
    }

    public void output(OutputEventArguments args) {
        boolean outputted = false;
        if (this.process != null) {
            DSPStreamsProxy dspStreamsProxy = this.process.getStreamsProxy();
            String output = args.getOutput();
            if (args.getCategory() == null || "console".equals(args.getCategory()) || "stdout".equals(args.getCategory())) {
                dspStreamsProxy.getOutputStreamMonitor().append(output);
                outputted = true;
            } else if ("stderr".equals(args.getCategory())) {
                dspStreamsProxy.getErrorStreamMonitor().append(output);
                outputted = true;
            }
        }
        if (!outputted && DSPPlugin.DEBUG) {
            System.out.println("output: " + args);
        }
    }

    public void module(ModuleEventArguments args) {
    }

    public void loadedSource(LoadedSourceEventArguments args) {
    }

    public void process(ProcessEventArguments args) {
    }

    @JsonRequest
    public CompletableFuture<RunInTerminalResponse> runInTerminal(RunInTerminalRequestArguments args) {
        RunInTerminalRequestArgumentsKind.EXTERNAL.equals((Object)args.getKind());
        StringBuilder cmd = new StringBuilder();
        String[] stringArray = args.getArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.contains(" ")) {
                cmd.append("\"");
                cmd.append(arg);
                cmd.append("\"");
            } else {
                cmd.append(arg);
            }
            cmd.append(" ");
            ++n2;
        }
        if (cmd.length() > 0) {
            cmd.setLength(cmd.length() - 1);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(args.getArgs());
        if (args.getCwd() != null) {
            processBuilder.directory(new File(args.getCwd()));
        }
        if (args.getEnv() != null) {
            Set entrySet = args.getEnv().entrySet();
            for (Map.Entry entry : entrySet) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) {
                    processBuilder.environment().remove(name);
                    continue;
                }
                processBuilder.environment().put(name, value);
            }
        }
        try {
            if (DSPPlugin.DEBUG) {
                System.out.println("Launching: " + cmd);
            }
            Process start = processBuilder.start();
            DebugPlugin.newProcess((ILaunch)this.launch, (Process)start, (String)cmd.toString());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            RunInTerminalResponse runInTerminalResponse = new RunInTerminalResponse();
            runInTerminalResponse.setProcessId(null);
            return CompletableFuture.completedFuture(runInTerminalResponse);
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public void breakpoint(BreakpointEventArguments args) {
        this.breakpointManager.breakpointEvent(args);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.breakpointManager.breakpointAdded(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointRemoved(breakpoint, delta);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointManager.breakpointChanged(breakpoint, delta);
    }

    @Override
    public IDebugProtocolServer getDebugProtocolServer() {
        return this.debugProtocolServer;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }
}

