/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IContainerEventVisitor;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class ContainerEventAdapter<E>
implements IListener {
    private boolean waitForActive;

    public ContainerEventAdapter(boolean waitForActive) {
        this.waitForActive = waitForActive;
    }

    public ContainerEventAdapter() {
        this(false);
    }

    public boolean isWaitForActive() {
        return this.waitForActive;
    }

    @Override
    public final void notifyEvent(IEvent event) {
        if (event instanceof IContainerEvent) {
            IContainerEvent e = (IContainerEvent)event;
            this.notifyContainerEvent(e);
        } else {
            this.notifyOtherEvent(event);
        }
    }

    protected void notifyContainerEvent(IContainerEvent<E> event) {
        INotifier container = event.getSource();
        event.accept(new IContainerEventVisitor<E>((IContainer)container){
            private final /* synthetic */ IContainer val$container;
            {
                this.val$container = iContainer;
            }

            @Override
            public void added(final E element) {
                if (ContainerEventAdapter.this.waitForActive && !LifecycleUtil.isActive(element)) {
                    EventUtil.addListener(element, new LifecycleEventAdapter(){

                        @Override
                        protected void onActivated(ILifecycle lifecycle) {
                            ContainerEventAdapter.this.onAdded(val$container, element);
                            lifecycle.removeListener(this);
                        }
                    });
                } else {
                    ContainerEventAdapter.this.onAdded(this.val$container, element);
                }
            }

            @Override
            public void removed(E element) {
                ContainerEventAdapter.this.onRemoved(this.val$container, element);
            }
        });
    }

    protected void notifyOtherEvent(IEvent event) {
    }

    protected void onAdded(IContainer<E> container, E element) {
    }

    protected void onRemoved(IContainer<E> container, E element) {
    }
}

