/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.tcf.core.scripting.launcher.ScriptLauncher;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.ui.views.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.views.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.ScriptPad;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class PlayAction
extends Action
implements IViewActionDelegate,
IActionDelegate2 {
    IAction actionProxy;
    IViewPart view;
    private IPropertyListener listener;
    boolean running;

    public void init(IViewPart view) {
        this.view = view;
        if (this.listener == null) {
            this.listener = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (258 == propId && PlayAction.this.actionProxy != null) {
                        boolean enabled = false;
                        if (PlayAction.this.view instanceof ScriptPad) {
                            enabled = ((ScriptPad)PlayAction.this.view).getPeerModel() != null;
                        }
                        PlayAction.this.actionProxy.setEnabled(enabled && !PlayAction.this.running);
                    }
                }
            };
            view.addPropertyListener(this.listener);
        }
    }

    public void init(IAction action) {
        this.actionProxy = action;
        if (action != null) {
            boolean enabled = false;
            if (this.view instanceof ScriptPad) {
                enabled = ((ScriptPad)this.view).getPeerModel() != null;
            }
            action.setEnabled(enabled && !this.running);
        }
    }

    public void run() {
        String script = null;
        IPeerNode peerNode = null;
        if (this.view instanceof ScriptPad && ((ScriptPad)this.view).getStyledText() != null) {
            script = ((ScriptPad)this.view).getStyledText().getText();
            peerNode = ((ScriptPad)this.view).getPeerModel();
        }
        if (script != null && !"".equals(script) && peerNode != null) {
            final ScriptLauncher launcher = new ScriptLauncher();
            PropertiesContainer properties = new PropertiesContainer();
            properties.setProperty("script.script", (Object)script);
            final AtomicReference peer = new AtomicReference();
            final IPeerNode finPeerModel = peerNode;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    peer.set(finPeerModel.getPeer());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            this.running = true;
            launcher.launch((IPeer)peer.get(), (IPropertiesContainer)properties, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    PlayAction.this.running = false;
                    launcher.dispose();
                    boolean enabled = false;
                    if (PlayAction.this.view instanceof ScriptPad) {
                        enabled = ((ScriptPad)PlayAction.this.view).getPeerModel() != null;
                    }
                    PlayAction.this.actionProxy.setEnabled(enabled && !PlayAction.this.running);
                    if (status != null && (status.getSeverity() == 4 || status.getSeverity() == 2)) {
                        StatusHandlerUtil.handleStatus((IStatus)status, (Object)PlayAction.this.view, null, (String)Messages.ScriptPad_error_title, (String)IContextHelpIds.SCRIPT_PAD_ERROR_PLAY_FAILED, (Object)((Object)this), null);
                    }
                }
            });
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        if (this.listener != null) {
            this.view.removePropertyListener(this.listener);
        }
    }
}

