/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import java.util.regex.Matcher;
import org.eclipse.tm4e.markdown.marked.HTMLRenderer;
import org.eclipse.tm4e.markdown.marked.Helpers;
import org.eclipse.tm4e.markdown.marked.IRenderer;
import org.eclipse.tm4e.markdown.marked.InlineRules;
import org.eclipse.tm4e.markdown.marked.Options;

public class InlineLexer {
    private Options options;
    private InlineRules rules;
    private final IRenderer renderer;

    public InlineLexer(Object links, Options options, IRenderer renderer) {
        this.options = options != null ? options : Options.DEFAULTS;
        this.rules = InlineRules.normal;
        IRenderer iRenderer = this.renderer = renderer != null ? renderer : new HTMLRenderer();
        if (this.options.isGfm()) {
            this.rules = this.options.isBreaks() ? InlineRules.breaks : InlineRules.gfm;
        } else if (this.options.isPedantic()) {
            this.rules = InlineRules.pedantic;
        }
    }

    public void output(String src) {
        Matcher cap = null;
        while (!Helpers.isEmpty(src)) {
            cap = this.rules.strong.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.renderer.startStrong();
                this.output(!Helpers.isEmpty(cap.group(2)) ? cap.group(2) : cap.group(1));
                this.renderer.endStrong();
                continue;
            }
            cap = this.rules.em.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.renderer.startEm();
                this.output(!Helpers.isEmpty(cap.group(2)) ? cap.group(2) : cap.group(1));
                this.renderer.endEm();
                continue;
            }
            cap = this.rules.code.exec(src);
            if (cap != null) {
                src = src.substring(cap.group(0).length());
                this.renderer.codespan(Helpers.escape(cap.group(2), true));
                continue;
            }
            cap = this.rules.text.exec(src);
            if (cap == null) continue;
            src = src.substring(cap.group(0).length());
            this.renderer.text(Helpers.escape(this.smartypants(cap.group(0))));
        }
    }

    private String smartypants(String text) {
        return text;
    }
}

