/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class JSFileTaskScanner
implements IFileTaskScanner {
    private static final String MARKER_TYPE_TASK = "org.eclipse.wst.jsdt.core.task";

    public String getMarkerType() {
        return MARKER_TYPE_TASK;
    }

    protected Map<String, Object> createInitialMarkerAttributes(String text, int documentLine, int startOffset, int length, int priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(6);
        attributes.put("lineNumber", documentLine + 1);
        attributes.put("org.eclipse.core.resources.taskmarker", this.getMarkerType());
        attributes.put("charStart", startOffset);
        attributes.put("charEnd", startOffset + length);
        attributes.put("message", text);
        attributes.put("userEditable", Boolean.FALSE);
        switch (priority) {
            case 2: {
                attributes.put("priority", new Integer(2));
                break;
            }
            case 0: {
                attributes.put("priority", new Integer(0));
                break;
            }
            default: {
                attributes.put("priority", new Integer(1));
            }
        }
        return attributes;
    }

    public Map<String, Object>[] scan(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        ArrayList<Map<String, Object>> newMarkers;
        block30: {
            newMarkers = new ArrayList<Map<String, Object>>();
            ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            try {
                textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
                IDocument document = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).getDocument();
                IDocumentPartitioner partitioner = JavaScriptPlugin.getDefault().getJavaTextTools().createDocumentPartitioner();
                FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
                partitioner.connect(document);
                ITypedRegion[] partitions = partitioner.computePartitioning(0, document.getLength());
                SubMonitor partitionMonitor = localMonitor.newChild(1);
                partitionMonitor.beginTask("", partitions.length);
                int i = 0;
                while (i < partitions.length) {
                    int j = 0;
                    while (j < taskTags.length) {
                        switch (partitions[i].getType()) {
                            case "__java_singleline_comment": {
                                IRegion lineMatch = finder.find(partitions[i].getOffset(), taskTags[j].getTag(), true, false, true, false);
                                if (lineMatch == null) break;
                                IRegion lineInfo = document.getLineInformationOfOffset(lineMatch.getOffset());
                                int start = lineMatch.getOffset();
                                int lengthToEndOfLine = lineInfo.getLength() - (lineMatch.getOffset() - lineInfo.getOffset());
                                String text = document.get(start, lengthToEndOfLine).trim();
                                Map<String, Object> attributesForNewTaskMarker = this.createInitialMarkerAttributes(text, document.getLineOfOffset(lineMatch.getOffset()), start, text.length(), taskTags[j].getPriority());
                                newMarkers.add(attributesForNewTaskMarker);
                                break;
                            }
                            case "__java_javadoc": 
                            case "__java_multiline_comment": {
                                String text;
                                int lengthToEndOfLine;
                                IRegion tagMatch = finder.find(partitions[i].getOffset(), taskTags[j].getTag(), true, false, true, false);
                                while (tagMatch != null && tagMatch.getOffset() + tagMatch.getLength() < partitions[i].getOffset() + partitions[i].getLength()) {
                                    int start = tagMatch.getOffset();
                                    IRegion lineInfo = document.getLineInformationOfOffset(tagMatch.getOffset());
                                    lengthToEndOfLine = lineInfo.getLength() - (tagMatch.getOffset() - lineInfo.getOffset());
                                    lengthToEndOfLine = Math.min(lengthToEndOfLine, partitions[i].getOffset() + partitions[i].getLength() - 2 - start);
                                    text = document.get(start, lengthToEndOfLine).trim();
                                    int lineNumber = document.getLineOfOffset(tagMatch.getOffset());
                                    Map<String, Object> attributesForNewTaskMarker = this.createInitialMarkerAttributes(text, lineNumber, start, text.length(), taskTags[j].getPriority());
                                    newMarkers.add(attributesForNewTaskMarker);
                                    tagMatch = finder.find(lineInfo.getOffset() + lineInfo.getLength(), taskTags[j].getTag(), true, false, true, false);
                                }
                                break;
                            }
                        }
                        ++j;
                    }
                    partitionMonitor.worked(1);
                    ++i;
                }
                partitioner.disconnect();
            }
            catch (CoreException e) {
                Logger.logException(e);
                try {
                    textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
                }
                catch (CoreException e2) {
                    Logger.logException("Exception while disconnecting file buffer", e2);
                }
                localMonitor.done();
                break block30;
            }
            catch (BadLocationException e) {
                try {
                    Logger.logException(e);
                    break block30;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
                    }
                    catch (CoreException e3) {
                        Logger.logException("Exception while disconnecting file buffer", e3);
                    }
                    localMonitor.done();
                }
            }
            try {
                textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
            }
            catch (CoreException e) {
                Logger.logException("Exception while disconnecting file buffer", e);
            }
            localMonitor.done();
        }
        return newMarkers.toArray(new Map[newMarkers.size()]);
    }

    public void shutdown(IProject project) {
    }

    public void startup(IProject project) {
    }
}

