/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.EventObject;
import java.util.ResourceBundle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.impl.CopyCommand;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramDiffAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DecoratorsManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.TreeContentMergeViewerContentProvider;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PlatformUI;

public class DiagramContentMergeViewer
extends EMFCompareContentMergeViewer
implements ZoomListener {
    private static final String BUNDLE_NAME = DiagramContentMergeViewer.class.getName();
    private DecoratorsManager fDecoratorsManager;
    private Diff fCurrentSelectedDiff;
    private boolean isSynchronizingZoom;
    private ZoomComboContributionItem zoomItem;

    public DiagramContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TreeContentMergeViewerContentProvider(config));
    }

    public DecoratorsManager getDecoratorsManager() {
        return this.fDecoratorsManager;
    }

    public DiagramMergeViewer getAncestorMergeViewer() {
        return (DiagramMergeViewer)super.getAncestorMergeViewer();
    }

    public DiagramMergeViewer getLeftMergeViewer() {
        return (DiagramMergeViewer)super.getLeftMergeViewer();
    }

    public DiagramMergeViewer getRightMergeViewer() {
        return (DiagramMergeViewer)super.getRightMergeViewer();
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected IMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        DiagramMergeViewer diagramMergeViewer = new DiagramMergeViewer(parent, side, (IEMFCompareConfiguration)this.getCompareConfiguration());
        return diagramMergeViewer;
    }

    protected void paintCenter(GC g) {
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fDecoratorsManager = new DecoratorsManager(this.getCompareConfiguration(), this.getLeftMergeViewer(), this.getRightMergeViewer(), this.getAncestorMergeViewer(), this.getCompareColor());
        this.fDecoratorsManager.hideAll();
        this.fDecoratorsManager.removeAll();
        super.updateContent(ancestor, left, right);
        this.getLeftMergeViewer().getGraphicalViewer().flush();
        this.getRightMergeViewer().getGraphicalViewer().flush();
        this.getAncestorMergeViewer().getGraphicalViewer().flush();
        if (left instanceof IDiagramNodeAccessor) {
            if (left instanceof IDiagramDiffAccessor) {
                IDiagramDiffAccessor input = (IDiagramDiffAccessor)left;
                DiagramDiff diff = input.getDiff();
                if (!AbstractMerger.isInTerminalState((Diff)diff) && diff != this.fCurrentSelectedDiff) {
                    this.fDecoratorsManager.revealDecorators((Diff)diff);
                }
                this.fCurrentSelectedDiff = diff;
            } else {
                this.fCurrentSelectedDiff = null;
            }
        }
        this.updateToolItems();
        if (left != null && right != null) {
            this.addZoomListener(this.getAncestorMergeViewer(), this);
            this.addZoomListener(this.getLeftMergeViewer(), this);
            this.addZoomListener(this.getRightMergeViewer(), this);
        }
        if (left != null && this.zoomItem != null) {
            this.zoomItem.setZoomManager(this.getZoomManager(this.getLeftMergeViewer()));
        }
    }

    private void addZoomListener(DiagramMergeViewer viewer, ZoomListener zoomListener) {
        ZoomManager zoomManager = this.getZoomManager(viewer);
        if (zoomManager != null) {
            zoomManager.addZoomListener(zoomListener);
        }
    }

    private void setZoom(DiagramMergeViewer viewer, double zoom) {
        ZoomManager zoomManager = this.getZoomManager(viewer);
        if (zoomManager != null) {
            zoomManager.setZoom(zoom);
        }
    }

    private ZoomManager getZoomManager(DiagramMergeViewer viewer) {
        RootEditPart rootEditPart = viewer.getGraphicalViewer().getRootEditPart();
        if (rootEditPart instanceof DiagramRootEditPart) {
            return ((DiagramRootEditPart)rootEditPart).getZoomManager();
        }
        return null;
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        IPartService partService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
        this.zoomItem = new ZoomComboContributionItem(partService);
        toolBarManager.insert(0, (IContributionItem)this.zoomItem);
    }

    public void zoomChanged(double zoom) {
        if (this.isSynchronizingZoom) {
            return;
        }
        this.isSynchronizingZoom = true;
        try {
            this.setZoom(this.getAncestorMergeViewer(), zoom);
            this.setZoom(this.getLeftMergeViewer(), zoom);
            this.setZoom(this.getRightMergeViewer(), zoom);
        }
        finally {
            this.isSynchronizingZoom = false;
        }
    }

    public void commandStackChanged(EventObject event) {
        UnmodifiableIterator diffs;
        Command command;
        super.commandStackChanged(event);
        Object source = event.getSource();
        if (source instanceof CommandStack && this.fDecoratorsManager != null && (command = ((CommandStack)source).getMostRecentCommand()) instanceof CopyCommand && (diffs = Iterators.filter(command.getAffectedObjects().iterator(), DiagramDiff.class)).hasNext()) {
            this.fDecoratorsManager.hideAll();
            this.fDecoratorsManager.removeAll();
        }
    }

    protected Diff getDiffFrom(IMergeViewer viewer) {
        return this.fCurrentSelectedDiff;
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        this.getAncestorMergeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getLeftMergeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getRightMergeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }
}

