/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.emf.compare.egit.internal.merge.GitCachedResourceVariantTree;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantCache;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.storage.TreeParserResourceVariant;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.variants.IResourceVariantTree;

public class TreeWalkResourceVariantTreeProvider
implements GitResourceVariantTreeProvider {
    private final IResourceVariantTree baseTree;
    private final IResourceVariantTree oursTree;
    private final IResourceVariantTree theirsTree;
    private final Set<IResource> roots;
    private final Set<IResource> knownResources;
    private final LinkedHashMap<IPath, IProject> map;

    private TreeWalkResourceVariantTreeProvider(Builder builder) {
        this.map = builder.map;
        this.baseTree = builder.baseTree;
        this.theirsTree = builder.theirsTree;
        this.oursTree = builder.oursTree;
        this.roots = builder.roots;
        this.knownResources = builder.knownResources;
    }

    @Override
    public IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    @Override
    public IResourceVariantTree getRemoteTree() {
        return this.theirsTree;
    }

    @Override
    public IResourceVariantTree getSourceTree() {
        return this.oursTree;
    }

    @Override
    public Set<IResource> getKnownResources() {
        return this.knownResources;
    }

    @Override
    public Set<IResource> getRoots() {
        return this.roots;
    }

    public IResource getResourceHandleForLocation(Repository repository, String repoRelativePath, boolean isFolder) {
        return TreeWalkResourceVariantTreeProvider.getResourceHandleForLocation(repository, repoRelativePath, isFolder, this.map);
    }

    private static IResource getResourceHandleForLocation(Repository repository, String repoRelativePath, boolean isFolder, LinkedHashMap<IPath, IProject> map) {
        Object resource = null;
        String workDir = repository.getWorkTree().getAbsolutePath();
        Path path = new Path(String.valueOf(workDir) + '/' + repoRelativePath);
        File file = path.toFile();
        if (file.exists()) {
            resource = isFolder ? ResourceUtil.getContainerForLocation((IPath)path, (boolean)false) : ResourceUtil.getFileForLocation((IPath)path, (boolean)false);
        }
        if (repoRelativePath.endsWith(".project")) {
            IPath parentPath = path.removeLastSegments(1);
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(parentPath.lastSegment().toString());
            if (map.get(parentPath) == null) {
                map.put(parentPath, p);
            }
        }
        if (resource == null) {
            ArrayList<IPath> list = new ArrayList<IPath>(map.keySet());
            int i = list.size() - 1;
            while (i >= 0) {
                IPath projectPath = (IPath)list.get(i);
                if (projectPath.isPrefixOf((IPath)path) && !projectPath.equals((Object)path)) {
                    IPath projectRelativePath = path.makeRelativeTo(projectPath);
                    if (isFolder) {
                        resource = map.get(projectPath).getFolder(projectRelativePath);
                        break;
                    }
                    resource = map.get(projectPath).getFile(projectRelativePath);
                    break;
                }
                --i;
            }
        }
        if (resource == null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath projectLocation;
                IProject project = iProjectArray[n2];
                if (RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.egit.core.GitProvider") != null && (projectLocation = project.getLocation()) != null && projectLocation.isPrefixOf((IPath)path)) {
                    IPath projectRelativePath = path.makeRelativeTo(projectLocation);
                    if (isFolder) {
                        resource = project.getFolder(projectRelativePath);
                        break;
                    }
                    resource = project.getFile(projectRelativePath);
                    break;
                }
                ++n2;
            }
        }
        return resource;
    }

    /* synthetic */ TreeWalkResourceVariantTreeProvider(Builder builder, TreeWalkResourceVariantTreeProvider treeWalkResourceVariantTreeProvider) {
        this(builder);
    }

    public static class Builder {
        private Repository repository;
        private AbstractTreeIterator aBaseTree;
        private RevTree headTree;
        private RevTree mergeTree;
        private DirCache dircache;
        private ObjectReader reader;
        private IResourceVariantTree baseTree;
        private IResourceVariantTree oursTree;
        private IResourceVariantTree theirsTree;
        private Set<IResource> roots;
        private Set<IResource> knownResources;
        private GitResourceVariantCache baseCache;
        private GitResourceVariantCache theirsCache;
        private GitResourceVariantCache oursCache;
        private LinkedHashMap<IPath, IProject> map;

        public Builder setRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder setaBaseTree(AbstractTreeIterator aBaseTree) {
            this.aBaseTree = aBaseTree;
            return this;
        }

        public Builder setHeadTree(RevTree headTree) {
            this.headTree = headTree;
            return this;
        }

        public Builder setMergeTree(RevTree mergeTree) {
            this.mergeTree = mergeTree;
            return this;
        }

        public Builder setDircache(DirCache dircache) {
            this.dircache = dircache;
            return this;
        }

        public Builder setReader(ObjectReader reader) {
            this.reader = reader;
            return this;
        }

        public TreeWalkResourceVariantTreeProvider build() throws IOException {
            DirCacheBuilder aBuilder = this.dircache.builder();
            DirCacheBuildIterator buildIt = new DirCacheBuildIterator(aBuilder);
            this.map = new LinkedHashMap();
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (NameConflictTreeWalk treeWalk = new NameConflictTreeWalk(this.repository, this.reader);){
                    int baseIndex = treeWalk.addTree(this.aBaseTree);
                    int ourIndex = treeWalk.addTree((AnyObjectId)this.headTree);
                    int theirIndex = treeWalk.addTree((AnyObjectId)this.mergeTree);
                    int dciPos = treeWalk.addTree((AbstractTreeIterator)buildIt);
                    FileTreeIterator aWorkingTreeIterator = new FileTreeIterator(this.repository);
                    treeWalk.addTree((AbstractTreeIterator)aWorkingTreeIterator);
                    aWorkingTreeIterator.setDirCacheIterator((TreeWalk)treeWalk, dciPos);
                    this.baseCache = new GitResourceVariantCache();
                    this.theirsCache = new GitResourceVariantCache();
                    this.oursCache = new GitResourceVariantCache();
                    while (treeWalk.next()) {
                        int modeTheirs;
                        int modeOurs;
                        int modeBase = treeWalk.getRawMode(baseIndex);
                        if (!this.hasSignificantDifference(modeBase, modeOurs = treeWalk.getRawMode(ourIndex), modeTheirs = treeWalk.getRawMode(theirIndex))) continue;
                        CanonicalTreeParser base = (CanonicalTreeParser)treeWalk.getTree(baseIndex, CanonicalTreeParser.class);
                        CanonicalTreeParser ours = (CanonicalTreeParser)treeWalk.getTree(ourIndex, CanonicalTreeParser.class);
                        CanonicalTreeParser theirs = (CanonicalTreeParser)treeWalk.getTree(theirIndex, CanonicalTreeParser.class);
                        int nonZeroMode = modeBase != 0 ? modeBase : (modeOurs != 0 ? modeOurs : modeTheirs);
                        IResource resource = TreeWalkResourceVariantTreeProvider.getResourceHandleForLocation(this.repository, treeWalk.getPathString(), FileMode.fromBits((int)nonZeroMode) == FileMode.TREE, this.map);
                        if (resource != null) {
                            IPath workspacePath = resource.getFullPath();
                            if (modeBase != 0) {
                                this.baseCache.setVariant(resource, TreeParserResourceVariant.create(this.repository, base, workspacePath));
                            }
                            if (modeOurs != 0) {
                                this.oursCache.setVariant(resource, TreeParserResourceVariant.create(this.repository, ours, workspacePath));
                            }
                            if (modeTheirs != 0) {
                                this.theirsCache.setVariant(resource, TreeParserResourceVariant.create(this.repository, theirs, workspacePath));
                            }
                        }
                        if (!treeWalk.isSubtree()) continue;
                        treeWalk.enterSubtree();
                    }
                    this.baseTree = new GitCachedResourceVariantTree(this.baseCache);
                    this.theirsTree = new GitCachedResourceVariantTree(this.theirsCache);
                    this.oursTree = new GitCachedResourceVariantTree(this.oursCache);
                    this.roots = new LinkedHashSet<IResource>();
                    this.roots.addAll(this.baseCache.getRoots());
                    this.roots.addAll(this.oursCache.getRoots());
                    this.roots.addAll(this.theirsCache.getRoots());
                    this.knownResources = new LinkedHashSet<IResource>();
                    this.knownResources.addAll(this.baseCache.getKnownResources());
                    this.knownResources.addAll(this.oursCache.getKnownResources());
                    this.knownResources.addAll(this.theirsCache.getKnownResources());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.aBaseTree.reset();
            }
            return new TreeWalkResourceVariantTreeProvider(this, null);
        }

        private boolean hasSignificantDifference(int modeBase, int modeOurs, int modeTheirs) {
            if (modeBase == 0) {
                if (FileMode.fromBits((int)(modeOurs | modeTheirs)) != FileMode.MISSING) {
                    return true;
                }
                return FileMode.fromBits((int)modeOurs) == FileMode.TREE && FileMode.fromBits((int)modeTheirs) != FileMode.TREE || FileMode.fromBits((int)modeOurs) != FileMode.TREE && FileMode.fromBits((int)modeTheirs) == FileMode.TREE;
            }
            return FileMode.fromBits((int)(modeBase & modeOurs)) != FileMode.MISSING || FileMode.fromBits((int)(modeBase & modeTheirs)) != FileMode.MISSING;
        }
    }
}

