/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.AUTStartStateMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendAUTListOfSupportedComponentsCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(SendAUTListOfSupportedComponentsCommand.class);
    private SendAUTListOfSupportedComponentsMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (SendAUTListOfSupportedComponentsMessage)message;
    }

    public Message execute() {
        log.info("Entering method " + this.getClass().getName() + ".execute().");
        AUTServerConfiguration serverConfig = AUTServerConfiguration.getInstance();
        serverConfig.setProfile(this.m_message.getProfile());
        List components = this.m_message.getComponents();
        if (components != null) {
            log.info("Processing recevied components from ITE... ");
            for (Component component : components) {
                if (!component.isConcrete()) continue;
                ConcreteComponent concrete = (ConcreteComponent)component;
                try {
                    String testerClass = concrete.getTesterClass();
                    String componentClass = concrete.getComponentClass().getName();
                    if (StringUtils.isEmpty((String)testerClass) && StringUtils.isEmpty((String)componentClass)) continue;
                    serverConfig.registerComponent(concrete);
                }
                catch (IllegalArgumentException e) {
                    log.error("An error occurred while registering a component.", (Throwable)e);
                }
            }
        } else if (this.m_message.getTechTypeToTesterClassMapping() != null) {
            Map techTypeToTesterClassMapping = this.m_message.getTechTypeToTesterClassMapping();
            for (ComponentClass cc : techTypeToTesterClassMapping.keySet()) {
                ConcreteComponent syntheticComponent = new ConcreteComponent();
                syntheticComponent.setComponentClass(cc);
                syntheticComponent.setTesterClass((String)techTypeToTesterClassMapping.get(cc));
                serverConfig.registerComponent(syntheticComponent);
            }
        } else {
            log.error("Insufficient information received in: " + this.getClass().getName());
        }
        log.info("Exiting method " + this.getClass().getName() + ".execute().");
        return new AUTStartStateMessage();
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

