/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.driver;

import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.MouseEvent;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.javafx.driver.DefaultJavaFXEventMatcher;

public class ClickJavaFXEventMatcher
extends DefaultJavaFXEventMatcher<MouseEvent> {
    private ClickOptions m_clickOptions;

    public ClickJavaFXEventMatcher(ClickOptions clickOptions) {
        super(ClickJavaFXEventMatcher.getClickOptionType(clickOptions));
        this.m_clickOptions = clickOptions;
    }

    private static EventType<MouseEvent> getClickOptionType(ClickOptions cOpt) {
        if (cOpt.getClickType() == ClickOptions.ClickType.CLICKED) {
            return MouseEvent.MOUSE_CLICKED;
        }
        return MouseEvent.MOUSE_RELEASED;
    }

    private int getClickCount(Object eventObject) {
        int count = -1;
        if (eventObject instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)eventObject;
            count = e.getClickCount();
        }
        return count;
    }

    private boolean isClickCountMatching(Object eventObject) {
        return this.getClickCount(eventObject) == this.m_clickOptions.getClickCount();
    }

    @Override
    public boolean isMatching(Object event) {
        return this.isClickCountMatching(event);
    }

    @Override
    public boolean isFallBackEventMatching(List eventObjects, Object graphicsComponent) {
        ArrayList<MouseEvent> caughtEvents = new ArrayList<MouseEvent>();
        for (Object object : eventObjects) {
            Event e = (Event)object;
            if (e == null || !e.getEventType().equals(MouseEvent.MOUSE_CLICKED)) continue;
            caughtEvents.add((MouseEvent)e);
        }
        int i = 0;
        while (i < caughtEvents.size()) {
            int clickEventCount = this.getClickCount(caughtEvents.get(i));
            int j = i + 1;
            while (j < caughtEvents.size()) {
                if (((MouseEvent)caughtEvents.get(i)).getSource().equals(((MouseEvent)caughtEvents.get(j)).getSource())) {
                    clickEventCount += this.getClickCount(caughtEvents.get(j));
                }
                ++j;
            }
            if (clickEventCount == this.m_clickOptions.getClickCount()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getName()) + " ClickOptions: " + this.m_clickOptions.toString();
        return str;
    }
}

