/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.tools.internal.utils.generator.Info;

public class ToolkitInfo
extends Info
implements Comparable {
    private String m_type;
    private String m_helpid;
    private String m_shortType;

    public ToolkitInfo(String name, String type) {
        super(name);
        this.m_type = type;
        this.calculateShortType();
        this.setHelpidPrefix();
        this.m_helpid = this.m_shortType.toUpperCase();
    }

    private void calculateShortType() {
        String[] tokens = StringUtils.split((String)this.m_type, (char)'.');
        int tokenLength = tokens.length;
        String shortType = tokenLength > 0 ? tokens[tokenLength - 1] : this.m_type;
        if (shortType.endsWith("ToolkitPlugin")) {
            shortType = StringUtils.left((String)shortType, (int)shortType.indexOf("ToolkitPlugin"));
        }
        this.m_shortType = shortType;
    }

    public String getShortType() {
        return this.m_shortType;
    }

    public String getType() {
        return this.m_type;
    }

    private void setHelpidPrefix() {
        this.m_helpid = this.m_shortType.toUpperCase();
    }

    public String getHelpid() {
        return this.m_helpid;
    }

    public int compareTo(Object o) {
        return this.getI18nName().compareTo(((ToolkitInfo)o).getI18nName());
    }
}

