/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;

public final class RefactoringHistoryImplementation
extends RefactoringHistory {
    private final RefactoringDescriptorProxy[] fDescriptorProxies;
    private boolean fSorted = false;

    private static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            result = 31 * result + (a == null ? 0 : a.hashCode());
            ++n2;
        }
        return result;
    }

    public RefactoringHistoryImplementation(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fDescriptorProxies = new RefactoringDescriptorProxy[proxies.length];
        System.arraycopy(proxies, 0, this.fDescriptorProxies, 0, proxies.length);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RefactoringHistoryImplementation other = (RefactoringHistoryImplementation)((Object)object);
        return Arrays.equals(this.getDescriptors(), other.getDescriptors());
    }

    RefactoringDescriptorProxy[] getDescriptorProxies() {
        return this.fDescriptorProxies;
    }

    @Override
    public RefactoringDescriptorProxy[] getDescriptors() {
        if (!this.fSorted && this.fDescriptorProxies.length > 1) {
            RefactoringHistoryManager.sortRefactoringDescriptorsDescending(this.fDescriptorProxies);
        }
        this.fSorted = true;
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[this.fDescriptorProxies.length];
        System.arraycopy(this.fDescriptorProxies, 0, proxies, 0, this.fDescriptorProxies.length);
        return proxies;
    }

    public int hashCode() {
        return 31 * RefactoringHistoryImplementation.hashCode(this.getDescriptors());
    }

    @Override
    public boolean isEmpty() {
        return this.fDescriptorProxies.length == 0;
    }

    @Override
    public RefactoringHistory removeAll(RefactoringHistory history) {
        LinkedHashSet<RefactoringDescriptorProxy> existing = new LinkedHashSet<RefactoringDescriptorProxy>(Arrays.asList(this.fDescriptorProxies));
        HashSet<RefactoringDescriptorProxy> other = new HashSet<RefactoringDescriptorProxy>(Arrays.asList(history.getDescriptors()));
        existing.removeAll(other);
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[existing.size()];
        existing.toArray(proxies);
        return new RefactoringHistoryImplementation(proxies);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(((Object)((Object)this)).getClass().getName());
        buffer.append("[descriptors=");
        buffer.append(this.getDescriptors().toString());
        buffer.append(']');
        return buffer.toString();
    }
}

