/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ApiDescriptionXmlCreator;
import org.eclipse.pde.api.tools.internal.CompilationUnit;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.CompositeApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.BundleException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class APIFileGenerator {
    public boolean debug;
    public String projectName;
    public String projectLocation;
    public String targetFolder;
    public String binaryLocations;
    public Set<String> apiPackages = new HashSet<String>(0);
    public String manifests;
    public String sourceLocations;
    public boolean allowNonApiProject = false;
    public String encoding;

    private static boolean isZipJarFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(".zip") || normalizedFileName.endsWith(".jar");
    }

    public void generateAPIFile() {
        File root;
        if (this.binaryLocations == null || this.projectName == null || this.projectLocation == null || this.targetFolder == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(NLS.bind((String)CoreMessages.api_generation_printArguments, (Object[])new String[]{this.projectName, this.projectLocation, this.binaryLocations, this.targetFolder}));
            writer.flush();
            writer.close();
            throw new IllegalArgumentException(String.valueOf(out.getBuffer()));
        }
        if (this.debug) {
            System.out.println("Project name : " + this.projectName);
            System.out.println("Encoding: " + this.encoding);
            System.out.println("Project location : " + this.projectLocation);
            System.out.println("Binary locations : " + this.binaryLocations);
            System.out.println("Target folder : " + this.targetFolder);
            if (this.manifests != null) {
                System.out.println("Extra manifest entries : " + this.manifests);
            }
            if (this.sourceLocations != null) {
                System.out.println("Extra source locations entries : " + this.sourceLocations);
            }
        }
        if (!(root = new File(this.projectLocation)).exists() || !root.isDirectory()) {
            if (this.debug) {
                System.err.println("Must be a directory : " + this.projectLocation);
            }
            throw new IllegalArgumentException(NLS.bind((String)CoreMessages.api_generation_projectLocationNotADirectory, (Object)this.projectLocation));
        }
        File dotProjectFile = new File(root, ".project");
        if (!this.allowNonApiProject && !this.isAPIToolsNature(dotProjectFile)) {
            System.err.println("The project does not have an API Tools nature so a api_description file will not be generated");
            return;
        }
        File targetProjectFolder = new File(this.targetFolder);
        if (!targetProjectFolder.exists()) {
            targetProjectFolder.mkdirs();
        } else if (!targetProjectFolder.isDirectory()) {
            if (this.debug) {
                System.err.println("Must be a directory : " + this.targetFolder);
            }
            throw new IllegalArgumentException(NLS.bind((String)CoreMessages.api_generation_targetFolderNotADirectory, (Object)this.targetFolder));
        }
        File apiDescriptionFile = new File(targetProjectFolder, ".api_description");
        if (apiDescriptionFile.exists()) {
            if (this.debug) {
                System.out.println("Existing api description file deleted");
            }
            apiDescriptionFile.delete();
        }
        File[] allFiles = null;
        Map manifestMap = null;
        CompositeApiTypeContainer classFileContainer = null;
        if (!this.projectLocation.endsWith("org.eclipse.swt")) {
            int n;
            String[] allBinaryLocations = this.binaryLocations.split(File.pathSeparator);
            ArrayList<IApiTypeContainer> allContainers = new ArrayList<IApiTypeContainer>();
            IApiTypeContainer container = null;
            String[] stringArray = allBinaryLocations;
            int n2 = allBinaryLocations.length;
            int n3 = 0;
            while (n3 < n2) {
                String allBinaryLocation = stringArray[n3];
                container = this.getContainer(allBinaryLocation);
                if (container == null) {
                    throw new IllegalArgumentException(NLS.bind((String)CoreMessages.api_generation_invalidBinaryLocation, (Object)allBinaryLocation));
                }
                allContainers.add(container);
                ++n3;
            }
            classFileContainer = new CompositeApiTypeContainer(null, allContainers);
            File manifestFile = null;
            File manifestDir = new File(root, "META-INF");
            if (manifestDir.exists() && manifestDir.isDirectory()) {
                manifestFile = new File(manifestDir, "MANIFEST.MF");
            }
            if (manifestFile != null && manifestFile.exists()) {
                try {
                    Throwable throwable = null;
                    stringArray = null;
                    try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(manifestFile));){
                        manifestMap = ManifestElement.parseBundleManifest((InputStream)inputStream, null);
                        this.apiPackages = this.collectApiPackageNames(manifestMap);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | BundleException e) {
                    ApiPlugin.log(e);
                }
            }
            if (this.manifests != null) {
                String[] allManifestFiles;
                String[] stringArray2 = allManifestFiles = this.manifests.split(File.pathSeparator);
                n = allManifestFiles.length;
                int inputStream = 0;
                while (inputStream < n) {
                    Set<String> currentApiPackages;
                    block86: {
                        String allManifestFile = stringArray2[inputStream];
                        File currentManifest = new File(allManifestFile);
                        currentApiPackages = null;
                        if (currentManifest.exists()) {
                            BufferedInputStream inputStream2 = null;
                            ZipFile zipFile = null;
                            try {
                                try {
                                    if (APIFileGenerator.isZipJarFile(currentManifest.getName())) {
                                        zipFile = new ZipFile(currentManifest);
                                        ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                                        if (entry != null) {
                                            inputStream2 = new BufferedInputStream(zipFile.getInputStream(entry));
                                        }
                                    } else {
                                        inputStream2 = new BufferedInputStream(new FileInputStream(currentManifest));
                                    }
                                    if (inputStream2 != null) {
                                        manifestMap = ManifestElement.parseBundleManifest((InputStream)inputStream2, null);
                                        currentApiPackages = this.collectApiPackageNames(manifestMap);
                                    }
                                }
                                catch (IOException | BundleException e) {
                                    ApiPlugin.log(e);
                                    if (inputStream2 != null) {
                                        try {
                                            inputStream2.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (zipFile != null) {
                                        try {
                                            zipFile.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    break block86;
                                }
                            }
                            catch (Throwable throwable) {
                                if (inputStream2 != null) {
                                    try {
                                        inputStream2.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (zipFile != null) {
                                    try {
                                        zipFile.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                            if (inputStream2 != null) {
                                try {
                                    inputStream2.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (currentApiPackages != null) {
                        if (this.apiPackages == null) {
                            this.apiPackages = currentApiPackages;
                        } else {
                            this.apiPackages.addAll(currentApiPackages);
                        }
                    }
                    ++inputStream;
                }
            }
            FileFilter fileFilter = path -> path.isFile() && Util.isJavaFileName(path.getName()) && this.isApi(path.getParent()) || path.isDirectory();
            allFiles = Util.getAllFiles(root, fileFilter);
            if (this.sourceLocations != null) {
                String[] allSourceLocations;
                String[] stringArray3 = allSourceLocations = this.sourceLocations.split(File.pathSeparator);
                int n4 = allSourceLocations.length;
                n = 0;
                while (n < n4) {
                    String currentSourceLocation = stringArray3[n];
                    File[] allFiles2 = Util.getAllFiles(new File(currentSourceLocation), fileFilter);
                    if (allFiles2 != null) {
                        if (allFiles == null) {
                            allFiles = allFiles2;
                        } else {
                            int length = allFiles.length;
                            int length2 = allFiles2.length;
                            File[] fileArray = allFiles;
                            allFiles = new File[length + length2];
                            System.arraycopy(fileArray, 0, allFiles, 0, length);
                            System.arraycopy(allFiles2, 0, allFiles, length, length2);
                        }
                    }
                    ++n;
                }
            }
        }
        ApiDescription apiDescription = new ApiDescription(this.projectName);
        TagScanner tagScanner = TagScanner.newScanner();
        if (allFiles != null && allFiles.length != 0) {
            Hashtable options = JavaCore.getOptions();
            options.put("org.eclipse.jdt.core.compiler.compliance", this.resolveCompliance(manifestMap));
            CompilationUnit unit = null;
            int i = 0;
            int max = allFiles.length;
            while (i < max) {
                block88: {
                    unit = new CompilationUnit(allFiles[i].getAbsolutePath(), this.encoding);
                    if (this.debug) {
                        System.out.println("Unit name[" + i + "] : " + unit.getName());
                    }
                    try {
                        try {
                            tagScanner.scan(unit, apiDescription, classFileContainer, options, null);
                        }
                        catch (CoreException e) {
                            ApiPlugin.log(e);
                            try {
                                if (classFileContainer != null) {
                                    classFileContainer.close();
                                }
                                break block88;
                            }
                            catch (CoreException coreException) {}
                            break block88;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (classFileContainer != null) {
                                classFileContainer.close();
                            }
                        }
                        catch (CoreException coreException) {}
                        throw throwable;
                    }
                    try {
                        if (classFileContainer != null) {
                            classFileContainer.close();
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        try {
            ApiDescriptionXmlCreator xmlVisitor = new ApiDescriptionXmlCreator(this.projectName, this.projectName);
            apiDescription.accept(xmlVisitor, null);
            String xml = xmlVisitor.getXML();
            Util.saveFile(apiDescriptionFile, xml);
        }
        catch (IOException | CoreException e) {
            ApiPlugin.log(e);
        }
    }

    boolean isApi(String path) {
        for (String pkg : this.apiPackages) {
            if (!path.endsWith(pkg.replace('.', File.separatorChar))) continue;
            return true;
        }
        return false;
    }

    private Set<String> collectApiPackageNames(Map<String, String> manifestmap) throws BundleException {
        HashSet<String> set = new HashSet<String>();
        ManifestElement[] packages = ManifestElement.parseHeader((String)"Export-Package", (String)manifestmap.get("Export-Package"));
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                ManifestElement packageName = packages[i];
                Enumeration directiveKeys = packageName.getDirectiveKeys();
                if (directiveKeys == null) {
                    set.add(packageName.getValue());
                } else {
                    boolean include = true;
                    while (directiveKeys.hasMoreElements()) {
                        String value;
                        Object directive = directiveKeys.nextElement();
                        if ("x-internal".equals(directive) && Boolean.parseBoolean(value = packageName.getDirective((String)directive))) {
                            include = false;
                            break;
                        }
                        if (!"x-friends".equals(directive)) continue;
                        include = false;
                        break;
                    }
                    if (include) {
                        set.add(packageName.getValue());
                    }
                }
                ++i;
            }
        }
        return set;
    }

    private IApiTypeContainer getContainer(String location) {
        File f = new File(location);
        if (!f.exists()) {
            return null;
        }
        if (APIFileGenerator.isZipJarFile(location)) {
            return new ArchiveApiTypeContainer(null, location);
        }
        return new DirectoryApiTypeContainer(null, location);
    }

    private String resolveCompliance(Map<String, String> manifestmap) {
        String eename;
        if (manifestmap != null && (eename = manifestmap.get("Bundle-RequiredExecutionEnvironment")) != null) {
            if ("J2SE-1.4".equals(eename)) {
                return "1.4";
            }
            if ("J2SE-1.5".equals(eename)) {
                return "1.5";
            }
            if ("JavaSE-1.6".equals(eename)) {
                return "1.6";
            }
            if ("JavaSE-1.7".equals(eename)) {
                return "1.7";
            }
            if ("JavaSE-1.8".equals(eename)) {
                return "1.8";
            }
        }
        return "1.3";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAPIToolsNature(File dotProjectFile) {
        if (!dotProjectFile.exists()) {
            return false;
        }
        BufferedInputStream stream = null;
        stream = new BufferedInputStream(new FileInputStream(dotProjectFile));
        String contents = new String(Util.getInputStreamAsCharArray((InputStream)stream, -1, StandardCharsets.UTF_8));
        boolean bl = this.containsAPIToolsNature(contents);
        if (stream == null) return bl;
        try {
            stream.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException e) {
            try {
                e.printStackTrace();
                if (stream == null) return false;
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    private boolean containsAPIToolsNature(String pluginXMLContents) {
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException exception) {}
        if (saxParser == null) {
            return false;
        }
        InputSource inputSource = new InputSource(new BufferedReader(new StringReader(pluginXMLContents)));
        try {
            APIToolsNatureDefaultHandler defaultHandler = new APIToolsNatureDefaultHandler();
            saxParser.parse(inputSource, (DefaultHandler)defaultHandler);
            return defaultHandler.isAPIToolsNature();
        }
        catch (IOException | SAXException exception) {
            return false;
        }
    }

    static class APIToolsNatureDefaultHandler
    extends DefaultHandler {
        private static final String NATURE_ELEMENT_NAME = "nature";
        boolean isAPIToolsNature = false;
        boolean insideNature = false;
        StringBuilder buffer;

        APIToolsNatureDefaultHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            e.printStackTrace();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.isAPIToolsNature) {
                return;
            }
            this.insideNature = NATURE_ELEMENT_NAME.equals(name);
            if (this.insideNature) {
                this.buffer = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideNature) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.insideNature) {
                String natureName = String.valueOf(this.buffer).trim();
                this.isAPIToolsNature = "org.eclipse.pde.api.tools.apiAnalysisNature".equals(natureName);
            }
            this.insideNature = false;
        }

        public boolean isAPIToolsNature() {
            return this.isAPIToolsNature;
        }
    }
}

