/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.javaeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.workbench.handler.TextEditorHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaEditorHandler
extends TextEditorHandler {
    private static JavaEditorHandler instance;

    public static JavaEditorHandler getInstance() {
        if (instance == null) {
            instance = new JavaEditorHandler();
        }
        return instance;
    }

    public IToggleBreakpointsTargetExtension getToggleBreakpointAdapter(ITextEditor textEditor) {
        return (IToggleBreakpointsTargetExtension)DebugPlugin.getAdapter((Object)textEditor, IToggleBreakpointsTarget.class);
    }

    public void toggleBreakpoint(final ITextEditor textEditor, int lineNumber) {
        if (lineNumber < 0) {
            throw new IllegalArgumentException("The line number cannot be negative.");
        }
        this.selectLine(textEditor, lineNumber);
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ISelection selection = textEditor.getEditorSite().getSelectionProvider().getSelection();
                try {
                    JavaEditorHandler.this.getToggleBreakpointAdapter(textEditor).toggleBreakpoints((IWorkbenchPart)textEditor, selection);
                }
                catch (CoreException coreException) {
                    throw new RedDeerException("Cannot toggle a breakpoint.");
                }
            }
        });
    }

    public List<IBreakpoint> getBreakpoints(ITextEditor textEditor) {
        return this.getBreakpoints(textEditor, -1);
    }

    public List<IBreakpoint> getBreakpoints(ITextEditor textEditor, int lineNumber) {
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
        IResource resource = ResourceUtil.getResource((IEditorInput)textEditor.getEditorInput());
        IBreakpoint[] iBreakpointArray = this.getAllBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint.getMarker().getResource().equals((Object)resource)) {
                if (lineNumber >= 0) {
                    int offset;
                    try {
                        offset = Integer.parseInt(breakpoint.getMarker().getAttribute("charStart").toString());
                    }
                    catch (CoreException coreException) {
                        throw new RedDeerException("Cannot get breakpoint's attribute 'charStart'.");
                    }
                    if (lineNumber == this.getLineOfOffest(textEditor, offset)) {
                        breakpoints.add(breakpoint);
                    }
                } else {
                    breakpoints.add(breakpoint);
                }
            }
            ++n2;
        }
        return breakpoints;
    }

    public IBreakpoint getBreakpoint(ITextEditor textEditor, int lineNumber) {
        if (lineNumber < 0) {
            throw new IllegalArgumentException("The line number cannot be negative.");
        }
        List<IBreakpoint> breakpoints = this.getBreakpoints(textEditor, lineNumber);
        return breakpoints.isEmpty() ? null : breakpoints.get(0);
    }

    public IBreakpoint[] getAllBreakpoints() {
        return (IBreakpoint[])Display.syncExec((ResultRunnable)new ResultRunnable<IBreakpoint[]>(){

            public IBreakpoint[] run() {
                return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            }
        });
    }
}

