/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class SurroundWithTemplateProposal
extends TemplateProposal {
    private final IRegion fRegion;
    private final IJavaScriptUnit fCompilationUnit;
    private final CompilationUnitContext fContext;
    private final Template fTemplate;
    private final Statement[] fSelectedStatements;
    private TemplateProposal fProposal;
    private IRegion fSelectedRegion;

    public SurroundWithTemplateProposal(IJavaScriptUnit compilationUnit, Template template, CompilationUnitContext context, IRegion region, Image image, Statement[] selectedStatements) {
        super(template, (TemplateContext)context, region, image);
        this.fCompilationUnit = compilationUnit;
        this.fTemplate = template;
        this.fContext = context;
        this.fRegion = region;
        this.fSelectedStatements = selectedStatements;
    }

    public String getPreviewContent() {
        TemplateBuffer templateBuffer;
        Document document = new Document(this.fCompilationUnit.getBuffer().getContents());
        CompilationUnitContext context = this.createNewContext((IDocument)document);
        int offset = context.getCompletionOffset();
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        context.setReadOnly(false);
        try {
            templateBuffer = context.evaluate(this.fTemplate);
        }
        catch (TemplateException e1) {
            JavaScriptPlugin.log(e1);
            return null;
        }
        try {
            start = region.getOffset();
            end = region.getOffset() + region.getLength();
            end = Math.max(end, offset);
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            return document.get();
        }
        catch (MalformedTreeException e) {
            JavaScriptPlugin.log(e);
        }
        catch (IllegalArgumentException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setRedraw(ITextViewer viewer, boolean redraw) {
        if (viewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)viewer;
            IRewriteTarget target = extension.getRewriteTarget();
            target.setRedraw(redraw);
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion != null) {
            return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
        }
        if (this.fProposal != null) {
            return this.fProposal.getSelection(document);
        }
        return null;
    }

    private CompilationUnitContext createNewContext(IDocument document) throws CoreException, BadLocationException {
        AssistContext invocationContext = new AssistContext(this.fCompilationUnit, this.fContext.getStart(), this.fContext.getEnd() - this.fContext.getStart());
        SurroundWithTemplate surroundWith = new SurroundWithTemplate(invocationContext, this.fSelectedStatements, this.fTemplate);
        Map options = this.fCompilationUnit.getJavaScriptProject().getOptions(true);
        surroundWith.getRewrite().rewriteAST(document, options).apply(document);
        int offset = surroundWith.getBodyStart();
        int length = surroundWith.getBodyLength();
        String newSelection = document.get(offset, length);
        CompilationUnitContextType contextType = (CompilationUnitContextType)JavaScriptPlugin.getDefault().getTemplateContextRegistry().getContextType("javaScript");
        CompilationUnitContext context = contextType.createContext(document, offset, newSelection.length(), this.fCompilationUnit);
        context.setVariable("selection", newSelection);
        context.setForceEvaluation(true);
        return context;
    }

    private void handleException(ITextViewer viewer, Exception e, IRegion region) {
        JavaScriptPlugin.log(e);
        this.openErrorDialog(viewer.getTextWidget().getShell(), e);
        this.fSelectedRegion = region;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.TemplateEvaluator_error_title, (String)e.getMessage());
    }

    @Override
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }

    private static class SurroundWithTemplate
    extends SurroundWith {
        private static final String $_LINE_SELECTION = "${line_selection}";
        private final Template fTemplate;
        private final IJavaScriptProject fCurrentProject;
        private ASTNode fTemplateNode;

        public SurroundWithTemplate(IInvocationContext context, Statement[] selectedNodes, Template template) {
            super(context.getASTRoot(), selectedNodes);
            this.fTemplate = template;
            this.fCurrentProject = context.getCompilationUnit().getJavaScriptProject();
        }

        @Override
        protected List getVariableDeclarationReadsInside(Statement[] selectedNodes, int maxVariableId) {
            if (this.isNewContext()) {
                return super.getVariableDeclarationReadsInside(selectedNodes, maxVariableId);
            }
            return new ArrayList();
        }

        @Override
        protected boolean isNewContext() {
            String template = this.fTemplate.getPattern();
            int currentPosition = template.indexOf($_LINE_SELECTION);
            int insertionPosition = -1;
            while (currentPosition != -1) {
                insertionPosition = currentPosition;
                template = template.replaceFirst("\\$\\{[^\\}]*\\}", "");
                currentPosition = template.indexOf($_LINE_SELECTION);
            }
            template = template.replaceAll("\\$\\{[^\\}]*\\}", "");
            AST ast = this.getAst();
            ASTParser parser = ASTParser.newParser((int)ast.apiLevel());
            parser.setSource(template.toCharArray());
            parser.setProject(this.fCurrentProject);
            parser.setKind(2);
            ASTNode root = parser.createAST(null);
            if (((Block)root).statements().isEmpty()) {
                parser = ASTParser.newParser((int)ast.apiLevel());
                parser.setSource(template.toCharArray());
                parser.setProject(this.fCurrentProject);
                parser.setKind(1);
                root = parser.createAST(null);
            }
            final int lineSelectionPosition = insertionPosition;
            root.accept((ASTVisitor)new GenericVisitor(){

                @Override
                public void endVisit(Block node) {
                    super.endVisit(node);
                    if (fTemplateNode == null && node.getStartPosition() <= lineSelectionPosition && node.getLength() + node.getStartPosition() >= lineSelectionPosition) {
                        fTemplateNode = (ASTNode)node;
                    }
                }
            });
            return this.fTemplateNode != null && ASTNodes.getParent(this.fTemplateNode, FunctionDeclaration.class) != null;
        }
    }
}

